/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class SipDetails
implements Parcelable {
    public static final int METHOD_UNKNOWN = 0;
    public static final int METHOD_REGISTER = 1;
    public static final int METHOD_PUBLISH = 2;
    public static final int METHOD_SUBSCRIBE = 3;
    private final int mMethod;
    private final int mCseq;
    private final int mResponseCode;
    @NonNull
    private final String mResponsePhrase;
    private final int mReasonHeaderCause;
    @NonNull
    private final String mReasonHeaderText;
    @Nullable
    private final String mCallId;
    @NonNull
    public static final Parcelable.Creator<SipDetails> CREATOR = new Parcelable.Creator<SipDetails>(){

        @Override
        public SipDetails createFromParcel(Parcel source) {
            return new SipDetails(source);
        }

        public SipDetails[] newArray(int size) {
            return new SipDetails[size];
        }
    };

    private SipDetails(Builder builder) {
        this.mMethod = builder.mMethod;
        this.mCseq = builder.mCseq;
        this.mResponseCode = builder.mResponseCode;
        this.mResponsePhrase = builder.mResponsePhrase;
        this.mReasonHeaderCause = builder.mReasonHeaderCause;
        this.mReasonHeaderText = builder.mReasonHeaderText;
        this.mCallId = builder.mCallId;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public int getCSeq() {
        return this.mCseq;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    @NonNull
    public String getResponsePhrase() {
        return this.mResponsePhrase;
    }

    public int getReasonHeaderCause() {
        return this.mReasonHeaderCause;
    }

    @NonNull
    public String getReasonHeaderText() {
        return this.mReasonHeaderText;
    }

    @Nullable
    public String getCallId() {
        return this.mCallId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mMethod);
        dest.writeInt(this.mCseq);
        dest.writeInt(this.mResponseCode);
        dest.writeString(this.mResponsePhrase);
        dest.writeInt(this.mReasonHeaderCause);
        dest.writeString(this.mReasonHeaderText);
        dest.writeString(this.mCallId);
    }

    private SipDetails(Parcel in) {
        this.mMethod = in.readInt();
        this.mCseq = in.readInt();
        this.mResponseCode = in.readInt();
        this.mResponsePhrase = in.readString();
        this.mReasonHeaderCause = in.readInt();
        this.mReasonHeaderText = in.readString();
        this.mCallId = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SipDetails that = (SipDetails)o;
        return this.mMethod == that.mMethod && this.mCseq == that.mCseq && this.mResponseCode == that.mResponseCode && TextUtils.equals(this.mResponsePhrase, that.mResponsePhrase) && this.mReasonHeaderCause == that.mReasonHeaderCause && TextUtils.equals(this.mReasonHeaderText, that.mReasonHeaderText) && TextUtils.equals(this.mCallId, that.mCallId);
    }

    public int hashCode() {
        return Objects.hash(this.mMethod, this.mCseq, this.mResponseCode, this.mResponsePhrase, this.mReasonHeaderCause, this.mReasonHeaderText, this.mCallId);
    }

    public String toString() {
        return "SipDetails { methodType= " + this.mMethod + ", cSeq=" + this.mCseq + ", ResponseCode=" + this.mResponseCode + ", ResponseCPhrase=" + this.mResponsePhrase + ", ReasonHeaderCause=" + this.mReasonHeaderCause + ", ReasonHeaderText=" + this.mReasonHeaderText + ", callId=" + this.mCallId + "}";
    }

    public static class Builder {
        private int mMethod;
        private int mCseq = 0;
        private int mResponseCode = 0;
        private String mResponsePhrase = "";
        private int mReasonHeaderCause = 0;
        private String mReasonHeaderText = "";
        @Nullable
        private String mCallId;

        public Builder(int method) {
            this.mMethod = method;
        }

        @NonNull
        public Builder setCSeq(int cSeq) {
            this.mCseq = cSeq;
            return this;
        }

        public Builder setSipResponseCode(int responseCode, @NonNull String responsePhrase) {
            this.mResponseCode = responseCode;
            this.mResponsePhrase = responsePhrase;
            return this;
        }

        public Builder setSipResponseReasonHeader(int reasonHeaderCause, @NonNull String reasonHeaderText) {
            this.mReasonHeaderCause = reasonHeaderCause;
            this.mReasonHeaderText = reasonHeaderText;
            return this;
        }

        @NonNull
        public Builder setCallId(@NonNull String callId) {
            this.mCallId = callId;
            return this;
        }

        @NonNull
        public SipDetails build() {
            return new SipDetails(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Method {
    }
}

