/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.MediaQualityStatus;
import android.telephony.ims.aidl.IImsCallSessionListener;
import android.telephony.ims.aidl.IImsTrafficSessionCallback;
import com.android.ims.internal.IImsCallSession;

public interface IImsMmTelListener
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsMmTelListener";

    public IImsCallSessionListener onIncomingCall(IImsCallSession var1, String var2, Bundle var3) throws RemoteException;

    public void onRejectedCall(ImsCallProfile var1, ImsReasonInfo var2) throws RemoteException;

    public void onVoiceMessageCountUpdate(int var1) throws RemoteException;

    public void onAudioModeIsVoipChanged(int var1) throws RemoteException;

    public void onTriggerEpsFallback(int var1) throws RemoteException;

    public void onStartImsTrafficSession(int var1, int var2, int var3, int var4, IImsTrafficSessionCallback var5) throws RemoteException;

    public void onModifyImsTrafficSession(int var1, int var2) throws RemoteException;

    public void onStopImsTrafficSession(int var1) throws RemoteException;

    public void onMediaQualityStatusChanged(MediaQualityStatus var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsMmTelListener {
        static final int TRANSACTION_onIncomingCall = 1;
        static final int TRANSACTION_onRejectedCall = 2;
        static final int TRANSACTION_onVoiceMessageCountUpdate = 3;
        static final int TRANSACTION_onAudioModeIsVoipChanged = 4;
        static final int TRANSACTION_onTriggerEpsFallback = 5;
        static final int TRANSACTION_onStartImsTrafficSession = 6;
        static final int TRANSACTION_onModifyImsTrafficSession = 7;
        static final int TRANSACTION_onStopImsTrafficSession = 8;
        static final int TRANSACTION_onMediaQualityStatusChanged = 9;

        public Stub() {
            this.attachInterface(this, IImsMmTelListener.DESCRIPTOR);
        }

        public static IImsMmTelListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsMmTelListener.DESCRIPTOR);
            if (iin != null && iin instanceof IImsMmTelListener) {
                return (IImsMmTelListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onIncomingCall";
                }
                case 2: {
                    return "onRejectedCall";
                }
                case 3: {
                    return "onVoiceMessageCountUpdate";
                }
                case 4: {
                    return "onAudioModeIsVoipChanged";
                }
                case 5: {
                    return "onTriggerEpsFallback";
                }
                case 6: {
                    return "onStartImsTrafficSession";
                }
                case 7: {
                    return "onModifyImsTrafficSession";
                }
                case 8: {
                    return "onStopImsTrafficSession";
                }
                case 9: {
                    return "onMediaQualityStatusChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsMmTelListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IImsCallSession _arg0 = IImsCallSession.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    IImsCallSessionListener _result = this.onIncomingCall(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    ImsReasonInfo _arg1 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRejectedCall(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVoiceMessageCountUpdate(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAudioModeIsVoipChanged(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTriggerEpsFallback(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IImsTrafficSessionCallback _arg4 = IImsTrafficSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onStartImsTrafficSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onModifyImsTrafficSession(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStopImsTrafficSession(_arg0);
                    break;
                }
                case 9: {
                    MediaQualityStatus _arg0 = data.readTypedObject(MediaQualityStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMediaQualityStatusChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IImsMmTelListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsMmTelListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsCallSessionListener onIncomingCall(IImsCallSession c, String callId, Bundle extras) throws RemoteException {
                IImsCallSessionListener _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeStrongInterface(c);
                    _data.writeString(callId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IImsCallSessionListener.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeTypedObject(callProfile, 0);
                    _data.writeTypedObject(reason, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVoiceMessageCountUpdate(int count) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeInt(count);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioModeIsVoipChanged(int imsAudioHandler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeInt(imsAudioHandler);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTriggerEpsFallback(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartImsTrafficSession(int token, int trafficType, int accessNetworkType, int trafficDirection, IImsTrafficSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeInt(trafficType);
                    _data.writeInt(accessNetworkType);
                    _data.writeInt(trafficDirection);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onModifyImsTrafficSession(int token, int accessNetworkType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeInt(accessNetworkType);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopImsTrafficSession(int token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeInt(token);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMediaQualityStatusChanged(MediaQualityStatus status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsMmTelListener.DESCRIPTOR);
                    _data.writeTypedObject(status, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsMmTelListener {
        @Override
        public IImsCallSessionListener onIncomingCall(IImsCallSession c, String callId, Bundle extras) throws RemoteException {
            return null;
        }

        @Override
        public void onRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) throws RemoteException {
        }

        @Override
        public void onVoiceMessageCountUpdate(int count) throws RemoteException {
        }

        @Override
        public void onAudioModeIsVoipChanged(int imsAudioHandler) throws RemoteException {
        }

        @Override
        public void onTriggerEpsFallback(int reason) throws RemoteException {
        }

        @Override
        public void onStartImsTrafficSession(int token, int trafficType, int accessNetworkType, int trafficDirection, IImsTrafficSessionCallback callback) throws RemoteException {
        }

        @Override
        public void onModifyImsTrafficSession(int token, int accessNetworkType) throws RemoteException {
        }

        @Override
        public void onStopImsTrafficSession(int token) throws RemoteException {
        }

        @Override
        public void onMediaQualityStatusChanged(MediaQualityStatus status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

