/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
public class SatellitePosition
implements Parcelable {
    private double mLongitudeDegree;
    private double mAltitudeKm;
    @NonNull
    public static final Parcelable.Creator<SatellitePosition> CREATOR = new Parcelable.Creator<SatellitePosition>(){

        @Override
        public SatellitePosition createFromParcel(Parcel in) {
            return new SatellitePosition(in);
        }

        public SatellitePosition[] newArray(int size) {
            return new SatellitePosition[size];
        }
    };

    public SatellitePosition(Parcel in) {
        this.mLongitudeDegree = in.readDouble();
        this.mAltitudeKm = in.readDouble();
    }

    public SatellitePosition(double longitudeDegree, double altitudeKm) {
        this.mLongitudeDegree = longitudeDegree;
        this.mAltitudeKm = altitudeKm;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeDouble(this.mLongitudeDegree);
        dest.writeDouble(this.mAltitudeKm);
    }

    public double getLongitudeDegrees() {
        return this.mLongitudeDegree;
    }

    public double getAltitudeKm() {
        return this.mAltitudeKm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SatellitePosition)) {
            return false;
        }
        SatellitePosition that = (SatellitePosition)o;
        return Double.compare(that.mLongitudeDegree, this.mLongitudeDegree) == 0 && Double.compare(that.mAltitudeKm, this.mAltitudeKm) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.mLongitudeDegree, this.mAltitudeKm);
    }

    @NonNull
    public String toString() {
        return "mLongitudeDegree: " + this.mLongitudeDegree + ", mAltitudeKm: " + this.mAltitudeKm;
    }
}

