/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SatelliteSessionStats
implements Parcelable {
    private int mCountOfSuccessfulUserMessages;
    private int mCountOfUnsuccessfulUserMessages;
    private int mCountOfTimedOutUserMessagesWaitingForConnection;
    private int mCountOfTimedOutUserMessagesWaitingForAck;
    private int mCountOfUserMessagesInQueueToBeSent;
    private long mLatencyOfSuccessfulUserMessages;
    private Map<Integer, SatelliteSessionStats> datagramStats;
    private long mMaxLatency;
    private long mLastMessageLatency;
    @NonNull
    public static final Parcelable.Creator<SatelliteSessionStats> CREATOR = new Parcelable.Creator<SatelliteSessionStats>(){

        @Override
        public SatelliteSessionStats createFromParcel(Parcel in) {
            return new SatelliteSessionStats(in);
        }

        public SatelliteSessionStats[] newArray(int size) {
            return new SatelliteSessionStats[size];
        }
    };

    public SatelliteSessionStats() {
        this.datagramStats = new HashMap<Integer, SatelliteSessionStats>();
    }

    public SatelliteSessionStats(@NonNull Builder builder) {
        this.mCountOfSuccessfulUserMessages = builder.mCountOfSuccessfulUserMessages;
        this.mCountOfUnsuccessfulUserMessages = builder.mCountOfUnsuccessfulUserMessages;
        this.mCountOfTimedOutUserMessagesWaitingForConnection = builder.mCountOfTimedOutUserMessagesWaitingForConnection;
        this.mCountOfTimedOutUserMessagesWaitingForAck = builder.mCountOfTimedOutUserMessagesWaitingForAck;
        this.mCountOfUserMessagesInQueueToBeSent = builder.mCountOfUserMessagesInQueueToBeSent;
        this.mLatencyOfSuccessfulUserMessages = builder.mLatencyOfSuccessfulUserMessages;
    }

    private SatelliteSessionStats(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mCountOfSuccessfulUserMessages);
        out.writeInt(this.mCountOfUnsuccessfulUserMessages);
        out.writeInt(this.mCountOfTimedOutUserMessagesWaitingForConnection);
        out.writeInt(this.mCountOfTimedOutUserMessagesWaitingForAck);
        out.writeInt(this.mCountOfUserMessagesInQueueToBeSent);
        out.writeLong(this.mLatencyOfSuccessfulUserMessages);
        out.writeLong(this.mMaxLatency);
        out.writeLong(this.mLastMessageLatency);
        if (this.datagramStats != null && !this.datagramStats.isEmpty()) {
            out.writeInt(this.datagramStats.size());
            for (Map.Entry<Integer, SatelliteSessionStats> entry : this.datagramStats.entrySet()) {
                out.writeInt(entry.getKey());
                out.writeParcelable(entry.getValue(), flags);
            }
        } else {
            out.writeInt(0);
        }
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.datagramStats != null) {
            sb.append(" ====== SatelliteSessionStatsWrapper Info =============");
            for (Map.Entry<Integer, SatelliteSessionStats> entry : this.datagramStats.entrySet()) {
                Integer key = entry.getKey();
                SatelliteSessionStats value = entry.getValue();
                sb.append("\n");
                sb.append("Key:");
                sb.append(key);
                sb.append(", SatelliteSessionStats:[");
                value.getPrintableCounters(sb);
                sb.append(",");
                sb.append(" LatencyOfSuccessfulUserMessages:");
                sb.append(value.mLatencyOfSuccessfulUserMessages);
                sb.append(",");
                sb.append(" mMaxLatency:");
                sb.append(value.mMaxLatency);
                sb.append(",");
                sb.append(" mLastMessageLatency:");
                sb.append(value.mLastMessageLatency);
                sb.append("]");
                sb.append("\n");
            }
            sb.append(" ============== ================== ===============");
            sb.append("\n");
            sb.append("\n");
        } else {
            sb.append("\n");
            this.getPrintableCounters(sb);
        }
        sb.append("\n");
        return sb.toString();
    }

    private void getPrintableCounters(StringBuilder sb) {
        sb.append("countOfSuccessfulUserMessages:");
        sb.append(this.mCountOfSuccessfulUserMessages);
        sb.append(",");
        sb.append("countOfUnsuccessfulUserMessages:");
        sb.append(this.mCountOfUnsuccessfulUserMessages);
        sb.append(",");
        sb.append("countOfTimedOutUserMessagesWaitingForConnection:");
        sb.append(this.mCountOfTimedOutUserMessagesWaitingForConnection);
        sb.append(",");
        sb.append("countOfTimedOutUserMessagesWaitingForAck:");
        sb.append(this.mCountOfTimedOutUserMessagesWaitingForAck);
        sb.append(",");
        sb.append("countOfUserMessagesInQueueToBeSent:");
        sb.append(this.mCountOfUserMessagesInQueueToBeSent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SatelliteSessionStats that = (SatelliteSessionStats)o;
        return this.mCountOfSuccessfulUserMessages == that.mCountOfSuccessfulUserMessages && this.mLatencyOfSuccessfulUserMessages == that.mLatencyOfSuccessfulUserMessages && this.mCountOfUnsuccessfulUserMessages == that.mCountOfUnsuccessfulUserMessages && this.mCountOfTimedOutUserMessagesWaitingForConnection == that.mCountOfTimedOutUserMessagesWaitingForConnection && this.mCountOfTimedOutUserMessagesWaitingForAck == that.mCountOfTimedOutUserMessagesWaitingForAck && this.mCountOfUserMessagesInQueueToBeSent == that.mCountOfUserMessagesInQueueToBeSent;
    }

    public int hashCode() {
        return Objects.hash(this.mCountOfSuccessfulUserMessages, this.mLatencyOfSuccessfulUserMessages, this.mCountOfUnsuccessfulUserMessages, this.mCountOfTimedOutUserMessagesWaitingForConnection, this.mCountOfTimedOutUserMessagesWaitingForAck, this.mCountOfUserMessagesInQueueToBeSent);
    }

    public int getCountOfSuccessfulUserMessages() {
        return this.mCountOfSuccessfulUserMessages;
    }

    public void incrementSuccessfulUserMessageCount() {
        ++this.mCountOfSuccessfulUserMessages;
    }

    public int getCountOfUnsuccessfulUserMessages() {
        return this.mCountOfUnsuccessfulUserMessages;
    }

    public void incrementUnsuccessfulUserMessageCount() {
        ++this.mCountOfUnsuccessfulUserMessages;
    }

    public int getCountOfTimedOutUserMessagesWaitingForConnection() {
        return this.mCountOfTimedOutUserMessagesWaitingForConnection;
    }

    public void incrementTimedOutUserMessagesWaitingForConnection() {
        ++this.mCountOfTimedOutUserMessagesWaitingForConnection;
    }

    public int getCountOfTimedOutUserMessagesWaitingForAck() {
        return this.mCountOfTimedOutUserMessagesWaitingForAck;
    }

    public void incrementTimedOutUserMessagesWaitingForAck() {
        ++this.mCountOfTimedOutUserMessagesWaitingForAck;
    }

    public int getCountOfUserMessagesInQueueToBeSent() {
        return this.mCountOfUserMessagesInQueueToBeSent;
    }

    public void incrementUserMessagesInQueueToBeSent() {
        ++this.mCountOfUserMessagesInQueueToBeSent;
    }

    public long getLatencyOfAllSuccessfulUserMessages() {
        return this.mLatencyOfSuccessfulUserMessages;
    }

    public void updateLatencyOfAllSuccessfulUserMessages(long messageLatency) {
        this.mLatencyOfSuccessfulUserMessages += messageLatency;
    }

    public void recordSuccessfulOutgoingDatagramStats(int datagramType, long latency) {
        try {
            this.datagramStats.putIfAbsent(datagramType, new Builder().build());
            SatelliteSessionStats data = this.datagramStats.get(datagramType);
            data.incrementSuccessfulUserMessageCount();
            if (data.mMaxLatency < latency) {
                data.mMaxLatency = latency;
            }
            data.mLastMessageLatency = latency;
            data.updateLatencyOfAllSuccessfulUserMessages(latency);
        }
        catch (Exception e) {
            Log.e("SatelliteSessionStats", "Error while recordSuccessfulOutgoingDatagramStats: " + e.getMessage());
        }
    }

    public void resetCountOfUserMessagesInQueueToBeSent() {
        for (Map.Entry<Integer, SatelliteSessionStats> entry : this.datagramStats.entrySet()) {
            SatelliteSessionStats statsPerDatagramType = entry.getValue();
            statsPerDatagramType.mCountOfUserMessagesInQueueToBeSent = 0;
        }
    }

    public int getCountOfSuccessfulOutgoingDatagram(int datagramType) {
        SatelliteSessionStats data = this.datagramStats.getOrDefault(datagramType, new SatelliteSessionStats());
        return data.getCountOfSuccessfulUserMessages();
    }

    public long getMaxLatency() {
        return this.mMaxLatency;
    }

    public Long getLatencyOfAllSuccessfulUserMessages(int datagramType) {
        SatelliteSessionStats data = this.datagramStats.getOrDefault(datagramType, new SatelliteSessionStats());
        return data.getLatencyOfAllSuccessfulUserMessages();
    }

    public long getLastMessageLatency() {
        return this.mLastMessageLatency;
    }

    public void addCountOfUnsuccessfulUserMessages(int datagramType, int resultCode) {
        try {
            this.datagramStats.putIfAbsent(datagramType, new Builder().build());
            SatelliteSessionStats data = this.datagramStats.get(datagramType);
            data.incrementUnsuccessfulUserMessageCount();
            if (resultCode == 18) {
                data.incrementTimedOutUserMessagesWaitingForConnection();
            } else if (resultCode == 24) {
                data.incrementTimedOutUserMessagesWaitingForAck();
            }
        }
        catch (Exception e) {
            Log.e("SatelliteSessionStats", "Error while addCountOfUnsuccessfulUserMessages: " + e.getMessage());
        }
    }

    public void updateCountOfUserMessagesInQueueToBeSent(int datagramType) {
        try {
            this.datagramStats.putIfAbsent(datagramType, new Builder().build());
            SatelliteSessionStats data = this.datagramStats.get(datagramType);
            data.incrementUserMessagesInQueueToBeSent();
        }
        catch (Exception e) {
            Log.e("SatelliteSessionStats", "Error while addCountOfUserMessagesInQueueToBeSent: " + e.getMessage());
        }
    }

    public int getCountOfUnsuccessfulUserMessages(int datagramType) {
        SatelliteSessionStats data = this.datagramStats.get(datagramType);
        return data.getCountOfUnsuccessfulUserMessages();
    }

    public int getCountOfTimedOutUserMessagesWaitingForConnection(int datagramType) {
        SatelliteSessionStats data = this.datagramStats.get(datagramType);
        return data.getCountOfTimedOutUserMessagesWaitingForConnection();
    }

    public int getCountOfTimedOutUserMessagesWaitingForAck(int datagramType) {
        SatelliteSessionStats data = this.datagramStats.get(datagramType);
        return data.getCountOfTimedOutUserMessagesWaitingForAck();
    }

    public int getCountOfUserMessagesInQueueToBeSent(int datagramType) {
        SatelliteSessionStats data = this.datagramStats.get(datagramType);
        return data.getCountOfUserMessagesInQueueToBeSent();
    }

    public void clear() {
        this.datagramStats.clear();
    }

    public Map<Integer, SatelliteSessionStats> getSatelliteSessionStats() {
        return this.datagramStats;
    }

    public void setSatelliteSessionStats(Map<Integer, SatelliteSessionStats> sessionStats) {
        this.datagramStats = sessionStats;
    }

    private void readFromParcel(Parcel in) {
        this.mCountOfSuccessfulUserMessages = in.readInt();
        this.mCountOfUnsuccessfulUserMessages = in.readInt();
        this.mCountOfTimedOutUserMessagesWaitingForConnection = in.readInt();
        this.mCountOfTimedOutUserMessagesWaitingForAck = in.readInt();
        this.mCountOfUserMessagesInQueueToBeSent = in.readInt();
        this.mLatencyOfSuccessfulUserMessages = in.readLong();
        this.mMaxLatency = in.readLong();
        this.mLastMessageLatency = in.readLong();
        int size = in.readInt();
        this.datagramStats = new HashMap<Integer, SatelliteSessionStats>();
        for (int i = 0; i < size; ++i) {
            Integer key = in.readInt();
            SatelliteSessionStats value = (SatelliteSessionStats)in.readParcelable(SatelliteSessionStats.class.getClassLoader());
            this.datagramStats.put(key, value);
        }
    }

    public static class Builder {
        private int mCountOfSuccessfulUserMessages;
        private int mCountOfUnsuccessfulUserMessages;
        private int mCountOfTimedOutUserMessagesWaitingForConnection;
        private int mCountOfTimedOutUserMessagesWaitingForAck;
        private int mCountOfUserMessagesInQueueToBeSent;
        private long mLatencyOfSuccessfulUserMessages;
        private long mMaxLatency;
        private long mLastMessageLatency;

        @NonNull
        public Builder setCountOfSuccessfulUserMessages(int count) {
            this.mCountOfSuccessfulUserMessages = count;
            return this;
        }

        @NonNull
        public Builder setCountOfUnsuccessfulUserMessages(int count) {
            this.mCountOfUnsuccessfulUserMessages = count;
            return this;
        }

        @NonNull
        public Builder setCountOfTimedOutUserMessagesWaitingForConnection(int count) {
            this.mCountOfTimedOutUserMessagesWaitingForConnection = count;
            return this;
        }

        @NonNull
        public Builder setCountOfTimedOutUserMessagesWaitingForAck(int count) {
            this.mCountOfTimedOutUserMessagesWaitingForAck = count;
            return this;
        }

        @NonNull
        public Builder setCountOfUserMessagesInQueueToBeSent(int count) {
            this.mCountOfUserMessagesInQueueToBeSent = count;
            return this;
        }

        @NonNull
        public Builder setLatencyOfSuccessfulUserMessages(long latency) {
            this.mLatencyOfSuccessfulUserMessages = latency;
            return this;
        }

        @NonNull
        public Builder setMaxLatency(long maxLatency) {
            this.mMaxLatency = maxLatency;
            return this;
        }

        @NonNull
        public Builder setLastLatency(long lastLatency) {
            this.mLastMessageLatency = lastLatency;
            return this;
        }

        @NonNull
        public SatelliteSessionStats build() {
            return new SatelliteSessionStats(this);
        }
    }
}

