/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;

@RavenwoodKeepWholeClass
class PackedObjectVector<E> {
    private int mColumns;
    private int mRows;
    private int mRowGapStart;
    private int mRowGapLength;
    private Object[] mValues;

    public PackedObjectVector(int columns) {
        this.mColumns = columns;
        this.mValues = EmptyArray.OBJECT;
        this.mRows = 0;
        this.mRowGapStart = 0;
        this.mRowGapLength = this.mRows;
    }

    public E getValue(int row, int column) {
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        Object value = this.mValues[row * this.mColumns + column];
        return (E)value;
    }

    public void setValue(int row, int column, E value) {
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        this.mValues[row * this.mColumns + column] = value;
    }

    public void insertAt(int row, E[] values) {
        this.moveRowGapTo(row);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        ++this.mRowGapStart;
        --this.mRowGapLength;
        if (values == null) {
            for (int i = 0; i < this.mColumns; ++i) {
                this.setValue(row, i, null);
            }
        } else {
            for (int i = 0; i < this.mColumns; ++i) {
                this.setValue(row, i, values[i]);
            }
        }
    }

    public void deleteAt(int row, int count) {
        this.moveRowGapTo(row + count);
        this.mRowGapStart -= count;
        this.mRowGapLength += count;
        if (this.mRowGapLength > this.size() * 2) {
            // empty if block
        }
    }

    public int size() {
        return this.mRows - this.mRowGapLength;
    }

    public int width() {
        return this.mColumns;
    }

    private void growBuffer() {
        Object[] newvalues = ArrayUtils.newUnpaddedObjectArray(GrowingArrayUtils.growSize(this.size()) * this.mColumns);
        int newsize = newvalues.length / this.mColumns;
        int after = this.mRows - (this.mRowGapStart + this.mRowGapLength);
        System.arraycopy(this.mValues, 0, newvalues, 0, this.mColumns * this.mRowGapStart);
        System.arraycopy(this.mValues, (this.mRows - after) * this.mColumns, newvalues, (newsize - after) * this.mColumns, after * this.mColumns);
        this.mRowGapLength += newsize - this.mRows;
        this.mRows = newsize;
        this.mValues = newvalues;
    }

    private void moveRowGapTo(int where) {
        if (where == this.mRowGapStart) {
            return;
        }
        if (where > this.mRowGapStart) {
            int moving = where + this.mRowGapLength - (this.mRowGapStart + this.mRowGapLength);
            for (int i = this.mRowGapStart + this.mRowGapLength; i < this.mRowGapStart + this.mRowGapLength + moving; ++i) {
                int destrow = i - (this.mRowGapStart + this.mRowGapLength) + this.mRowGapStart;
                for (int j = 0; j < this.mColumns; ++j) {
                    Object val;
                    this.mValues[destrow * this.mColumns + j] = val = this.mValues[i * this.mColumns + j];
                }
            }
        } else {
            int moving = this.mRowGapStart - where;
            for (int i = where + moving - 1; i >= where; --i) {
                int destrow = i - where + this.mRowGapStart + this.mRowGapLength - moving;
                for (int j = 0; j < this.mColumns; ++j) {
                    Object val;
                    this.mValues[destrow * this.mColumns + j] = val = this.mValues[i * this.mColumns + j];
                }
            }
        }
        this.mRowGapStart = where;
    }

    public void dump() {
        for (int i = 0; i < this.mRows; ++i) {
            for (int j = 0; j < this.mColumns; ++j) {
                Object val = this.mValues[i * this.mColumns + j];
                if (i < this.mRowGapStart || i >= this.mRowGapStart + this.mRowGapLength) {
                    System.out.print(val + " ");
                    continue;
                }
                System.out.print("(" + val + ") ");
            }
            System.out.print(" << \n");
        }
        System.out.print("-----\n\n");
    }
}

