/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.text.LineBreakConfig;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.MeasuredParagraph;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class PrecomputedText
implements Spannable {
    private static final char LINE_FEED = '\n';
    @NonNull
    private final SpannableString mText;
    private final int mStart;
    private final int mEnd;
    @NonNull
    private final Params mParams;
    @NonNull
    private final ParagraphInfo[] mParagraphInfo;

    public static PrecomputedText create(@NonNull CharSequence text, @NonNull Params params) {
        ParagraphInfo[] paraInfo = null;
        if (text instanceof PrecomputedText) {
            PrecomputedText hintPct = (PrecomputedText)text;
            Params hintParams = hintPct.getParams();
            int checkResult = hintParams.checkResultUsable(params.mPaint, params.mTextDir, params.mBreakStrategy, params.mHyphenationFrequency, params.mLineBreakConfig);
            switch (checkResult) {
                case 2: {
                    return hintPct;
                }
                case 1: {
                    if (params.getBreakStrategy() != hintParams.getBreakStrategy() || params.getHyphenationFrequency() != hintParams.getHyphenationFrequency()) break;
                    paraInfo = PrecomputedText.createMeasuredParagraphsFromPrecomputedText(hintPct, params, true);
                    break;
                }
            }
        }
        if (paraInfo == null) {
            paraInfo = PrecomputedText.createMeasuredParagraphs(text, params, 0, text.length(), true, true);
        }
        return new PrecomputedText(text, 0, text.length(), params, paraInfo);
    }

    private static boolean isFastHyphenation(int frequency) {
        return frequency == 4 || frequency == 3;
    }

    private static ParagraphInfo[] createMeasuredParagraphsFromPrecomputedText(@NonNull PrecomputedText pct, @NonNull Params params, boolean computeLayout) {
        boolean needHyphenation;
        boolean bl = needHyphenation = params.getBreakStrategy() != 0 && params.getHyphenationFrequency() != 0;
        int hyphenationMode = needHyphenation ? (PrecomputedText.isFastHyphenation(params.getHyphenationFrequency()) ? 2 : 1) : 0;
        LineBreakConfig config = params.getLineBreakConfig();
        if (config.getLineBreakWordStyle() == 2 && pct.getParagraphCount() != 1) {
            config = new LineBreakConfig.Builder().merge(config).setLineBreakWordStyle(0).build();
        }
        ArrayList<ParagraphInfo> result = new ArrayList<ParagraphInfo>();
        for (int i = 0; i < pct.getParagraphCount(); ++i) {
            int paraStart = pct.getParagraphStart(i);
            int paraEnd = pct.getParagraphEnd(i);
            result.add(new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(params.getTextPaint(), config, pct, paraStart, paraEnd, params.getTextDirection(), hyphenationMode, computeLayout, true, pct.getMeasuredParagraph(i), null)));
        }
        return result.toArray(new ParagraphInfo[result.size()]);
    }

    public static ParagraphInfo[] createMeasuredParagraphs(@NonNull CharSequence text, @NonNull Params params, int start, int end, boolean computeLayout, boolean computeBounds) {
        boolean needHyphenation;
        ArrayList<ParagraphInfo> result = new ArrayList<ParagraphInfo>();
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(params);
        boolean bl = needHyphenation = params.getBreakStrategy() != 0 && params.getHyphenationFrequency() != 0;
        int hyphenationMode = needHyphenation ? (PrecomputedText.isFastHyphenation(params.getHyphenationFrequency()) ? 2 : 1) : 0;
        LineBreakConfig config = null;
        int paraEnd = 0;
        int paraStart = start;
        while (paraStart < end) {
            paraEnd = TextUtils.indexOf(text, '\n', paraStart, end);
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            if (config == null && (config = params.getLineBreakConfig()).getLineBreakWordStyle() == 2 && (paraStart != start || paraEnd != end)) {
                config = new LineBreakConfig.Builder().merge(config).setLineBreakWordStyle(0).build();
            }
            result.add(new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(params.getTextPaint(), config, text, paraStart, paraEnd, params.getTextDirection(), hyphenationMode, computeLayout, computeBounds, null, null)));
            paraStart = paraEnd;
        }
        return result.toArray(new ParagraphInfo[result.size()]);
    }

    private PrecomputedText(@NonNull CharSequence text, int start, int end, @NonNull Params params, @NonNull ParagraphInfo[] paraInfo) {
        this.mText = new SpannableString(text, true);
        this.mStart = start;
        this.mEnd = end;
        this.mParams = params;
        this.mParagraphInfo = paraInfo;
    }

    @NonNull
    public CharSequence getText() {
        return this.mText;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getEnd() {
        return this.mEnd;
    }

    @NonNull
    public Params getParams() {
        return this.mParams;
    }

    public int getParagraphCount() {
        return this.mParagraphInfo.length;
    }

    public int getParagraphStart(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return paraIndex == 0 ? this.mStart : this.getParagraphEnd(paraIndex - 1);
    }

    public int getParagraphEnd(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return this.mParagraphInfo[paraIndex].paragraphEnd;
    }

    @NonNull
    public MeasuredParagraph getMeasuredParagraph(int paraIndex) {
        return this.mParagraphInfo[paraIndex].measured;
    }

    @NonNull
    public ParagraphInfo[] getParagraphInfo() {
        return this.mParagraphInfo;
    }

    public int checkResultUsable(int start, int end, @NonNull TextDirectionHeuristic textDir, @NonNull TextPaint paint, int strategy, int frequency, @NonNull LineBreakConfig lbConfig) {
        if (this.mStart != start || this.mEnd != end) {
            return 0;
        }
        return this.mParams.checkResultUsable(paint, textDir, strategy, frequency, lbConfig);
    }

    public int findParaIndex(int pos) {
        for (int i = 0; i < this.mParagraphInfo.length; ++i) {
            if (pos >= this.mParagraphInfo[i].paragraphEnd) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("pos must be less than " + this.mParagraphInfo[this.mParagraphInfo.length - 1].paragraphEnd + ", gave " + pos);
    }

    public float getWidth(int start, int end) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        if (start == end) {
            return 0.0f;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        return this.getMeasuredParagraph(paraIndex).getWidth(start - paraStart, end - paraStart);
    }

    public void getBounds(int start, int end, @NonNull Rect bounds) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        Preconditions.checkNotNull(bounds);
        if (start == end) {
            bounds.set(0, 0, 0, 0);
            return;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        this.getMeasuredParagraph(paraIndex).getBounds(start - paraStart, end - paraStart, bounds);
    }

    public void getFontMetricsInt(int start, int end, @NonNull Paint.FontMetricsInt outMetrics) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        Objects.requireNonNull(outMetrics);
        if (start == end) {
            this.mParams.getTextPaint().getFontMetricsInt(outMetrics);
            return;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        this.getMeasuredParagraph(paraIndex).getFontMetricsInt(start - paraStart, end - paraStart, outMetrics);
    }

    public float getCharWidthAt(int offset) {
        Preconditions.checkArgument(0 <= offset && offset < this.mText.length(), "invalid offset");
        int paraIndex = this.findParaIndex(offset);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        return this.getMeasuredParagraph(paraIndex).getCharWidthAt(offset - paraStart);
    }

    public int getMemoryUsage() {
        int r = 0;
        for (int i = 0; i < this.getParagraphCount(); ++i) {
            r += this.getMeasuredParagraph(i).getMemoryUsage();
        }
        return r;
    }

    @Override
    public void setSpan(Object what, int start, int end, int flags) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be set to PrecomputedText.");
        }
        this.mText.setSpan(what, start, end, flags);
    }

    @Override
    public void removeSpan(Object what) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be removed from PrecomputedText.");
        }
        this.mText.removeSpan(what);
    }

    @Override
    public <T> T[] getSpans(int start, int end, Class<T> type) {
        return this.mText.getSpans(start, end, (Class)type);
    }

    @Override
    public int getSpanStart(Object tag) {
        return this.mText.getSpanStart(tag);
    }

    @Override
    public int getSpanEnd(Object tag) {
        return this.mText.getSpanEnd(tag);
    }

    @Override
    public int getSpanFlags(Object tag) {
        return this.mText.getSpanFlags(tag);
    }

    @Override
    public int nextSpanTransition(int start, int limit, Class type) {
        return this.mText.nextSpanTransition(start, limit, type);
    }

    @Override
    public int length() {
        return this.mText.length();
    }

    @Override
    public char charAt(int index) {
        return this.mText.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return PrecomputedText.create(this.mText.subSequence(start, end), this.mParams);
    }

    @Override
    public String toString() {
        return this.mText.toString();
    }

    public static class Params {
        @NonNull
        private final TextPaint mPaint;
        @NonNull
        private final TextDirectionHeuristic mTextDir;
        private final int mBreakStrategy;
        private final int mHyphenationFrequency;
        @NonNull
        private final LineBreakConfig mLineBreakConfig;
        public static final int UNUSABLE = 0;
        public static final int NEED_RECOMPUTE = 1;
        public static final int USABLE = 2;

        public Params(@NonNull TextPaint paint, @NonNull LineBreakConfig lineBreakConfig, @NonNull TextDirectionHeuristic textDir, int strategy, int frequency) {
            this.mPaint = paint;
            this.mTextDir = textDir;
            this.mBreakStrategy = strategy;
            this.mHyphenationFrequency = frequency;
            this.mLineBreakConfig = lineBreakConfig;
        }

        @NonNull
        public TextPaint getTextPaint() {
            return this.mPaint;
        }

        @NonNull
        public TextDirectionHeuristic getTextDirection() {
            return this.mTextDir;
        }

        public int getBreakStrategy() {
            return this.mBreakStrategy;
        }

        public int getHyphenationFrequency() {
            return this.mHyphenationFrequency;
        }

        @NonNull
        public LineBreakConfig getLineBreakConfig() {
            return this.mLineBreakConfig;
        }

        public int checkResultUsable(@NonNull TextPaint paint, @NonNull TextDirectionHeuristic textDir, int strategy, int frequency, @NonNull LineBreakConfig lbConfig) {
            if (this.mBreakStrategy == strategy && this.mHyphenationFrequency == frequency && this.mLineBreakConfig.equals(lbConfig) && this.mPaint.equalsForTextMeasurement(paint)) {
                return this.mTextDir == textDir ? 2 : 1;
            }
            return 0;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Params)) {
                return false;
            }
            Params param = (Params)o;
            return this.checkResultUsable(param.mPaint, param.mTextDir, param.mBreakStrategy, param.mHyphenationFrequency, param.mLineBreakConfig) == 2;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mPaint.getTextSize()), Float.valueOf(this.mPaint.getTextScaleX()), Float.valueOf(this.mPaint.getTextSkewX()), Float.valueOf(this.mPaint.getLetterSpacing()), Float.valueOf(this.mPaint.getWordSpacing()), this.mPaint.getFlags(), this.mPaint.getTextLocales(), this.mPaint.getTypeface(), this.mPaint.getFontVariationSettings(), this.mPaint.isElegantTextHeight(), this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency, LineBreakConfig.getResolvedLineBreakStyle(this.mLineBreakConfig), LineBreakConfig.getResolvedLineBreakWordStyle(this.mLineBreakConfig));
        }

        public String toString() {
            return "{textSize=" + this.mPaint.getTextSize() + ", textScaleX=" + this.mPaint.getTextScaleX() + ", textSkewX=" + this.mPaint.getTextSkewX() + ", letterSpacing=" + this.mPaint.getLetterSpacing() + ", textLocale=" + this.mPaint.getTextLocales() + ", typeface=" + this.mPaint.getTypeface() + ", variationSettings=" + this.mPaint.getFontVariationSettings() + ", elegantTextHeight=" + this.mPaint.isElegantTextHeight() + ", textDir=" + this.mTextDir + ", breakStrategy=" + this.mBreakStrategy + ", hyphenationFrequency=" + this.mHyphenationFrequency + ", lineBreakStyle=" + LineBreakConfig.getResolvedLineBreakStyle(this.mLineBreakConfig) + ", lineBreakWordStyle=" + LineBreakConfig.getResolvedLineBreakWordStyle(this.mLineBreakConfig) + "}";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CheckResultUsableResult {
        }

        public static class Builder {
            @NonNull
            private final TextPaint mPaint;
            private TextDirectionHeuristic mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            private int mBreakStrategy = 1;
            private int mHyphenationFrequency = 1;
            @NonNull
            private LineBreakConfig mLineBreakConfig = LineBreakConfig.NONE;

            public Builder(@NonNull TextPaint paint) {
                this.mPaint = paint;
            }

            public Builder(@NonNull Params params) {
                this.mPaint = params.mPaint;
                this.mTextDir = params.mTextDir;
                this.mBreakStrategy = params.mBreakStrategy;
                this.mHyphenationFrequency = params.mHyphenationFrequency;
                this.mLineBreakConfig = params.mLineBreakConfig;
            }

            public Builder setBreakStrategy(int strategy) {
                this.mBreakStrategy = strategy;
                return this;
            }

            public Builder setHyphenationFrequency(int frequency) {
                this.mHyphenationFrequency = frequency;
                return this;
            }

            public Builder setTextDirection(@NonNull TextDirectionHeuristic textDir) {
                this.mTextDir = textDir;
                return this;
            }

            @NonNull
            public Builder setLineBreakConfig(@NonNull LineBreakConfig lineBreakConfig) {
                this.mLineBreakConfig = lineBreakConfig;
                return this;
            }

            @NonNull
            public Params build() {
                return new Params(this.mPaint, this.mLineBreakConfig, this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency);
            }
        }
    }

    public static class ParagraphInfo {
        public final int paragraphEnd;
        @NonNull
        public final MeasuredParagraph measured;

        public ParagraphInfo(int paraEnd, @NonNull MeasuredParagraph measured) {
            this.paragraphEnd = paraEnd;
            this.measured = measured;
        }
    }
}

