/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextDirectionHeuristic;
import android.text.TextUtils;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.nio.CharBuffer;

@RavenwoodKeepWholeClass
public class TextDirectionHeuristics {
    public static final TextDirectionHeuristic LTR = new TextDirectionHeuristicInternal(null, false);
    public static final TextDirectionHeuristic RTL = new TextDirectionHeuristicInternal(null, true);
    public static final TextDirectionHeuristic FIRSTSTRONG_LTR = new TextDirectionHeuristicInternal(FirstStrong.INSTANCE, false);
    public static final TextDirectionHeuristic FIRSTSTRONG_RTL = new TextDirectionHeuristicInternal(FirstStrong.INSTANCE, true);
    public static final TextDirectionHeuristic ANYRTL_LTR = new TextDirectionHeuristicInternal(AnyStrong.INSTANCE_RTL, false);
    public static final TextDirectionHeuristic LOCALE = TextDirectionHeuristicLocale.INSTANCE;
    private static final int STATE_TRUE = 0;
    private static final int STATE_FALSE = 1;
    private static final int STATE_UNKNOWN = 2;

    private static int isRtlCodePoint(int codePoint) {
        switch (Character.getDirectionality(codePoint)) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case -1: {
                if (1424 <= codePoint && codePoint <= 2303 || 64285 <= codePoint && codePoint <= 64975 || 65008 <= codePoint && codePoint <= 65023 || 65136 <= codePoint && codePoint <= 65279 || 67584 <= codePoint && codePoint <= 69631 || 124928 <= codePoint && codePoint <= 126975) {
                    return 0;
                }
                if (8293 <= codePoint && codePoint <= 8297 || 65520 <= codePoint && codePoint <= 65528 || 917504 <= codePoint && codePoint <= 921599 || 64976 <= codePoint && codePoint <= 65007 || (codePoint & 0xFFFE) == 65534 || 8352 <= codePoint && codePoint <= 8399 || 55296 <= codePoint && codePoint <= 57343) {
                    return 2;
                }
                return 1;
            }
        }
        return 2;
    }

    private static class TextDirectionHeuristicInternal
    extends TextDirectionHeuristicImpl {
        private final boolean mDefaultIsRtl;

        private TextDirectionHeuristicInternal(TextDirectionAlgorithm algorithm, boolean defaultIsRtl) {
            super(algorithm);
            this.mDefaultIsRtl = defaultIsRtl;
        }

        @Override
        protected boolean defaultIsRtl() {
            return this.mDefaultIsRtl;
        }
    }

    private static interface TextDirectionAlgorithm {
        public int checkRtl(CharSequence var1, int var2, int var3);
    }

    private static class FirstStrong
    implements TextDirectionAlgorithm {
        public static final FirstStrong INSTANCE = new FirstStrong();

        @Override
        public int checkRtl(CharSequence cs, int start, int count) {
            int cp;
            int result = 2;
            int openIsolateCount = 0;
            int end = start + count;
            for (int i = start; i < end && result == 2; i += Character.charCount(cp)) {
                cp = Character.codePointAt(cs, i);
                if (8294 <= cp && cp <= 8296) {
                    ++openIsolateCount;
                    continue;
                }
                if (cp == 8297) {
                    if (openIsolateCount <= 0) continue;
                    --openIsolateCount;
                    continue;
                }
                if (openIsolateCount != 0) continue;
                result = TextDirectionHeuristics.isRtlCodePoint(cp);
            }
            return result;
        }

        private FirstStrong() {
        }
    }

    private static class AnyStrong
    implements TextDirectionAlgorithm {
        private final boolean mLookForRtl;
        public static final AnyStrong INSTANCE_RTL = new AnyStrong(true);
        public static final AnyStrong INSTANCE_LTR = new AnyStrong(false);

        @Override
        public int checkRtl(CharSequence cs, int start, int count) {
            int cp;
            boolean haveUnlookedFor = false;
            int openIsolateCount = 0;
            int end = start + count;
            block4: for (int i = start; i < end; i += Character.charCount(cp)) {
                cp = Character.codePointAt(cs, i);
                if (8294 <= cp && cp <= 8296) {
                    ++openIsolateCount;
                    continue;
                }
                if (cp == 8297) {
                    if (openIsolateCount <= 0) continue;
                    --openIsolateCount;
                    continue;
                }
                if (openIsolateCount != 0) continue;
                switch (TextDirectionHeuristics.isRtlCodePoint(cp)) {
                    case 0: {
                        if (this.mLookForRtl) {
                            return 0;
                        }
                        haveUnlookedFor = true;
                        continue block4;
                    }
                    case 1: {
                        if (!this.mLookForRtl) {
                            return 1;
                        }
                        haveUnlookedFor = true;
                        continue block4;
                    }
                }
            }
            if (haveUnlookedFor) {
                return this.mLookForRtl ? 1 : 0;
            }
            return 2;
        }

        private AnyStrong(boolean lookForRtl) {
            this.mLookForRtl = lookForRtl;
        }
    }

    private static class TextDirectionHeuristicLocale
    extends TextDirectionHeuristicImpl {
        public static final TextDirectionHeuristicLocale INSTANCE = new TextDirectionHeuristicLocale();

        public TextDirectionHeuristicLocale() {
            super(null);
        }

        @Override
        protected boolean defaultIsRtl() {
            int dir = TextUtils.getLayoutDirectionFromLocale(AndroidLocale.getDefault());
            return dir == 1;
        }
    }

    private static abstract class TextDirectionHeuristicImpl
    implements TextDirectionHeuristic {
        private final TextDirectionAlgorithm mAlgorithm;

        public TextDirectionHeuristicImpl(TextDirectionAlgorithm algorithm) {
            this.mAlgorithm = algorithm;
        }

        protected abstract boolean defaultIsRtl();

        @Override
        public boolean isRtl(char[] array2, int start, int count) {
            return this.isRtl(CharBuffer.wrap(array2), start, count);
        }

        @Override
        public boolean isRtl(CharSequence cs, int start, int count) {
            if (cs == null || start < 0 || count < 0 || cs.length() - count < start) {
                throw new IllegalArgumentException();
            }
            if (this.mAlgorithm == null) {
                return this.defaultIsRtl();
            }
            return this.doCheck(cs, start, count);
        }

        private boolean doCheck(CharSequence cs, int start, int count) {
            switch (this.mAlgorithm.checkRtl(cs, start, count)) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return this.defaultIsRtl();
        }
    }
}

