/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Paint;
import android.os.LocaleList;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import com.android.internal.util.Preconditions;
import java.util.Locale;

@RavenwoodKeepWholeClass
public class LocaleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    @NonNull
    private final LocaleList mLocales;

    public LocaleSpan(@Nullable Locale locale) {
        this.mLocales = locale == null ? LocaleList.getEmptyLocaleList() : new LocaleList(locale);
    }

    public LocaleSpan(@NonNull LocaleList locales) {
        Preconditions.checkNotNull(locales, "locales cannot be null");
        this.mLocales = locales;
    }

    public LocaleSpan(Parcel source) {
        this.mLocales = LocaleList.CREATOR.createFromParcel(source);
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 23;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        this.mLocales.writeToParcel(dest, flags);
    }

    @Nullable
    public Locale getLocale() {
        return this.mLocales.get(0);
    }

    @NonNull
    public LocaleList getLocales() {
        return this.mLocales;
    }

    @Override
    public void updateDrawState(TextPaint ds) {
        LocaleSpan.apply(ds, this.mLocales);
    }

    @Override
    public void updateMeasureState(TextPaint paint) {
        LocaleSpan.apply(paint, this.mLocales);
    }

    private static void apply(@NonNull Paint paint, @NonNull LocaleList locales) {
        paint.setTextLocales(locales);
    }

    public String toString() {
        return "LocaleSpan{locales=" + this.getLocales() + '}';
    }
}

