/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

@RavenwoodKeepWholeClass
public class RelativeSizeSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final float mProportion;

    public RelativeSizeSpan(float proportion) {
        this.mProportion = proportion;
    }

    public RelativeSizeSpan(@NonNull Parcel src) {
        this.mProportion = src.readFloat();
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 3;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.mProportion);
    }

    public float getSizeChange() {
        return this.mProportion;
    }

    @Override
    public void updateDrawState(@NonNull TextPaint ds) {
        ds.setTextSize(ds.getTextSize() * this.mProportion);
    }

    @Override
    public void updateMeasureState(@NonNull TextPaint ds) {
        ds.setTextSize(ds.getTextSize() * this.mProportion);
    }

    public String toString() {
        return "RelativeSizeSpan{proportion=" + this.getSizeChange() + '}';
    }
}

