/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Process;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.StatsEvent;
import android.util.proto.ProtoOutputStream;
import com.android.internal.lang.System_Delegate;
import com.android.internal.statsd.StatsdStatsLog;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StatsLog {
    private static final String TAG = "StatsLog";
    private static final boolean DEBUG = false;
    private static final int EXPERIMENT_IDS_FIELD_ID = 1;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_IS_UID = 1;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_TRUNCATE_TIMESTAMP = 2;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_PRIMARY_FIELD = 3;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_EXCLUSIVE_STATE = 4;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_PRIMARY_FIELD_FIRST_UID = 5;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_DEFAULT_STATE = 6;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_TRIGGER_STATE_RESET = 7;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte ANNOTATION_ID_STATE_NESTED = 8;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_RESTRICTION_CATEGORY = 9;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_PERIPHERAL_DEVICE_INFO = 10;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_APP_USAGE = 11;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_APP_ACTIVITY = 12;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_HEALTH_CONNECT = 13;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_ACCESSIBILITY = 14;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_SYSTEM_SEARCH = 15;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_USER_ENGAGEMENT = 16;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_AMBIENT_SENSING = 17;
    @SystemApi
    @SuppressLint(value={"NoByteOrShort"})
    @RequiresApi(value=34)
    public static final byte ANNOTATION_ID_FIELD_RESTRICTION_DEMOGRAPHIC_CLASSIFICATION = 18;
    @SystemApi
    @RequiresApi(value=34)
    public static final int RESTRICTION_CATEGORY_DIAGNOSTIC = 1;
    @SystemApi
    @RequiresApi(value=34)
    public static final int RESTRICTION_CATEGORY_SYSTEM_INTELLIGENCE = 2;
    @SystemApi
    @RequiresApi(value=34)
    public static final int RESTRICTION_CATEGORY_AUTHENTICATION = 3;
    @SystemApi
    @RequiresApi(value=34)
    public static final int RESTRICTION_CATEGORY_FRAUD_AND_ABUSE = 4;

    @RavenwoodReplace
    private static void loadNativeLibrary() {
        System_Delegate.loadLibrary("stats_jni");
    }

    private static void loadNativeLibrary$ravenwood() {
    }

    private StatsLog() {
    }

    public static boolean logStart(int label) {
        int callingUid = Process.myUid();
        StatsdStatsLog.write(47, callingUid, label, 3);
        return true;
    }

    public static boolean logStop(int label) {
        int callingUid = Process.myUid();
        StatsdStatsLog.write(47, callingUid, label, 2);
        return true;
    }

    public static boolean logEvent(int label) {
        int callingUid = Process.myUid();
        StatsdStatsLog.write(47, callingUid, label, 1);
        return true;
    }

    @RequiresPermission(allOf={"android.permission.DUMP", "android.permission.PACKAGE_USAGE_STATS"})
    public static boolean logBinaryPushStateChanged(@NonNull String trainName, long trainVersionCode, int options, int state, @NonNull long[] experimentIds) {
        ProtoOutputStream proto = new ProtoOutputStream();
        for (long id2 : experimentIds) {
            proto.write(2211908157441L, id2);
        }
        StatsdStatsLog.write(102, trainName, trainVersionCode, (options & 1) > 0, (options & 2) > 0, (options & 4) > 0, state, proto.getBytes(), 0, 0, false);
        return true;
    }

    @Deprecated
    @SystemApi
    public static void writeRaw(@NonNull byte[] buffer, int size) {
        StatsLog.writeImpl(buffer, size, 0);
    }

    @RavenwoodReplace
    private static void writeImpl(@NonNull byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.util.StatsLog#writeImpl([BII)V", true, null);
    }

    private static void writeImpl$ravenwood(@NonNull byte[] buffer, int size, int atomId) {
    }

    @SystemApi
    public static void write(@NonNull StatsEvent statsEvent) {
        StatsLog.writeImpl(statsEvent.getBytes(), statsEvent.getNumBytes(), statsEvent.getAtomId());
        statsEvent.release();
    }

    static {
        StatsLog.loadNativeLibrary();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RestrictionCategory {
    }
}

