/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.NonNull;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.ChannelUsage;
import android.uwb.IChannelUsageCallback;
import android.uwb.IUwbAdapter;
import android.uwb.UwbManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class ChannelUsageCallbackListener
extends IChannelUsageCallback.Stub {
    private static final String TAG = "Uwb.ChannelUsageListener";
    private final IUwbAdapter mAdapter;
    private boolean mIsRegistered = false;
    private final Map<Integer, Boolean> mChannelUsageMap = new ConcurrentHashMap<Integer, Boolean>();
    private final Map<UwbManager.ChannelUsageCallback, Executor> mCallbackMap = new ConcurrentHashMap<UwbManager.ChannelUsageCallback, Executor>();

    public ChannelUsageCallbackListener(@NonNull IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull Executor executor, @NonNull UwbManager.ChannelUsageCallback callback) {
        ChannelUsageCallbackListener channelUsageCallbackListener = this;
        synchronized (channelUsageCallbackListener) {
            if (this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.put(callback, executor);
            if (!this.mIsRegistered) {
                try {
                    this.mAdapter.registerChannelUsageCallback(this);
                    this.mIsRegistered = true;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to register adapter state callback");
                    throw e.rethrowFromSystemServer();
                }
            } else {
                this.sendCurrentUsage(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull UwbManager.ChannelUsageCallback callback) {
        ChannelUsageCallbackListener channelUsageCallbackListener = this;
        synchronized (channelUsageCallbackListener) {
            if (!this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.remove(callback);
            if (this.mCallbackMap.isEmpty() && this.mIsRegistered) {
                try {
                    this.mAdapter.unregisterChannelUsageCallback(this);
                    this.mIsRegistered = false;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister adapter state callback");
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCurrentUsage(@NonNull UwbManager.ChannelUsageCallback callback) {
        ChannelUsageCallbackListener channelUsageCallbackListener = this;
        synchronized (channelUsageCallbackListener) {
            Executor executor = this.mCallbackMap.get(callback);
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onChanged(this.mChannelUsageMap));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @Override
    public void onChannelUsageUpdated(List<ChannelUsage> channelUsageList) throws RemoteException {
        for (ChannelUsage c : channelUsageList) {
            this.mChannelUsageMap.put(c.mChannel, c.mUsage);
        }
        for (UwbManager.ChannelUsageCallback callback : this.mCallbackMap.keySet()) {
            this.sendCurrentUsage(callback);
        }
    }
}

