/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.uwb.RangingMeasurement;
import android.uwb.util.PersistableBundleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class RangingReport
implements Parcelable {
    private final List<RangingMeasurement> mRangingMeasurements;
    private final PersistableBundle mRangingReportMetadata;
    @NonNull
    public static final Parcelable.Creator<RangingReport> CREATOR = new Parcelable.Creator<RangingReport>(){

        @Override
        public RangingReport createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.addMeasurements(in.createTypedArrayList(RangingMeasurement.CREATOR));
            PersistableBundle metadata = in.readPersistableBundle(this.getClass().getClassLoader());
            if (metadata != null) {
                builder.addRangingReportMetadata(metadata);
            }
            return builder.build();
        }

        public RangingReport[] newArray(int size) {
            return new RangingReport[size];
        }
    };

    private RangingReport(@NonNull List<RangingMeasurement> rangingMeasurements, PersistableBundle rangingReportMetadata) {
        this.mRangingMeasurements = rangingMeasurements;
        this.mRangingReportMetadata = rangingReportMetadata;
    }

    @NonNull
    public List<RangingMeasurement> getMeasurements() {
        return this.mRangingMeasurements;
    }

    @NonNull
    public PersistableBundle getRangingReportMetadata() {
        return this.mRangingReportMetadata;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RangingReport) {
            RangingReport other = (RangingReport)obj;
            return this.mRangingMeasurements.equals(other.getMeasurements()) && PersistableBundleUtils.isEqual(this.mRangingReportMetadata, other.getRangingReportMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mRangingMeasurements, PersistableBundleUtils.getHashCode(this.mRangingReportMetadata));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedList(this.mRangingMeasurements);
        dest.writePersistableBundle(this.mRangingReportMetadata);
    }

    public String toString() {
        return "RangingReport[measurements: " + this.mRangingMeasurements + ", ranging report measurement: " + this.mRangingReportMetadata + "]";
    }

    public static class Builder {
        List<RangingMeasurement> mMeasurements = new ArrayList<RangingMeasurement>();
        private PersistableBundle mRangingReportMetadata = new PersistableBundle();

        @NonNull
        public Builder addMeasurement(@NonNull RangingMeasurement rangingMeasurement) {
            this.mMeasurements.add(rangingMeasurement);
            return this;
        }

        @NonNull
        public Builder addMeasurements(@NonNull List<RangingMeasurement> rangingMeasurements) {
            this.mMeasurements.addAll(rangingMeasurements);
            return this;
        }

        @NonNull
        public Builder addRangingReportMetadata(@NonNull PersistableBundle rangingReportMetadata) {
            if (rangingReportMetadata == null) {
                throw new IllegalStateException("Expected non-null rangingReportMetadata");
            }
            this.mRangingReportMetadata = rangingReportMetadata;
            return this;
        }

        @NonNull
        public RangingReport build() {
            RangingMeasurement prevMeasurement = null;
            for (int curIndex = 0; curIndex < this.mMeasurements.size(); ++curIndex) {
                RangingMeasurement curMeasurement = this.mMeasurements.get(curIndex);
                if (prevMeasurement != null && prevMeasurement.getElapsedRealtimeNanos() > curMeasurement.getElapsedRealtimeNanos()) {
                    throw new IllegalStateException("Timestamp (" + curMeasurement.getElapsedRealtimeNanos() + ") at index " + curIndex + " is less than previous timestamp (" + prevMeasurement.getElapsedRealtimeNanos() + ")");
                }
                prevMeasurement = curMeasurement;
            }
            return new RangingReport(this.mMeasurements, this.mRangingReportMetadata);
        }
    }
}

