/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.content.AttributionSource;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class SessionHandle
implements Parcelable {
    private final int mId;
    private final String mPackageName;
    private final int mUid;
    private final int mPid;
    public static final Parcelable.Creator<SessionHandle> CREATOR = new Parcelable.Creator<SessionHandle>(){

        @Override
        public SessionHandle createFromParcel(Parcel in) {
            return new SessionHandle(in);
        }

        public SessionHandle[] newArray(int size) {
            return new SessionHandle[size];
        }
    };

    public SessionHandle(int id2, AttributionSource attributionSource, int pid) {
        this(id2, attributionSource.getPackageName(), attributionSource.getUid(), pid);
    }

    private SessionHandle(int id2, String packageName, int uid, int pid) {
        this.mId = id2;
        this.mPackageName = packageName;
        this.mUid = uid;
        this.mPid = pid;
    }

    protected SessionHandle(Parcel in) {
        this.mId = in.readInt();
        this.mPackageName = in.readString();
        this.mUid = in.readInt();
        this.mPid = in.readInt();
    }

    public int getId() {
        return this.mId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getUid() {
        return this.mUid;
    }

    public int getPid() {
        return this.mPid;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mUid);
        dest.writeInt(this.mPid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SessionHandle) {
            SessionHandle other = (SessionHandle)obj;
            return this.mId == other.mId && Objects.equals(this.mPackageName, other.mPackageName) && this.mUid == other.mUid && this.mPid == other.mPid;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mPackageName, this.mUid, this.mPid);
    }

    public String toString() {
        return "SessionHandle [id=" + this.mId + ", package-name: " + this.mPackageName + ", uid: " + this.mUid + ", pid: " + this.mPid + "]";
    }
}

