/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Matrix;
import android.os.IBinder;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import java.lang.ref.WeakReference;

class AccessibilityEmbeddedConnection
extends IAccessibilityEmbeddedConnection.Stub {
    private final WeakReference<ViewRootImpl> mViewRootImpl;
    private final Matrix mTmpWindowMatrix = new Matrix();

    AccessibilityEmbeddedConnection(ViewRootImpl viewRootImpl) {
        this.mViewRootImpl = new WeakReference<ViewRootImpl>(viewRootImpl);
    }

    @Override
    @Nullable
    public IBinder associateEmbeddedHierarchy(@NonNull IBinder host, int hostViewId) {
        ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
        if (viewRootImpl != null) {
            AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(viewRootImpl.mContext);
            viewRootImpl.mAttachInfo.mLeashedParentToken = host;
            viewRootImpl.mAttachInfo.mLeashedParentAccessibilityViewId = hostViewId;
            if (accessibilityManager.isEnabled()) {
                accessibilityManager.associateEmbeddedHierarchy(host, viewRootImpl.mLeashToken);
            }
            return viewRootImpl.mLeashToken;
        }
        return null;
    }

    @Override
    public void disassociateEmbeddedHierarchy() {
        ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
        if (viewRootImpl != null) {
            AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(viewRootImpl.mContext);
            viewRootImpl.mAttachInfo.mLeashedParentToken = null;
            viewRootImpl.mAttachInfo.mLeashedParentAccessibilityViewId = -1;
            if (accessibilityManager.isEnabled()) {
                accessibilityManager.disassociateEmbeddedHierarchy(viewRootImpl.mLeashToken);
            }
        }
    }

    @Override
    public void setWindowMatrix(float[] matrixValues) {
        ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
        if (viewRootImpl != null) {
            this.mTmpWindowMatrix.setValues(matrixValues);
            if (viewRootImpl.mAttachInfo.mWindowMatrixInEmbeddedHierarchy == null) {
                viewRootImpl.mAttachInfo.mWindowMatrixInEmbeddedHierarchy = new Matrix();
            }
            viewRootImpl.mAttachInfo.mWindowMatrixInEmbeddedHierarchy.set(this.mTmpWindowMatrix);
        }
    }
}

