/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.text.TextUtils;
import android.util.Log;
import android.util.PathParser;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class CutoutSpecification {
    private static final String TAG = "CutoutSpecification";
    private static final boolean DEBUG = false;
    private static final int MINIMAL_ACCEPTABLE_PATH_LENGTH = "H1V1Z".length();
    private static final char MARKER_START_CHAR = '@';
    private static final String DP_MARKER = "@dp";
    private static final String BOTTOM_MARKER = "@bottom";
    private static final String RIGHT_MARKER = "@right";
    private static final String LEFT_MARKER = "@left";
    private static final String CUTOUT_MARKER = "@cutout";
    private static final String CENTER_VERTICAL_MARKER = "@center_vertical";
    private static final String BIND_RIGHT_CUTOUT_MARKER = "@bind_right_cutout";
    private static final String BIND_LEFT_CUTOUT_MARKER = "@bind_left_cutout";
    private final Path mPath;
    private final Rect mLeftBound;
    private final Rect mTopBound;
    private final Rect mRightBound;
    private final Rect mBottomBound;
    private Insets mInsets;

    private CutoutSpecification(@NonNull Parser parser) {
        this.mPath = parser.mPath;
        this.mLeftBound = parser.mLeftBound;
        this.mTopBound = parser.mTopBound;
        this.mRightBound = parser.mRightBound;
        this.mBottomBound = parser.mBottomBound;
        this.mInsets = parser.mInsets;
        this.applyPhysicalPixelDisplaySizeRatio(parser.mPhysicalPixelDisplaySizeRatio);
    }

    private void applyPhysicalPixelDisplaySizeRatio(float physicalPixelDisplaySizeRatio) {
        if (physicalPixelDisplaySizeRatio == 1.0f) {
            return;
        }
        if (this.mPath != null && !this.mPath.isEmpty()) {
            Matrix matrix = new Matrix();
            matrix.postScale(physicalPixelDisplaySizeRatio, physicalPixelDisplaySizeRatio);
            this.mPath.transform(matrix);
        }
        this.scaleBounds(this.mLeftBound, physicalPixelDisplaySizeRatio);
        this.scaleBounds(this.mTopBound, physicalPixelDisplaySizeRatio);
        this.scaleBounds(this.mRightBound, physicalPixelDisplaySizeRatio);
        this.scaleBounds(this.mBottomBound, physicalPixelDisplaySizeRatio);
        this.mInsets = this.scaleInsets(this.mInsets, physicalPixelDisplaySizeRatio);
    }

    private void scaleBounds(Rect r, float ratio) {
        if (r != null && !r.isEmpty()) {
            r.scale(ratio);
        }
    }

    private Insets scaleInsets(Insets insets, float ratio) {
        return Insets.of((int)((float)insets.left * ratio + 0.5f), (int)((float)insets.top * ratio + 0.5f), (int)((float)insets.right * ratio + 0.5f), (int)((float)insets.bottom * ratio + 0.5f));
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    public Path getPath() {
        return this.mPath;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    public Rect getLeftBound() {
        return this.mLeftBound;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    public Rect getTopBound() {
        return this.mTopBound;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    public Rect getRightBound() {
        return this.mRightBound;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    public Rect getBottomBound() {
        return this.mBottomBound;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @NonNull
    public Rect getSafeInset() {
        return this.mInsets.toRect();
    }

    private static int decideWhichEdge(boolean isTopEdgeShortEdge, boolean isShortEdge, boolean isStart) {
        return isTopEdgeShortEdge ? (isShortEdge ? (isStart ? 48 : 80) : (isStart ? 3 : 5)) : (isShortEdge ? (isStart ? 3 : 5) : (isStart ? 48 : 80));
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static class Parser {
        private final boolean mIsShortEdgeOnTop;
        private final float mStableDensity;
        private final int mPhysicalDisplayWidth;
        private final int mPhysicalDisplayHeight;
        private final float mPhysicalPixelDisplaySizeRatio;
        private final Matrix mMatrix;
        private Insets mInsets;
        private int mSafeInsetLeft;
        private int mSafeInsetTop;
        private int mSafeInsetRight;
        private int mSafeInsetBottom;
        private final Rect mTmpRect = new Rect();
        private final RectF mTmpRectF = new RectF();
        private boolean mInDp;
        private Path mPath;
        private Rect mLeftBound;
        private Rect mTopBound;
        private Rect mRightBound;
        private Rect mBottomBound;
        private boolean mPositionFromLeft = false;
        private boolean mPositionFromRight = false;
        private boolean mPositionFromBottom = false;
        private boolean mPositionFromCenterVertical = false;
        private boolean mBindLeftCutout = false;
        private boolean mBindRightCutout = false;
        private boolean mBindBottomCutout = false;
        private boolean mIsTouchShortEdgeStart;
        private boolean mIsTouchShortEdgeEnd;
        private boolean mIsCloserToStartSide;

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public Parser(float stableDensity, int physicalDisplayWidth, int physicalDisplayHeight) {
            this(stableDensity, physicalDisplayWidth, physicalDisplayHeight, 1.0f);
        }

        Parser(float stableDensity, int physicalDisplayWidth, int physicalDisplayHeight, float physicalPixelDisplaySizeRatio) {
            this.mStableDensity = stableDensity;
            this.mPhysicalDisplayWidth = physicalDisplayWidth;
            this.mPhysicalDisplayHeight = physicalDisplayHeight;
            this.mPhysicalPixelDisplaySizeRatio = physicalPixelDisplaySizeRatio;
            this.mMatrix = new Matrix();
            this.mIsShortEdgeOnTop = this.mPhysicalDisplayWidth < this.mPhysicalDisplayHeight;
        }

        private void computeBoundsRectAndAddToRegion(Path p, Region inoutRegion, Rect inoutRect) {
            this.mTmpRectF.setEmpty();
            p.computeBounds(this.mTmpRectF, false);
            this.mTmpRectF.round(inoutRect);
            inoutRegion.op(inoutRect, Region.Op.UNION);
        }

        private void resetStatus(StringBuilder sb) {
            sb.setLength(0);
            this.mPositionFromBottom = false;
            this.mPositionFromLeft = false;
            this.mPositionFromRight = false;
            this.mPositionFromCenterVertical = false;
            this.mBindLeftCutout = false;
            this.mBindRightCutout = false;
            this.mBindBottomCutout = false;
        }

        private void translateMatrix() {
            float offsetX = this.mPositionFromRight ? (float)this.mPhysicalDisplayWidth : (this.mPositionFromLeft ? 0.0f : (float)this.mPhysicalDisplayWidth / 2.0f);
            float offsetY = this.mPositionFromBottom ? (float)this.mPhysicalDisplayHeight : (this.mPositionFromCenterVertical ? (float)this.mPhysicalDisplayHeight / 2.0f : 0.0f);
            this.mMatrix.reset();
            if (this.mInDp) {
                this.mMatrix.postScale(this.mStableDensity, this.mStableDensity);
            }
            this.mMatrix.postTranslate(offsetX, offsetY);
        }

        private int computeSafeInsets(int gravity, Rect rect) {
            if (gravity == 3 && rect.right > 0 && rect.right < this.mPhysicalDisplayWidth) {
                return rect.right;
            }
            if (gravity == 48 && rect.bottom > 0 && rect.bottom < this.mPhysicalDisplayHeight) {
                return rect.bottom;
            }
            if (gravity == 5 && rect.left > 0 && rect.left < this.mPhysicalDisplayWidth) {
                return this.mPhysicalDisplayWidth - rect.left;
            }
            if (gravity == 80 && rect.top > 0 && rect.top < this.mPhysicalDisplayHeight) {
                return this.mPhysicalDisplayHeight - rect.top;
            }
            return 0;
        }

        private void setSafeInset(int gravity, int inset) {
            if (gravity == 3) {
                this.mSafeInsetLeft = inset;
            } else if (gravity == 48) {
                this.mSafeInsetTop = inset;
            } else if (gravity == 5) {
                this.mSafeInsetRight = inset;
            } else if (gravity == 80) {
                this.mSafeInsetBottom = inset;
            }
        }

        private int getSafeInset(int gravity) {
            if (gravity == 3) {
                return this.mSafeInsetLeft;
            }
            if (gravity == 48) {
                return this.mSafeInsetTop;
            }
            if (gravity == 5) {
                return this.mSafeInsetRight;
            }
            if (gravity == 80) {
                return this.mSafeInsetBottom;
            }
            return 0;
        }

        @NonNull
        private Rect onSetEdgeCutout(boolean isStart, boolean isShortEdge, @NonNull Rect rect) {
            int newSafeInset;
            int gravity = isShortEdge ? CutoutSpecification.decideWhichEdge(this.mIsShortEdgeOnTop, true, isStart) : (this.mIsTouchShortEdgeStart && this.mIsTouchShortEdgeEnd ? CutoutSpecification.decideWhichEdge(this.mIsShortEdgeOnTop, false, isStart) : (this.mIsTouchShortEdgeStart || this.mIsTouchShortEdgeEnd ? CutoutSpecification.decideWhichEdge(this.mIsShortEdgeOnTop, true, this.mIsCloserToStartSide) : CutoutSpecification.decideWhichEdge(this.mIsShortEdgeOnTop, isShortEdge, isStart)));
            int oldSafeInset = this.getSafeInset(gravity);
            if (oldSafeInset < (newSafeInset = this.computeSafeInsets(gravity, rect))) {
                this.setSafeInset(gravity, newSafeInset);
            }
            return new Rect(rect);
        }

        private void setEdgeCutout(@NonNull Path newPath) {
            if (this.mBindRightCutout && this.mRightBound == null) {
                this.mRightBound = this.onSetEdgeCutout(false, !this.mIsShortEdgeOnTop, this.mTmpRect);
            } else if (this.mBindLeftCutout && this.mLeftBound == null) {
                this.mLeftBound = this.onSetEdgeCutout(true, !this.mIsShortEdgeOnTop, this.mTmpRect);
            } else if (this.mBindBottomCutout && this.mBottomBound == null) {
                this.mBottomBound = this.onSetEdgeCutout(false, this.mIsShortEdgeOnTop, this.mTmpRect);
            } else if (!(this.mBindBottomCutout || this.mBindLeftCutout || this.mBindRightCutout || this.mTopBound != null)) {
                this.mTopBound = this.onSetEdgeCutout(true, this.mIsShortEdgeOnTop, this.mTmpRect);
            } else {
                return;
            }
            if (this.mPath != null) {
                this.mPath.addPath(newPath);
            } else {
                this.mPath = newPath;
            }
        }

        private void parseSvgPathSpec(Region region, String spec) {
            if (TextUtils.length(spec) < MINIMAL_ACCEPTABLE_PATH_LENGTH) {
                Log.e(CutoutSpecification.TAG, "According to SVG definition, it shouldn't happen");
                return;
            }
            this.translateMatrix();
            Path newPath = PathParser.createPathFromPathData(spec);
            newPath.transform(this.mMatrix);
            this.computeBoundsRectAndAddToRegion(newPath, region, this.mTmpRect);
            if (this.mTmpRect.isEmpty()) {
                return;
            }
            if (this.mIsShortEdgeOnTop) {
                this.mIsTouchShortEdgeStart = this.mTmpRect.top <= 0;
                this.mIsTouchShortEdgeEnd = this.mTmpRect.bottom >= this.mPhysicalDisplayHeight;
                this.mIsCloserToStartSide = this.mTmpRect.centerY() < this.mPhysicalDisplayHeight / 2;
            } else {
                this.mIsTouchShortEdgeStart = this.mTmpRect.left <= 0;
                this.mIsTouchShortEdgeEnd = this.mTmpRect.right >= this.mPhysicalDisplayWidth;
                this.mIsCloserToStartSide = this.mTmpRect.centerX() < this.mPhysicalDisplayWidth / 2;
            }
            this.setEdgeCutout(newPath);
        }

        private void parseSpecWithoutDp(@NonNull String specWithoutDp) {
            Region region = Region.obtain();
            StringBuilder sb = null;
            int currentIndex = 0;
            int lastIndex = 0;
            while ((currentIndex = specWithoutDp.indexOf(64, lastIndex)) != -1) {
                if (sb == null) {
                    sb = new StringBuilder(specWithoutDp.length());
                }
                sb.append(specWithoutDp, lastIndex, currentIndex);
                if (specWithoutDp.startsWith(CutoutSpecification.LEFT_MARKER, currentIndex)) {
                    if (!this.mPositionFromRight) {
                        this.mPositionFromLeft = true;
                    }
                    currentIndex += CutoutSpecification.LEFT_MARKER.length();
                } else if (specWithoutDp.startsWith(CutoutSpecification.RIGHT_MARKER, currentIndex)) {
                    if (!this.mPositionFromLeft) {
                        this.mPositionFromRight = true;
                    }
                    currentIndex += CutoutSpecification.RIGHT_MARKER.length();
                } else if (specWithoutDp.startsWith(CutoutSpecification.BOTTOM_MARKER, currentIndex)) {
                    this.parseSvgPathSpec(region, sb.toString());
                    currentIndex += CutoutSpecification.BOTTOM_MARKER.length();
                    this.resetStatus(sb);
                    this.mBindBottomCutout = true;
                    this.mPositionFromBottom = true;
                } else if (specWithoutDp.startsWith(CutoutSpecification.CENTER_VERTICAL_MARKER, currentIndex)) {
                    this.parseSvgPathSpec(region, sb.toString());
                    currentIndex += CutoutSpecification.CENTER_VERTICAL_MARKER.length();
                    this.resetStatus(sb);
                    this.mPositionFromCenterVertical = true;
                } else if (specWithoutDp.startsWith(CutoutSpecification.CUTOUT_MARKER, currentIndex)) {
                    this.parseSvgPathSpec(region, sb.toString());
                    currentIndex += CutoutSpecification.CUTOUT_MARKER.length();
                    this.resetStatus(sb);
                } else if (specWithoutDp.startsWith(CutoutSpecification.BIND_LEFT_CUTOUT_MARKER, currentIndex)) {
                    this.mBindBottomCutout = false;
                    this.mBindRightCutout = false;
                    this.mBindLeftCutout = true;
                    currentIndex += CutoutSpecification.BIND_LEFT_CUTOUT_MARKER.length();
                } else if (specWithoutDp.startsWith(CutoutSpecification.BIND_RIGHT_CUTOUT_MARKER, currentIndex)) {
                    this.mBindBottomCutout = false;
                    this.mBindLeftCutout = false;
                    this.mBindRightCutout = true;
                    currentIndex += CutoutSpecification.BIND_RIGHT_CUTOUT_MARKER.length();
                }
                lastIndex = ++currentIndex;
            }
            if (sb == null) {
                this.parseSvgPathSpec(region, specWithoutDp);
            } else {
                sb.append(specWithoutDp, lastIndex, specWithoutDp.length());
                this.parseSvgPathSpec(region, sb.toString());
            }
            region.recycle();
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public CutoutSpecification parse(@NonNull String originalSpec) {
            Objects.requireNonNull(originalSpec);
            int dpIndex = originalSpec.lastIndexOf(CutoutSpecification.DP_MARKER);
            this.mInDp = dpIndex != -1;
            String spec = dpIndex != -1 ? originalSpec.substring(0, dpIndex) + originalSpec.substring(dpIndex + CutoutSpecification.DP_MARKER.length()) : originalSpec;
            this.parseSpecWithoutDp(spec);
            this.mInsets = Insets.of(this.mSafeInsetLeft, this.mSafeInsetTop, this.mSafeInsetRight, this.mSafeInsetBottom);
            return new CutoutSpecification(this);
        }
    }
}

