/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;

public abstract class DisplayAddress
implements Parcelable {
    @NonNull
    public static Physical fromPhysicalDisplayId(long physicalDisplayId) {
        return new Physical(physicalDisplayId);
    }

    @NonNull
    public static Physical fromPortAndModel(int port, Long model) {
        return new Physical(port, model);
    }

    @NonNull
    public static Network fromMacAddress(String macAddress) {
        return new Network(macAddress);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Physical
    extends DisplayAddress {
        private static final long UNKNOWN_MODEL = 0L;
        private static final int MODEL_SHIFT = 8;
        private final long mPhysicalDisplayId;
        @NonNull
        public static final Parcelable.Creator<Physical> CREATOR = new Parcelable.Creator<Physical>(){

            @Override
            public Physical createFromParcel(Parcel in) {
                return new Physical(in.readLong());
            }

            public Physical[] newArray(int size) {
                return new Physical[size];
            }
        };

        public long getPhysicalDisplayId() {
            return this.mPhysicalDisplayId;
        }

        public int getPort() {
            return (int)(this.mPhysicalDisplayId & 0xFFL);
        }

        @Nullable
        public Long getModel() {
            long model = this.mPhysicalDisplayId >>> 8;
            return model == 0L ? null : Long.valueOf(model);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Physical && this.mPhysicalDisplayId == ((Physical)other).mPhysicalDisplayId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{").append("port=").append(this.getPort());
            Long model = this.getModel();
            if (model != null) {
                builder.append(", model=0x").append(Long.toHexString(model));
            }
            return builder.append("}").toString();
        }

        public int hashCode() {
            return Long.hashCode(this.mPhysicalDisplayId);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeLong(this.mPhysicalDisplayId);
        }

        public static boolean isPortMatch(DisplayAddress a1, DisplayAddress a2) {
            if (!(a1 instanceof Physical) || !(a2 instanceof Physical)) {
                return false;
            }
            Physical p1 = (Physical)a1;
            Physical p2 = (Physical)a2;
            if (p1.getModel() != null && p2.getModel() != null) {
                return p1.equals(p2);
            }
            return p1.getPort() == p2.getPort();
        }

        private Physical(long physicalDisplayId) {
            this.mPhysicalDisplayId = physicalDisplayId;
        }

        private Physical(int port, Long model) {
            if (port < 0 || port > 255) {
                throw new IllegalArgumentException("The port should be in the interval [0, 255]");
            }
            this.mPhysicalDisplayId = Integer.toUnsignedLong(port) | (model == null ? 0L : model << 8);
        }
    }

    public static class Network
    extends DisplayAddress {
        private final String mMacAddress;
        @NonNull
        public static final Parcelable.Creator<Network> CREATOR = new Parcelable.Creator<Network>(){

            @Override
            public Network createFromParcel(Parcel in) {
                return new Network(in.readString());
            }

            public Network[] newArray(int size) {
                return new Network[size];
            }
        };

        public boolean equals(@Nullable Object other) {
            return other instanceof Network && this.mMacAddress.equals(((Network)other).mMacAddress);
        }

        public String toString() {
            return this.mMacAddress;
        }

        public int hashCode() {
            return this.mMacAddress.hashCode();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mMacAddress);
        }

        private Network(String macAddress) {
            this.mMacAddress = macAddress;
        }
    }
}

