/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class FocusFinder {
    private static final ThreadLocal<FocusFinder> tlFocusFinder = new ThreadLocal<FocusFinder>(){

        @Override
        protected FocusFinder initialValue() {
            return new FocusFinder();
        }
    };
    final Rect mFocusedRect = new Rect();
    final Rect mOtherRect = new Rect();
    final Rect mBestCandidateRect = new Rect();
    private final UserSpecifiedFocusComparator mUserSpecifiedFocusComparator = new UserSpecifiedFocusComparator((r, v) -> FocusFinder.isValidId(v.getNextFocusForwardId()) ? v.findUserSetNextFocus(r, 2) : null);
    private final UserSpecifiedFocusComparator mUserSpecifiedClusterComparator = new UserSpecifiedFocusComparator((r, v) -> FocusFinder.isValidId(v.getNextClusterForwardId()) ? v.findUserSetNextKeyboardNavigationCluster(r, 2) : null);
    private final FocusSorter mFocusSorter = new FocusSorter();
    private final ArrayList<View> mTempList = new ArrayList();

    public static FocusFinder getInstance() {
        return tlFocusFinder.get();
    }

    private FocusFinder() {
    }

    public View findNextFocus(ViewGroup root, View focused, int direction) {
        return this.findNextFocus(root, focused, null, direction);
    }

    public View findNextFocusFromRect(ViewGroup root, Rect focusedRect, int direction) {
        this.mFocusedRect.set(focusedRect);
        return this.findNextFocus(root, null, this.mFocusedRect, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction) {
        View next = null;
        ViewGroup effectiveRoot = this.getEffectiveRoot(root, focused);
        if (focused != null) {
            next = this.findNextUserSpecifiedFocus(effectiveRoot, focused, direction);
        }
        if (next != null) {
            return next;
        }
        ArrayList<View> focusables = this.mTempList;
        try {
            focusables.clear();
            effectiveRoot.addFocusables(focusables, direction);
            if (!focusables.isEmpty()) {
                next = this.findNextFocus(effectiveRoot, focused, focusedRect, direction, focusables);
            }
        }
        finally {
            focusables.clear();
        }
        return next;
    }

    private ViewGroup getEffectiveRoot(ViewGroup root, View focused) {
        if (focused == null || focused == root) {
            return root;
        }
        ViewGroup effective = null;
        ViewParent nextParent = focused.getParent();
        while (nextParent instanceof ViewGroup) {
            if (nextParent == root) {
                return effective != null ? effective : root;
            }
            ViewGroup vg = (ViewGroup)nextParent;
            if (vg.getTouchscreenBlocksFocus() && focused.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen") && vg.isKeyboardNavigationCluster()) {
                effective = vg;
            }
            nextParent = nextParent.getParent();
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View findNextKeyboardNavigationCluster(@NonNull View root, @Nullable View currentCluster, int direction) {
        View next = null;
        if (currentCluster != null && (next = this.findNextUserSpecifiedKeyboardNavigationCluster(root, currentCluster, direction)) != null) {
            return next;
        }
        ArrayList<View> clusters = this.mTempList;
        try {
            clusters.clear();
            root.addKeyboardNavigationClusters(clusters, direction);
            if (!clusters.isEmpty()) {
                next = this.findNextKeyboardNavigationCluster(root, currentCluster, clusters, direction);
            }
        }
        finally {
            clusters.clear();
        }
        return next;
    }

    private View findNextUserSpecifiedKeyboardNavigationCluster(View root, View currentCluster, int direction) {
        View userSetNextCluster = currentCluster.findUserSetNextKeyboardNavigationCluster(root, direction);
        if (userSetNextCluster != null && userSetNextCluster.hasFocusable()) {
            return userSetNextCluster;
        }
        return null;
    }

    private View findNextUserSpecifiedFocus(ViewGroup root, View focused, int direction) {
        View userSetNextFocus;
        View cycleCheck = userSetNextFocus = focused.findUserSetNextFocus(root, direction);
        boolean cycleStep = true;
        while (userSetNextFocus != null) {
            if (userSetNextFocus.isFocusable() && userSetNextFocus.getVisibility() == 0 && (!userSetNextFocus.isInTouchMode() || userSetNextFocus.isFocusableInTouchMode())) {
                return userSetNextFocus;
            }
            userSetNextFocus = userSetNextFocus.findUserSetNextFocus(root, direction);
            if (!(cycleStep = !cycleStep) || (cycleCheck = cycleCheck.findUserSetNextFocus(root, direction)) != userSetNextFocus) continue;
            break;
        }
        return null;
    }

    private View findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction, ArrayList<View> focusables) {
        if (focused != null) {
            if (focusedRect == null) {
                focusedRect = this.mFocusedRect;
            }
            focused.getFocusedRect(focusedRect);
            root.offsetDescendantRectToMyCoords(focused, focusedRect);
        } else if (focusedRect == null) {
            focusedRect = this.mFocusedRect;
            switch (direction) {
                case 66: 
                case 130: {
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 2: {
                    if (root.isLayoutRtl()) {
                        this.setFocusBottomRight(root, focusedRect);
                        break;
                    }
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 17: 
                case 33: {
                    this.setFocusBottomRight(root, focusedRect);
                    break;
                }
                case 1: {
                    if (root.isLayoutRtl()) {
                        this.setFocusTopLeft(root, focusedRect);
                        break;
                    }
                    this.setFocusBottomRight(root, focusedRect);
                }
            }
        }
        switch (direction) {
            case 1: 
            case 2: {
                return this.findNextFocusInRelativeDirection(focusables, root, focused, focusedRect, direction);
            }
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return this.findNextFocusInAbsoluteDirection(focusables, root, focused, focusedRect, direction);
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View findNextKeyboardNavigationCluster(View root, View currentCluster, List<View> clusters, int direction) {
        try {
            this.mUserSpecifiedClusterComparator.setFocusables(clusters, root);
            Collections.sort(clusters, this.mUserSpecifiedClusterComparator);
        }
        finally {
            this.mUserSpecifiedClusterComparator.recycle();
        }
        int count = clusters.size();
        switch (direction) {
            case 2: 
            case 66: 
            case 130: {
                return FocusFinder.getNextKeyboardNavigationCluster(root, currentCluster, clusters, count);
            }
            case 1: 
            case 17: 
            case 33: {
                return FocusFinder.getPreviousKeyboardNavigationCluster(root, currentCluster, clusters, count);
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View findNextFocusInRelativeDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        try {
            this.mUserSpecifiedFocusComparator.setFocusables(focusables, root);
            Collections.sort(focusables, this.mUserSpecifiedFocusComparator);
        }
        finally {
            this.mUserSpecifiedFocusComparator.recycle();
        }
        int count = focusables.size();
        if (count < 2) {
            return null;
        }
        View next = null;
        boolean[] looped = new boolean[1];
        switch (direction) {
            case 2: {
                next = FocusFinder.getNextFocusable(focused, focusables, count, looped);
                break;
            }
            case 1: {
                next = FocusFinder.getPreviousFocusable(focused, focusables, count, looped);
            }
        }
        if (root != null && root.mAttachInfo != null && root == root.getRootView()) {
            root.mAttachInfo.mNextFocusLooped = looped[0];
        }
        return next != null ? next : focusables.get(count - 1);
    }

    private void setFocusBottomRight(ViewGroup root, Rect focusedRect) {
        int rootBottom = root.getScrollY() + root.getHeight();
        int rootRight = root.getScrollX() + root.getWidth();
        focusedRect.set(rootRight, rootBottom, rootRight, rootBottom);
    }

    private void setFocusTopLeft(ViewGroup root, Rect focusedRect) {
        int rootTop = root.getScrollY();
        int rootLeft = root.getScrollX();
        focusedRect.set(rootLeft, rootTop, rootLeft, rootTop);
    }

    View findNextFocusInAbsoluteDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        this.mBestCandidateRect.set(focusedRect);
        switch (direction) {
            case 17: {
                this.mBestCandidateRect.offset(focusedRect.width() + 1, 0);
                break;
            }
            case 66: {
                this.mBestCandidateRect.offset(-(focusedRect.width() + 1), 0);
                break;
            }
            case 33: {
                this.mBestCandidateRect.offset(0, focusedRect.height() + 1);
                break;
            }
            case 130: {
                this.mBestCandidateRect.offset(0, -(focusedRect.height() + 1));
            }
        }
        View closest = null;
        int numFocusables = focusables.size();
        for (int i = 0; i < numFocusables; ++i) {
            View focusable = focusables.get(i);
            if (focusable == focused || focusable == root) continue;
            focusable.getFocusedRect(this.mOtherRect);
            root.offsetDescendantRectToMyCoords(focusable, this.mOtherRect);
            if (!this.isBetterCandidate(direction, focusedRect, this.mOtherRect, this.mBestCandidateRect)) continue;
            this.mBestCandidateRect.set(this.mOtherRect);
            closest = focusable;
        }
        return closest;
    }

    private static View getNextFocusable(View focused, ArrayList<View> focusables, int count, boolean[] outLooped) {
        int position;
        if (count < 2) {
            return null;
        }
        if (focused != null && (position = focusables.lastIndexOf(focused)) >= 0 && position + 1 < count) {
            return focusables.get(position + 1);
        }
        outLooped[0] = true;
        return focusables.get(0);
    }

    private static View getPreviousFocusable(View focused, ArrayList<View> focusables, int count, boolean[] outLooped) {
        int position;
        if (count < 2) {
            return null;
        }
        if (focused != null && (position = focusables.indexOf(focused)) > 0) {
            return focusables.get(position - 1);
        }
        outLooped[0] = true;
        return focusables.get(count - 1);
    }

    private static View getNextKeyboardNavigationCluster(View root, View currentCluster, List<View> clusters, int count) {
        if (currentCluster == null) {
            return clusters.get(0);
        }
        int position = clusters.lastIndexOf(currentCluster);
        if (position >= 0 && position + 1 < count) {
            return clusters.get(position + 1);
        }
        return root;
    }

    private static View getPreviousKeyboardNavigationCluster(View root, View currentCluster, List<View> clusters, int count) {
        if (currentCluster == null) {
            return clusters.get(count - 1);
        }
        int position = clusters.indexOf(currentCluster);
        if (position > 0) {
            return clusters.get(position - 1);
        }
        return root;
    }

    boolean isBetterCandidate(int direction, Rect source, Rect rect1, Rect rect2) {
        if (!this.isCandidate(source, rect1, direction)) {
            return false;
        }
        if (!this.isCandidate(source, rect2, direction)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect1, rect2)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect2, rect1)) {
            return false;
        }
        return this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect1), FocusFinder.minorAxisDistance(direction, source, rect1)) < this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect2), FocusFinder.minorAxisDistance(direction, source, rect2));
    }

    boolean beamBeats(int direction, Rect source, Rect rect1, Rect rect2) {
        boolean rect1InSrcBeam = this.beamsOverlap(direction, source, rect1);
        boolean rect2InSrcBeam = this.beamsOverlap(direction, source, rect2);
        if (rect2InSrcBeam || !rect1InSrcBeam) {
            return false;
        }
        if (!this.isToDirectionOf(direction, source, rect2)) {
            return true;
        }
        if (direction == 17 || direction == 66) {
            return true;
        }
        return FocusFinder.majorAxisDistance(direction, source, rect1) < FocusFinder.majorAxisDistanceToFarEdge(direction, source, rect2);
    }

    long getWeightedDistanceFor(long majorAxisDistance, long minorAxisDistance) {
        return 13L * majorAxisDistance * majorAxisDistance + minorAxisDistance * minorAxisDistance;
    }

    boolean isCandidate(Rect srcRect, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return (srcRect.right > destRect.right || srcRect.left >= destRect.right) && srcRect.left > destRect.left;
            }
            case 66: {
                return (srcRect.left < destRect.left || srcRect.right <= destRect.left) && srcRect.right < destRect.right;
            }
            case 33: {
                return (srcRect.bottom > destRect.bottom || srcRect.top >= destRect.bottom) && srcRect.top > destRect.top;
            }
            case 130: {
                return (srcRect.top < destRect.top || srcRect.bottom <= destRect.top) && srcRect.bottom < destRect.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    boolean beamsOverlap(int direction, Rect rect1, Rect rect2) {
        switch (direction) {
            case 17: 
            case 66: {
                return rect2.bottom > rect1.top && rect2.top < rect1.bottom;
            }
            case 33: 
            case 130: {
                return rect2.right > rect1.left && rect2.left < rect1.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    boolean isToDirectionOf(int direction, Rect src, Rect dest) {
        switch (direction) {
            case 17: {
                return src.left >= dest.right;
            }
            case 66: {
                return src.right <= dest.left;
            }
            case 33: {
                return src.top >= dest.bottom;
            }
            case 130: {
                return src.bottom <= dest.top;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    static int majorAxisDistance(int direction, Rect source, Rect dest) {
        return Math.max(0, FocusFinder.majorAxisDistanceRaw(direction, source, dest));
    }

    static int majorAxisDistanceRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.right;
            }
            case 66: {
                return dest.left - source.right;
            }
            case 33: {
                return source.top - dest.bottom;
            }
            case 130: {
                return dest.top - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    static int majorAxisDistanceToFarEdge(int direction, Rect source, Rect dest) {
        return Math.max(1, FocusFinder.majorAxisDistanceToFarEdgeRaw(direction, source, dest));
    }

    static int majorAxisDistanceToFarEdgeRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.left;
            }
            case 66: {
                return dest.right - source.right;
            }
            case 33: {
                return source.top - dest.top;
            }
            case 130: {
                return dest.bottom - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    static int minorAxisDistance(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: 
            case 66: {
                return Math.abs(source.top + source.height() / 2 - (dest.top + dest.height() / 2));
            }
            case 33: 
            case 130: {
                return Math.abs(source.left + source.width() / 2 - (dest.left + dest.width() / 2));
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    public View findNearestTouchable(ViewGroup root, int x, int y, int direction, int[] deltas) {
        ArrayList<View> touchables = root.getTouchables();
        int minDistance = Integer.MAX_VALUE;
        View closest = null;
        int numTouchables = touchables.size();
        int edgeSlop = ViewConfiguration.get(root.mContext).getScaledEdgeSlop();
        Rect closestBounds = new Rect();
        Rect touchableBounds = this.mOtherRect;
        block12: for (int i = 0; i < numTouchables; ++i) {
            View touchable = touchables.get(i);
            touchable.getDrawingRect(touchableBounds);
            root.offsetRectBetweenParentAndChild(touchable, touchableBounds, true, true);
            if (!this.isTouchCandidate(x, y, touchableBounds, direction)) continue;
            int distance = Integer.MAX_VALUE;
            switch (direction) {
                case 17: {
                    distance = x - touchableBounds.right + 1;
                    break;
                }
                case 66: {
                    distance = touchableBounds.left;
                    break;
                }
                case 33: {
                    distance = y - touchableBounds.bottom + 1;
                    break;
                }
                case 130: {
                    distance = touchableBounds.top;
                }
            }
            if (distance >= edgeSlop || closest != null && !closestBounds.contains(touchableBounds) && (touchableBounds.contains(closestBounds) || distance >= minDistance)) continue;
            minDistance = distance;
            closest = touchable;
            closestBounds.set(touchableBounds);
            switch (direction) {
                case 17: {
                    deltas[0] = -distance;
                    continue block12;
                }
                case 66: {
                    deltas[0] = distance;
                    continue block12;
                }
                case 33: {
                    deltas[1] = -distance;
                    continue block12;
                }
                case 130: {
                    deltas[1] = distance;
                }
            }
        }
        return closest;
    }

    private boolean isTouchCandidate(int x, int y, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return destRect.left <= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 66: {
                return destRect.left >= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 33: {
                return destRect.top <= y && destRect.left <= x && x <= destRect.right;
            }
            case 130: {
                return destRect.top >= y && destRect.left <= x && x <= destRect.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static boolean isValidId(int id2) {
        return id2 != 0 && id2 != -1;
    }

    public static void sort(View[] views, int start, int end, ViewGroup root, boolean isRtl) {
        FocusFinder.getInstance().mFocusSorter.sort(views, start, end, root, isRtl);
    }

    private static class UserSpecifiedFocusComparator
    implements Comparator<View> {
        private final ArrayMap<View, View> mNextFoci = new ArrayMap();
        private final ArraySet<View> mIsConnectedTo = new ArraySet();
        private final ArrayMap<View, View> mHeadsOfChains = new ArrayMap();
        private final ArrayMap<View, Integer> mOriginalOrdinal = new ArrayMap();
        private final NextFocusGetter mNextFocusGetter;
        private View mRoot;

        UserSpecifiedFocusComparator(NextFocusGetter nextFocusGetter) {
            this.mNextFocusGetter = nextFocusGetter;
        }

        public void recycle() {
            this.mRoot = null;
            this.mHeadsOfChains.clear();
            this.mIsConnectedTo.clear();
            this.mOriginalOrdinal.clear();
            this.mNextFoci.clear();
        }

        public void setFocusables(List<View> focusables, View root) {
            View next;
            View view;
            int i;
            this.mRoot = root;
            for (i = 0; i < focusables.size(); ++i) {
                this.mOriginalOrdinal.put(focusables.get(i), i);
            }
            for (i = focusables.size() - 1; i >= 0; --i) {
                view = focusables.get(i);
                next = this.mNextFocusGetter.get(this.mRoot, view);
                if (next == null || !this.mOriginalOrdinal.containsKey(next)) continue;
                this.mNextFoci.put(view, next);
                this.mIsConnectedTo.add(next);
            }
            for (i = focusables.size() - 1; i >= 0; --i) {
                view = focusables.get(i);
                next = this.mNextFoci.get(view);
                if (next == null || this.mIsConnectedTo.contains(view)) continue;
                this.setHeadOfChain(view);
            }
        }

        private void setHeadOfChain(View head) {
            View view = head;
            while (view != null) {
                View otherHead = this.mHeadsOfChains.get(view);
                if (otherHead != null) {
                    if (otherHead == head) {
                        return;
                    }
                    view = head;
                    head = otherHead;
                }
                this.mHeadsOfChains.put(view, head);
                view = this.mNextFoci.get(view);
            }
        }

        @Override
        public int compare(View first, View second) {
            View secondHead;
            if (first == second) {
                return 0;
            }
            View firstHead = this.mHeadsOfChains.get(first);
            if (firstHead == (secondHead = this.mHeadsOfChains.get(second)) && firstHead != null) {
                if (first == firstHead) {
                    return -1;
                }
                if (second == firstHead) {
                    return 1;
                }
                if (this.mNextFoci.get(first) != null) {
                    return -1;
                }
                return 1;
            }
            boolean involvesChain = false;
            if (firstHead != null) {
                first = firstHead;
                involvesChain = true;
            }
            if (secondHead != null) {
                second = secondHead;
                involvesChain = true;
            }
            if (involvesChain) {
                return this.mOriginalOrdinal.get(first) < this.mOriginalOrdinal.get(second) ? -1 : 1;
            }
            return 0;
        }

        public static interface NextFocusGetter {
            public View get(View var1, View var2);
        }
    }

    static class FocusSorter {
        private ArrayList<Rect> mRectPool = new ArrayList();
        private int mLastPoolRect;
        private int mRtlMult;
        private HashMap<View, Rect> mRectByView = null;
        private Comparator<View> mTopsComparator = (first, second) -> {
            if (first == second) {
                return 0;
            }
            Rect firstRect = this.mRectByView.get(first);
            Rect secondRect = this.mRectByView.get(second);
            int result = firstRect.top - secondRect.top;
            if (result == 0) {
                return firstRect.bottom - secondRect.bottom;
            }
            return result;
        };
        private Comparator<View> mSidesComparator = (first, second) -> {
            if (first == second) {
                return 0;
            }
            Rect firstRect = this.mRectByView.get(first);
            Rect secondRect = this.mRectByView.get(second);
            int result = firstRect.left - secondRect.left;
            if (result == 0) {
                return firstRect.right - secondRect.right;
            }
            return this.mRtlMult * result;
        };

        FocusSorter() {
        }

        public void sort(View[] views, int start, int end, ViewGroup root, boolean isRtl) {
            int sweepIdx;
            int i;
            int count = end - start;
            if (count < 2) {
                return;
            }
            if (this.mRectByView == null) {
                this.mRectByView = new HashMap();
            }
            this.mRtlMult = isRtl ? -1 : 1;
            for (i = this.mRectPool.size(); i < count; ++i) {
                this.mRectPool.add(new Rect());
            }
            for (i = start; i < end; ++i) {
                Rect next = this.mRectPool.get(this.mLastPoolRect++);
                views[i].getDrawingRect(next);
                root.offsetDescendantRectToMyCoords(views[i], next);
                this.mRectByView.put(views[i], next);
            }
            Arrays.sort(views, start, count, this.mTopsComparator);
            int sweepBottom = this.mRectByView.get((Object)views[start]).bottom;
            int rowStart = start;
            for (sweepIdx = start + 1; sweepIdx < end; ++sweepIdx) {
                Rect currRect = this.mRectByView.get(views[sweepIdx]);
                if (currRect.top >= sweepBottom) {
                    if (sweepIdx - rowStart > 1) {
                        Arrays.sort(views, rowStart, sweepIdx, this.mSidesComparator);
                    }
                    sweepBottom = currRect.bottom;
                    rowStart = sweepIdx;
                    continue;
                }
                sweepBottom = Math.max(sweepBottom, currRect.bottom);
            }
            if (sweepIdx - rowStart > 1) {
                Arrays.sort(views, rowStart, sweepIdx, this.mSidesComparator);
            }
            this.mLastPoolRect = 0;
            this.mRectByView.clear();
        }
    }
}

