/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.WindowManager;

public interface ISurfaceControlViewHostParent
extends IInterface {
    public static final String DESCRIPTOR = "android.view.ISurfaceControlViewHostParent";

    public void updateParams(WindowManager.LayoutParams[] var1) throws RemoteException;

    public void forwardBackKeyToParent(KeyEvent var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISurfaceControlViewHostParent {
        static final int TRANSACTION_updateParams = 1;
        static final int TRANSACTION_forwardBackKeyToParent = 2;

        public Stub() {
            this.attachInterface(this, ISurfaceControlViewHostParent.DESCRIPTOR);
        }

        public static ISurfaceControlViewHostParent asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISurfaceControlViewHostParent.DESCRIPTOR);
            if (iin != null && iin instanceof ISurfaceControlViewHostParent) {
                return (ISurfaceControlViewHostParent)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "updateParams";
                }
                case 2: {
                    return "forwardBackKeyToParent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISurfaceControlViewHostParent.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    WindowManager.LayoutParams[] _arg0 = data.createTypedArray(WindowManager.LayoutParams.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateParams(_arg0);
                    break;
                }
                case 2: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.forwardBackKeyToParent(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISurfaceControlViewHostParent {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISurfaceControlViewHostParent.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateParams(WindowManager.LayoutParams[] childAttrs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHostParent.DESCRIPTOR);
                    _data.writeTypedArray(childAttrs, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forwardBackKeyToParent(KeyEvent keyEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHostParent.DESCRIPTOR);
                    _data.writeTypedObject(keyEvent, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISurfaceControlViewHostParent {
        @Override
        public void updateParams(WindowManager.LayoutParams[] childAttrs) throws RemoteException {
        }

        @Override
        public void forwardBackKeyToParent(KeyEvent keyEvent) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

