/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.IApplicationThread;
import android.app.IAssistDataReceiver;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.DisplayInfo;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.ICrossWindowBlurEnabledListener;
import android.view.IDecorViewGestureListener;
import android.view.IDisplayChangeWindowController;
import android.view.IDisplayFoldListener;
import android.view.IDisplayWindowInsetsController;
import android.view.IDisplayWindowListener;
import android.view.IOnKeyguardExitResult;
import android.view.IPinnedTaskListener;
import android.view.IRotationWatcher;
import android.view.IScrollCaptureResponseListener;
import android.view.ISystemGestureExclusionListener;
import android.view.IWallpaperVisibilityListener;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InsetsState;
import android.view.KeyboardShortcutGroup;
import android.view.RemoteAnimationAdapter;
import android.view.SurfaceControl;
import android.view.WindowContentFrameStats;
import android.view.displayhash.DisplayHash;
import android.view.displayhash.VerifiedDisplayHash;
import android.view.inputmethod.ImeTracker;
import android.window.AddToSurfaceSyncGroupResult;
import android.window.ConfigurationChangeSetting;
import android.window.IGlobalDragListener;
import android.window.IScreenRecordingCallback;
import android.window.ISurfaceSyncGroupCompletedListener;
import android.window.ITaskFpsCallback;
import android.window.ITrustedPresentationListener;
import android.window.InputTransferToken;
import android.window.ScreenCapture;
import android.window.TrustedPresentationThresholds;
import android.window.WindowContextInfo;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IKeyguardLockedStateListener;
import com.android.internal.policy.IShortcutService;
import java.util.ArrayList;
import java.util.List;

public interface IWindowManager
extends IInterface {
    public static final int FIXED_TO_USER_ROTATION_DEFAULT = 0;
    public static final int FIXED_TO_USER_ROTATION_DISABLED = 1;
    public static final int FIXED_TO_USER_ROTATION_ENABLED = 2;
    public static final int FIXED_TO_USER_ROTATION_IF_NO_AUTO_ROTATION = 3;

    public boolean startViewServer(int var1) throws RemoteException;

    public boolean stopViewServer() throws RemoteException;

    public boolean isViewServerRunning() throws RemoteException;

    public IWindowSession openSession(IWindowSessionCallback var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:124:1:124:25")
    public void getInitialDisplaySize(int var1, Point var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:126:1:126:25")
    public void getBaseDisplaySize(int var1, Point var2) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setForcedDisplaySize(int var1, int var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void clearForcedDisplaySize(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:132:1:132:25")
    public int getInitialDisplayDensity(int var1) throws RemoteException;

    public int getBaseDisplayDensity(int var1) throws RemoteException;

    public int getDisplayIdByUniqueId(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setForcedDisplayDensityForUser(int var1, int var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void clearForcedDisplayDensityForUser(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setForcedDisplayDensityRatio(int var1, float var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setConfigurationChangeSettingsForUser(List<ConfigurationChangeSetting> var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setForcedDisplayScalingMode(int var1, int var2) throws RemoteException;

    public void setEventDispatching(boolean var1) throws RemoteException;

    public boolean isWindowToken(IBinder var1) throws RemoteException;

    public void addWindowToken(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void removeWindowToken(IBinder var1, int var2) throws RemoteException;

    public void setDisplayChangeWindowController(IDisplayChangeWindowController var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_APP_TOKENS")
    public SurfaceControl addShellRoot(int var1, IWindow var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_APP_TOKENS")
    public void setShellRootAccessibilityWindow(int var1, int var2, IWindow var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:235:1:235:25")
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture var1, IRemoteCallback var2, boolean var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:239:1:239:25")
    public void overridePendingAppTransitionRemote(RemoteAnimationAdapter var1, int var2) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:247:1:247:69")
    public void endProlongedAnimations() throws RemoteException;

    @Deprecated
    public void disableKeyguard(IBinder var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public void reenableKeyguard(IBinder var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.DISABLE_KEYGUARD")
    public void exitKeyguardSecurely(IOnKeyguardExitResult var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:257:1:257:25")
    public boolean isKeyguardLocked() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:259:1:259:69")
    public boolean isKeyguardSecure(int var1) throws RemoteException;

    public void dismissKeyguard(IKeyguardDismissCallback var1, CharSequence var2) throws RemoteException;

    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void addKeyguardLockedStateListener(IKeyguardLockedStateListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener var1) throws RemoteException;

    public void setSwitchingUser(boolean var1) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:277:1:277:25")
    public float getAnimationScale(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:279:1:279:69")
    public float[] getAnimationScales() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:281:1:281:25")
    public void setAnimationScale(int var1, float var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:283:1:283:69")
    public void setAnimationScales(float[] var1) throws RemoteException;

    public float getCurrentAnimatorScale() throws RemoteException;

    public void setInTouchMode(boolean var1, int var2) throws RemoteException;

    public void setInTouchModeOnAllDisplays(boolean var1) throws RemoteException;

    public boolean isInTouchMode(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:306:1:306:44")
    public void showStrictModeViolation(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:313:1:313:69")
    public void setStrictModeVisualIndicatorPreference(String var1) throws RemoteException;

    public void refreshScreenCaptureDisabled() throws RemoteException;

    public int getDefaultDisplayRotation() throws RemoteException;

    public int getDisplayUserRotation(int var1) throws RemoteException;

    public int watchRotation(IRotationWatcher var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:349:1:349:25")
    public void removeRotationWatcher(IRotationWatcher var1) throws RemoteException;

    public int registerProposedRotationListener(IBinder var1, IRotationWatcher var2) throws RemoteException;

    public int getPreferredOptionsPanelGravity(int var1) throws RemoteException;

    public void setDeviceStateAutoRotateSetting(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:374:1:374:25")
    public void freezeRotation(int var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:381:1:381:25")
    public void thawRotation(String var1) throws RemoteException;

    public boolean isRotationFrozen() throws RemoteException;

    public void setRotationAtAngleIfAllowed(int var1, String var2) throws RemoteException;

    public void freezeDisplayRotation(int var1, int var2, String var3) throws RemoteException;

    public void thawDisplayRotation(int var1, String var2) throws RemoteException;

    public boolean isDisplayRotationFrozen(int var1) throws RemoteException;

    public void setFixedToUserRotation(int var1, int var2) throws RemoteException;

    public void setIgnoreOrientationRequest(int var1, boolean var2) throws RemoteException;

    public Bitmap screenshotWallpaper() throws RemoteException;

    public SurfaceControl mirrorWallpaperSurface(int var1) throws RemoteException;

    public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public void requestAssistScreenshot(IAssistDataReceiver var1) throws RemoteException;

    public void hideTransientBars(int var1) throws RemoteException;

    public void setRecentsVisibility(boolean var1) throws RemoteException;

    public void updateStaticPrivacyIndicatorBounds(int var1, Rect[] var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:497:1:497:25")
    @EnforcePermission(value="android.permission.STATUS_BAR")
    public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:505:1:505:25")
    public boolean hasNavigationBar(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:511:1:511:69")
    public void lockNow(Bundle var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:517:1:517:25")
    public boolean isSafeModeEnabled() throws RemoteException;

    public boolean clearWindowContentFrameStats(IBinder var1) throws RemoteException;

    public WindowContentFrameStats getWindowContentFrameStats(IBinder var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:539:1:539:25")
    public int getDockedStackSide() throws RemoteException;

    public void registerPinnedTaskListener(int var1, IPinnedTaskListener var2) throws RemoteException;

    public void requestAppKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    public void requestImeKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:570:1:570:25")
    public void getStableInsets(int var1, Rect var2) throws RemoteException;

    public void registerShortcutKey(long var1, IShortcutService var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:583:1:583:25")
    public void createInputConsumer(IBinder var1, String var2, int var3, InputChannel var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:591:1:591:25")
    public boolean destroyInputConsumer(IBinder var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public Region getCurrentImeTouchRegion() throws RemoteException;

    public void registerDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public void unregisterDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public int[] registerDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void unregisterDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void startWindowTrace() throws RemoteException;

    public void stopWindowTrace() throws RemoteException;

    public void saveWindowTraceToFile() throws RemoteException;

    public boolean isWindowTraceEnabled() throws RemoteException;

    public void startTransitionTrace() throws RemoteException;

    public void stopTransitionTrace() throws RemoteException;

    public boolean isTransitionTraceEnabled() throws RemoteException;

    public int getWindowingMode(int var1) throws RemoteException;

    public void setWindowingMode(int var1, int var2) throws RemoteException;

    public int getRemoveContentMode(int var1) throws RemoteException;

    public void setRemoveContentMode(int var1, int var2) throws RemoteException;

    public boolean shouldShowWithInsecureKeyguard(int var1) throws RemoteException;

    public void setShouldShowWithInsecureKeyguard(int var1, boolean var2) throws RemoteException;

    public boolean shouldShowSystemDecors(int var1) throws RemoteException;

    public void setShouldShowSystemDecors(int var1, boolean var2) throws RemoteException;

    public boolean isEligibleForDesktopMode(int var1) throws RemoteException;

    public int getDisplayImePolicy(int var1) throws RemoteException;

    public void setDisplayImePolicy(int var1, int var2) throws RemoteException;

    public void onNotificationShadeExpanded(IBinder var1, boolean var2) throws RemoteException;

    public void syncInputTransactions(boolean var1) throws RemoteException;

    public boolean isLayerTracing() throws RemoteException;

    public void setLayerTracing(boolean var1) throws RemoteException;

    public boolean mirrorDisplay(int var1, SurfaceControl var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_APP_TOKENS")
    public void setDisplayWindowInsetsController(int var1, IDisplayWindowInsetsController var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_APP_TOKENS")
    public void updateDisplayWindowRequestedVisibleTypes(int var1, int var2, int var3, ImeTracker.Token var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_APP_TOKENS")
    public void updateDisplayWindowAnimatingTypes(int var1, int var2, ImeTracker.Token var3) throws RemoteException;

    public void getWindowInsets(int var1, IBinder var2, InsetsState var3) throws RemoteException;

    public List<DisplayInfo> getPossibleDisplayInfo(int var1) throws RemoteException;

    public void showGlobalActions() throws RemoteException;

    public void setLayerTracingFlags(int var1) throws RemoteException;

    public void setActiveTransactionTracing(boolean var1) throws RemoteException;

    public void requestScrollCapture(int var1, IBinder var2, int var3, IScrollCaptureResponseListener var4) throws RemoteException;

    public void holdLock(IBinder var1, int var2) throws RemoteException;

    public String[] getSupportedDisplayHashAlgorithms() throws RemoteException;

    public VerifiedDisplayHash verifyDisplayHash(DisplayHash var1) throws RemoteException;

    public void setDisplayHashThrottlingEnabled(boolean var1) throws RemoteException;

    public WindowContextInfo attachWindowContextToDisplayArea(IApplicationThread var1, IBinder var2, int var3, int var4, Bundle var5) throws RemoteException;

    public WindowContextInfo attachWindowContextToWindowToken(IApplicationThread var1, IBinder var2, IBinder var3) throws RemoteException;

    public WindowContextInfo attachWindowContextToDisplayContent(IApplicationThread var1, IBinder var2, int var3) throws RemoteException;

    public void detachWindowContext(IBinder var1) throws RemoteException;

    public boolean reparentWindowContextToDisplayArea(IApplicationThread var1, IBinder var2, int var3) throws RemoteException;

    public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public boolean isTaskSnapshotSupported() throws RemoteException;

    public int getImeDisplayId() throws RemoteException;

    public void setTaskSnapshotEnabled(boolean var1) throws RemoteException;

    public void registerTaskFpsCallback(int var1, ITaskFpsCallback var2) throws RemoteException;

    public void unregisterTaskFpsCallback(ITaskFpsCallback var1) throws RemoteException;

    public Bitmap snapshotTaskForRecents(int var1) throws RemoteException;

    public void setRecentsAppBehindSystemBars(boolean var1) throws RemoteException;

    public int getLetterboxBackgroundColorInArgb() throws RemoteException;

    public boolean isLetterboxBackgroundMultiColored() throws RemoteException;

    public void captureDisplay(int var1, ScreenCapture.CaptureArgs var2, ScreenCapture.ScreenCaptureListener var3) throws RemoteException;

    public boolean isGlobalKey(int var1) throws RemoteException;

    public boolean addToSurfaceSyncGroup(IBinder var1, boolean var2, ISurfaceSyncGroupCompletedListener var3, AddToSurfaceSyncGroupResult var4) throws RemoteException;

    public void markSurfaceSyncGroupReady(IBinder var1) throws RemoteException;

    public List<ComponentName> notifyScreenshotListeners(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.ACCESS_SURFACE_FLINGER")
    public boolean replaceContentOnDisplay(int var1, SurfaceControl var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_INPUT")
    public void registerDecorViewGestureListener(IDecorViewGestureListener var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_INPUT")
    public void unregisterDecorViewGestureListener(IDecorViewGestureListener var1, int var2) throws RemoteException;

    public void registerTrustedPresentationListener(IBinder var1, ITrustedPresentationListener var2, TrustedPresentationThresholds var3, int var4) throws RemoteException;

    public void unregisterTrustedPresentationListener(ITrustedPresentationListener var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.DETECT_SCREEN_RECORDING")
    public boolean registerScreenRecordingCallback(IScreenRecordingCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.DETECT_SCREEN_RECORDING")
    public void unregisterScreenRecordingCallback(IScreenRecordingCallback var1) throws RemoteException;

    public void setGlobalDragListener(IGlobalDragListener var1) throws RemoteException;

    public boolean transferTouchGesture(InputTransferToken var1, InputTransferToken var2) throws RemoteException;

    public KeyboardShortcutGroup getApplicationLaunchKeyboardShortcuts(int var1) throws RemoteException;

    public boolean getIgnoreOrientationRequest(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.view.IWindowManager";
        static final int TRANSACTION_startViewServer = 1;
        static final int TRANSACTION_stopViewServer = 2;
        static final int TRANSACTION_isViewServerRunning = 3;
        static final int TRANSACTION_openSession = 4;
        static final int TRANSACTION_getInitialDisplaySize = 5;
        static final int TRANSACTION_getBaseDisplaySize = 6;
        static final int TRANSACTION_setForcedDisplaySize = 7;
        static final int TRANSACTION_clearForcedDisplaySize = 8;
        static final int TRANSACTION_getInitialDisplayDensity = 9;
        static final int TRANSACTION_getBaseDisplayDensity = 10;
        static final int TRANSACTION_getDisplayIdByUniqueId = 11;
        static final int TRANSACTION_setForcedDisplayDensityForUser = 12;
        static final int TRANSACTION_clearForcedDisplayDensityForUser = 13;
        static final int TRANSACTION_setForcedDisplayDensityRatio = 14;
        static final int TRANSACTION_setConfigurationChangeSettingsForUser = 15;
        static final int TRANSACTION_setForcedDisplayScalingMode = 16;
        static final int TRANSACTION_setEventDispatching = 17;
        static final int TRANSACTION_isWindowToken = 18;
        static final int TRANSACTION_addWindowToken = 19;
        static final int TRANSACTION_removeWindowToken = 20;
        static final int TRANSACTION_setDisplayChangeWindowController = 21;
        static final int TRANSACTION_addShellRoot = 22;
        static final int TRANSACTION_setShellRootAccessibilityWindow = 23;
        static final int TRANSACTION_overridePendingAppTransitionMultiThumbFuture = 24;
        static final int TRANSACTION_overridePendingAppTransitionRemote = 25;
        static final int TRANSACTION_endProlongedAnimations = 26;
        static final int TRANSACTION_disableKeyguard = 27;
        static final int TRANSACTION_reenableKeyguard = 28;
        static final int TRANSACTION_exitKeyguardSecurely = 29;
        static final int TRANSACTION_isKeyguardLocked = 30;
        static final int TRANSACTION_isKeyguardSecure = 31;
        static final int TRANSACTION_dismissKeyguard = 32;
        static final int TRANSACTION_addKeyguardLockedStateListener = 33;
        static final int TRANSACTION_removeKeyguardLockedStateListener = 34;
        static final int TRANSACTION_setSwitchingUser = 35;
        static final int TRANSACTION_closeSystemDialogs = 36;
        static final int TRANSACTION_getAnimationScale = 37;
        static final int TRANSACTION_getAnimationScales = 38;
        static final int TRANSACTION_setAnimationScale = 39;
        static final int TRANSACTION_setAnimationScales = 40;
        static final int TRANSACTION_getCurrentAnimatorScale = 41;
        static final int TRANSACTION_setInTouchMode = 42;
        static final int TRANSACTION_setInTouchModeOnAllDisplays = 43;
        static final int TRANSACTION_isInTouchMode = 44;
        static final int TRANSACTION_showStrictModeViolation = 45;
        static final int TRANSACTION_setStrictModeVisualIndicatorPreference = 46;
        static final int TRANSACTION_refreshScreenCaptureDisabled = 47;
        static final int TRANSACTION_getDefaultDisplayRotation = 48;
        static final int TRANSACTION_getDisplayUserRotation = 49;
        static final int TRANSACTION_watchRotation = 50;
        static final int TRANSACTION_removeRotationWatcher = 51;
        static final int TRANSACTION_registerProposedRotationListener = 52;
        static final int TRANSACTION_getPreferredOptionsPanelGravity = 53;
        static final int TRANSACTION_setDeviceStateAutoRotateSetting = 54;
        static final int TRANSACTION_freezeRotation = 55;
        static final int TRANSACTION_thawRotation = 56;
        static final int TRANSACTION_isRotationFrozen = 57;
        static final int TRANSACTION_setRotationAtAngleIfAllowed = 58;
        static final int TRANSACTION_freezeDisplayRotation = 59;
        static final int TRANSACTION_thawDisplayRotation = 60;
        static final int TRANSACTION_isDisplayRotationFrozen = 61;
        static final int TRANSACTION_setFixedToUserRotation = 62;
        static final int TRANSACTION_setIgnoreOrientationRequest = 63;
        static final int TRANSACTION_screenshotWallpaper = 64;
        static final int TRANSACTION_mirrorWallpaperSurface = 65;
        static final int TRANSACTION_registerWallpaperVisibilityListener = 66;
        static final int TRANSACTION_unregisterWallpaperVisibilityListener = 67;
        static final int TRANSACTION_registerSystemGestureExclusionListener = 68;
        static final int TRANSACTION_unregisterSystemGestureExclusionListener = 69;
        static final int TRANSACTION_requestAssistScreenshot = 70;
        static final int TRANSACTION_hideTransientBars = 71;
        static final int TRANSACTION_setRecentsVisibility = 72;
        static final int TRANSACTION_updateStaticPrivacyIndicatorBounds = 73;
        static final int TRANSACTION_setNavBarVirtualKeyHapticFeedbackEnabled = 74;
        static final int TRANSACTION_hasNavigationBar = 75;
        static final int TRANSACTION_lockNow = 76;
        static final int TRANSACTION_isSafeModeEnabled = 77;
        static final int TRANSACTION_clearWindowContentFrameStats = 78;
        static final int TRANSACTION_getWindowContentFrameStats = 79;
        static final int TRANSACTION_getDockedStackSide = 80;
        static final int TRANSACTION_registerPinnedTaskListener = 81;
        static final int TRANSACTION_requestAppKeyboardShortcuts = 82;
        static final int TRANSACTION_requestImeKeyboardShortcuts = 83;
        static final int TRANSACTION_getStableInsets = 84;
        static final int TRANSACTION_registerShortcutKey = 85;
        static final int TRANSACTION_createInputConsumer = 86;
        static final int TRANSACTION_destroyInputConsumer = 87;
        static final int TRANSACTION_getCurrentImeTouchRegion = 88;
        static final int TRANSACTION_registerDisplayFoldListener = 89;
        static final int TRANSACTION_unregisterDisplayFoldListener = 90;
        static final int TRANSACTION_registerDisplayWindowListener = 91;
        static final int TRANSACTION_unregisterDisplayWindowListener = 92;
        static final int TRANSACTION_startWindowTrace = 93;
        static final int TRANSACTION_stopWindowTrace = 94;
        static final int TRANSACTION_saveWindowTraceToFile = 95;
        static final int TRANSACTION_isWindowTraceEnabled = 96;
        static final int TRANSACTION_startTransitionTrace = 97;
        static final int TRANSACTION_stopTransitionTrace = 98;
        static final int TRANSACTION_isTransitionTraceEnabled = 99;
        static final int TRANSACTION_getWindowingMode = 100;
        static final int TRANSACTION_setWindowingMode = 101;
        static final int TRANSACTION_getRemoveContentMode = 102;
        static final int TRANSACTION_setRemoveContentMode = 103;
        static final int TRANSACTION_shouldShowWithInsecureKeyguard = 104;
        static final int TRANSACTION_setShouldShowWithInsecureKeyguard = 105;
        static final int TRANSACTION_shouldShowSystemDecors = 106;
        static final int TRANSACTION_setShouldShowSystemDecors = 107;
        static final int TRANSACTION_isEligibleForDesktopMode = 108;
        static final int TRANSACTION_getDisplayImePolicy = 109;
        static final int TRANSACTION_setDisplayImePolicy = 110;
        static final int TRANSACTION_onNotificationShadeExpanded = 111;
        static final int TRANSACTION_syncInputTransactions = 112;
        static final int TRANSACTION_isLayerTracing = 113;
        static final int TRANSACTION_setLayerTracing = 114;
        static final int TRANSACTION_mirrorDisplay = 115;
        static final int TRANSACTION_setDisplayWindowInsetsController = 116;
        static final int TRANSACTION_updateDisplayWindowRequestedVisibleTypes = 117;
        static final int TRANSACTION_updateDisplayWindowAnimatingTypes = 118;
        static final int TRANSACTION_getWindowInsets = 119;
        static final int TRANSACTION_getPossibleDisplayInfo = 120;
        static final int TRANSACTION_showGlobalActions = 121;
        static final int TRANSACTION_setLayerTracingFlags = 122;
        static final int TRANSACTION_setActiveTransactionTracing = 123;
        static final int TRANSACTION_requestScrollCapture = 124;
        static final int TRANSACTION_holdLock = 125;
        static final int TRANSACTION_getSupportedDisplayHashAlgorithms = 126;
        static final int TRANSACTION_verifyDisplayHash = 127;
        static final int TRANSACTION_setDisplayHashThrottlingEnabled = 128;
        static final int TRANSACTION_attachWindowContextToDisplayArea = 129;
        static final int TRANSACTION_attachWindowContextToWindowToken = 130;
        static final int TRANSACTION_attachWindowContextToDisplayContent = 131;
        static final int TRANSACTION_detachWindowContext = 132;
        static final int TRANSACTION_reparentWindowContextToDisplayArea = 133;
        static final int TRANSACTION_registerCrossWindowBlurEnabledListener = 134;
        static final int TRANSACTION_unregisterCrossWindowBlurEnabledListener = 135;
        static final int TRANSACTION_isTaskSnapshotSupported = 136;
        static final int TRANSACTION_getImeDisplayId = 137;
        static final int TRANSACTION_setTaskSnapshotEnabled = 138;
        static final int TRANSACTION_registerTaskFpsCallback = 139;
        static final int TRANSACTION_unregisterTaskFpsCallback = 140;
        static final int TRANSACTION_snapshotTaskForRecents = 141;
        static final int TRANSACTION_setRecentsAppBehindSystemBars = 142;
        static final int TRANSACTION_getLetterboxBackgroundColorInArgb = 143;
        static final int TRANSACTION_isLetterboxBackgroundMultiColored = 144;
        static final int TRANSACTION_captureDisplay = 145;
        static final int TRANSACTION_isGlobalKey = 146;
        static final int TRANSACTION_addToSurfaceSyncGroup = 147;
        static final int TRANSACTION_markSurfaceSyncGroupReady = 148;
        static final int TRANSACTION_notifyScreenshotListeners = 149;
        static final int TRANSACTION_replaceContentOnDisplay = 150;
        static final int TRANSACTION_registerDecorViewGestureListener = 151;
        static final int TRANSACTION_unregisterDecorViewGestureListener = 152;
        static final int TRANSACTION_registerTrustedPresentationListener = 153;
        static final int TRANSACTION_unregisterTrustedPresentationListener = 154;
        static final int TRANSACTION_registerScreenRecordingCallback = 155;
        static final int TRANSACTION_unregisterScreenRecordingCallback = 156;
        static final int TRANSACTION_setGlobalDragListener = 157;
        static final int TRANSACTION_transferTouchGesture = 158;
        static final int TRANSACTION_getApplicationLaunchKeyboardShortcuts = 159;
        static final int TRANSACTION_getIgnoreOrientationRequest = 160;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IWindowManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowManager) {
                return (IWindowManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startViewServer";
                }
                case 2: {
                    return "stopViewServer";
                }
                case 3: {
                    return "isViewServerRunning";
                }
                case 4: {
                    return "openSession";
                }
                case 5: {
                    return "getInitialDisplaySize";
                }
                case 6: {
                    return "getBaseDisplaySize";
                }
                case 7: {
                    return "setForcedDisplaySize";
                }
                case 8: {
                    return "clearForcedDisplaySize";
                }
                case 9: {
                    return "getInitialDisplayDensity";
                }
                case 10: {
                    return "getBaseDisplayDensity";
                }
                case 11: {
                    return "getDisplayIdByUniqueId";
                }
                case 12: {
                    return "setForcedDisplayDensityForUser";
                }
                case 13: {
                    return "clearForcedDisplayDensityForUser";
                }
                case 14: {
                    return "setForcedDisplayDensityRatio";
                }
                case 15: {
                    return "setConfigurationChangeSettingsForUser";
                }
                case 16: {
                    return "setForcedDisplayScalingMode";
                }
                case 17: {
                    return "setEventDispatching";
                }
                case 18: {
                    return "isWindowToken";
                }
                case 19: {
                    return "addWindowToken";
                }
                case 20: {
                    return "removeWindowToken";
                }
                case 21: {
                    return "setDisplayChangeWindowController";
                }
                case 22: {
                    return "addShellRoot";
                }
                case 23: {
                    return "setShellRootAccessibilityWindow";
                }
                case 24: {
                    return "overridePendingAppTransitionMultiThumbFuture";
                }
                case 25: {
                    return "overridePendingAppTransitionRemote";
                }
                case 26: {
                    return "endProlongedAnimations";
                }
                case 27: {
                    return "disableKeyguard";
                }
                case 28: {
                    return "reenableKeyguard";
                }
                case 29: {
                    return "exitKeyguardSecurely";
                }
                case 30: {
                    return "isKeyguardLocked";
                }
                case 31: {
                    return "isKeyguardSecure";
                }
                case 32: {
                    return "dismissKeyguard";
                }
                case 33: {
                    return "addKeyguardLockedStateListener";
                }
                case 34: {
                    return "removeKeyguardLockedStateListener";
                }
                case 35: {
                    return "setSwitchingUser";
                }
                case 36: {
                    return "closeSystemDialogs";
                }
                case 37: {
                    return "getAnimationScale";
                }
                case 38: {
                    return "getAnimationScales";
                }
                case 39: {
                    return "setAnimationScale";
                }
                case 40: {
                    return "setAnimationScales";
                }
                case 41: {
                    return "getCurrentAnimatorScale";
                }
                case 42: {
                    return "setInTouchMode";
                }
                case 43: {
                    return "setInTouchModeOnAllDisplays";
                }
                case 44: {
                    return "isInTouchMode";
                }
                case 45: {
                    return "showStrictModeViolation";
                }
                case 46: {
                    return "setStrictModeVisualIndicatorPreference";
                }
                case 47: {
                    return "refreshScreenCaptureDisabled";
                }
                case 48: {
                    return "getDefaultDisplayRotation";
                }
                case 49: {
                    return "getDisplayUserRotation";
                }
                case 50: {
                    return "watchRotation";
                }
                case 51: {
                    return "removeRotationWatcher";
                }
                case 52: {
                    return "registerProposedRotationListener";
                }
                case 53: {
                    return "getPreferredOptionsPanelGravity";
                }
                case 54: {
                    return "setDeviceStateAutoRotateSetting";
                }
                case 55: {
                    return "freezeRotation";
                }
                case 56: {
                    return "thawRotation";
                }
                case 57: {
                    return "isRotationFrozen";
                }
                case 58: {
                    return "setRotationAtAngleIfAllowed";
                }
                case 59: {
                    return "freezeDisplayRotation";
                }
                case 60: {
                    return "thawDisplayRotation";
                }
                case 61: {
                    return "isDisplayRotationFrozen";
                }
                case 62: {
                    return "setFixedToUserRotation";
                }
                case 63: {
                    return "setIgnoreOrientationRequest";
                }
                case 64: {
                    return "screenshotWallpaper";
                }
                case 65: {
                    return "mirrorWallpaperSurface";
                }
                case 66: {
                    return "registerWallpaperVisibilityListener";
                }
                case 67: {
                    return "unregisterWallpaperVisibilityListener";
                }
                case 68: {
                    return "registerSystemGestureExclusionListener";
                }
                case 69: {
                    return "unregisterSystemGestureExclusionListener";
                }
                case 70: {
                    return "requestAssistScreenshot";
                }
                case 71: {
                    return "hideTransientBars";
                }
                case 72: {
                    return "setRecentsVisibility";
                }
                case 73: {
                    return "updateStaticPrivacyIndicatorBounds";
                }
                case 74: {
                    return "setNavBarVirtualKeyHapticFeedbackEnabled";
                }
                case 75: {
                    return "hasNavigationBar";
                }
                case 76: {
                    return "lockNow";
                }
                case 77: {
                    return "isSafeModeEnabled";
                }
                case 78: {
                    return "clearWindowContentFrameStats";
                }
                case 79: {
                    return "getWindowContentFrameStats";
                }
                case 80: {
                    return "getDockedStackSide";
                }
                case 81: {
                    return "registerPinnedTaskListener";
                }
                case 82: {
                    return "requestAppKeyboardShortcuts";
                }
                case 83: {
                    return "requestImeKeyboardShortcuts";
                }
                case 84: {
                    return "getStableInsets";
                }
                case 85: {
                    return "registerShortcutKey";
                }
                case 86: {
                    return "createInputConsumer";
                }
                case 87: {
                    return "destroyInputConsumer";
                }
                case 88: {
                    return "getCurrentImeTouchRegion";
                }
                case 89: {
                    return "registerDisplayFoldListener";
                }
                case 90: {
                    return "unregisterDisplayFoldListener";
                }
                case 91: {
                    return "registerDisplayWindowListener";
                }
                case 92: {
                    return "unregisterDisplayWindowListener";
                }
                case 93: {
                    return "startWindowTrace";
                }
                case 94: {
                    return "stopWindowTrace";
                }
                case 95: {
                    return "saveWindowTraceToFile";
                }
                case 96: {
                    return "isWindowTraceEnabled";
                }
                case 97: {
                    return "startTransitionTrace";
                }
                case 98: {
                    return "stopTransitionTrace";
                }
                case 99: {
                    return "isTransitionTraceEnabled";
                }
                case 100: {
                    return "getWindowingMode";
                }
                case 101: {
                    return "setWindowingMode";
                }
                case 102: {
                    return "getRemoveContentMode";
                }
                case 103: {
                    return "setRemoveContentMode";
                }
                case 104: {
                    return "shouldShowWithInsecureKeyguard";
                }
                case 105: {
                    return "setShouldShowWithInsecureKeyguard";
                }
                case 106: {
                    return "shouldShowSystemDecors";
                }
                case 107: {
                    return "setShouldShowSystemDecors";
                }
                case 108: {
                    return "isEligibleForDesktopMode";
                }
                case 109: {
                    return "getDisplayImePolicy";
                }
                case 110: {
                    return "setDisplayImePolicy";
                }
                case 111: {
                    return "onNotificationShadeExpanded";
                }
                case 112: {
                    return "syncInputTransactions";
                }
                case 113: {
                    return "isLayerTracing";
                }
                case 114: {
                    return "setLayerTracing";
                }
                case 115: {
                    return "mirrorDisplay";
                }
                case 116: {
                    return "setDisplayWindowInsetsController";
                }
                case 117: {
                    return "updateDisplayWindowRequestedVisibleTypes";
                }
                case 118: {
                    return "updateDisplayWindowAnimatingTypes";
                }
                case 119: {
                    return "getWindowInsets";
                }
                case 120: {
                    return "getPossibleDisplayInfo";
                }
                case 121: {
                    return "showGlobalActions";
                }
                case 122: {
                    return "setLayerTracingFlags";
                }
                case 123: {
                    return "setActiveTransactionTracing";
                }
                case 124: {
                    return "requestScrollCapture";
                }
                case 125: {
                    return "holdLock";
                }
                case 126: {
                    return "getSupportedDisplayHashAlgorithms";
                }
                case 127: {
                    return "verifyDisplayHash";
                }
                case 128: {
                    return "setDisplayHashThrottlingEnabled";
                }
                case 129: {
                    return "attachWindowContextToDisplayArea";
                }
                case 130: {
                    return "attachWindowContextToWindowToken";
                }
                case 131: {
                    return "attachWindowContextToDisplayContent";
                }
                case 132: {
                    return "detachWindowContext";
                }
                case 133: {
                    return "reparentWindowContextToDisplayArea";
                }
                case 134: {
                    return "registerCrossWindowBlurEnabledListener";
                }
                case 135: {
                    return "unregisterCrossWindowBlurEnabledListener";
                }
                case 136: {
                    return "isTaskSnapshotSupported";
                }
                case 137: {
                    return "getImeDisplayId";
                }
                case 138: {
                    return "setTaskSnapshotEnabled";
                }
                case 139: {
                    return "registerTaskFpsCallback";
                }
                case 140: {
                    return "unregisterTaskFpsCallback";
                }
                case 141: {
                    return "snapshotTaskForRecents";
                }
                case 142: {
                    return "setRecentsAppBehindSystemBars";
                }
                case 143: {
                    return "getLetterboxBackgroundColorInArgb";
                }
                case 144: {
                    return "isLetterboxBackgroundMultiColored";
                }
                case 145: {
                    return "captureDisplay";
                }
                case 146: {
                    return "isGlobalKey";
                }
                case 147: {
                    return "addToSurfaceSyncGroup";
                }
                case 148: {
                    return "markSurfaceSyncGroupReady";
                }
                case 149: {
                    return "notifyScreenshotListeners";
                }
                case 150: {
                    return "replaceContentOnDisplay";
                }
                case 151: {
                    return "registerDecorViewGestureListener";
                }
                case 152: {
                    return "unregisterDecorViewGestureListener";
                }
                case 153: {
                    return "registerTrustedPresentationListener";
                }
                case 154: {
                    return "unregisterTrustedPresentationListener";
                }
                case 155: {
                    return "registerScreenRecordingCallback";
                }
                case 156: {
                    return "unregisterScreenRecordingCallback";
                }
                case 157: {
                    return "setGlobalDragListener";
                }
                case 158: {
                    return "transferTouchGesture";
                }
                case 159: {
                    return "getApplicationLaunchKeyboardShortcuts";
                }
                case 160: {
                    return "getIgnoreOrientationRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.startViewServer(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    boolean _result = this.stopViewServer();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    boolean _result = this.isViewServerRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IWindowSessionCallback _arg0 = IWindowSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IWindowSession _result = this.openSession(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    data.enforceNoDataAvail();
                    this.getInitialDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    data.enforceNoDataAvail();
                    this.getBaseDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplaySize(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearForcedDisplaySize(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getInitialDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBaseDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayIdByUniqueId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayDensityForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearForcedDisplayDensityForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayDensityRatio(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    ArrayList<ConfigurationChangeSetting> _arg0 = data.createTypedArrayList(ConfigurationChangeSetting.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setConfigurationChangeSettingsForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayScalingMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEventDispatching(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWindowToken(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addWindowToken(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IDisplayChangeWindowController _arg0 = IDisplayChangeWindowController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setDisplayChangeWindowController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    IWindow _arg1 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    SurfaceControl _result = this.addShellRoot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IWindow _arg2 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setShellRootAccessibilityWindow(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IAppTransitionAnimationSpecsFuture _arg0 = IAppTransitionAnimationSpecsFuture.Stub.asInterface(data.readStrongBinder());
                    IRemoteCallback _arg1 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingAppTransitionMultiThumbFuture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    RemoteAnimationAdapter _arg0 = data.readTypedObject(RemoteAnimationAdapter.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingAppTransitionRemote(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    this.endProlongedAnimations();
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableKeyguard(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reenableKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IOnKeyguardExitResult _arg0 = IOnKeyguardExitResult.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.exitKeyguardSecurely(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    boolean _result = this.isKeyguardLocked();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isKeyguardSecure(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    IKeyguardDismissCallback _arg0 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.dismissKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IKeyguardLockedStateListener _arg0 = IKeyguardLockedStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addKeyguardLockedStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IKeyguardLockedStateListener _arg0 = IKeyguardLockedStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeKeyguardLockedStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSwitchingUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.closeSystemDialogs(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getAnimationScale(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 38: {
                    float[] _result = this.getAnimationScales();
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setAnimationScale(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setAnimationScales(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    float _result = this.getCurrentAnimatorScale();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 42: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setInTouchMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInTouchModeOnAllDisplays(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInTouchMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 45: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showStrictModeViolation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStrictModeVisualIndicatorPreference(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    this.refreshScreenCaptureDisabled();
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _result = this.getDefaultDisplayRotation();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayUserRotation(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 50: {
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.watchRotation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 51: {
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeRotationWatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    IBinder _arg0 = data.readStrongBinder();
                    IRotationWatcher _arg1 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.registerProposedRotationListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getPreferredOptionsPanelGravity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDeviceStateAutoRotateSetting(_arg0, _arg1);
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.freezeRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.thawRotation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    boolean _result = this.isRotationFrozen();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRotationAtAngleIfAllowed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.freezeDisplayRotation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.thawDisplayRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDisplayRotationFrozen(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setFixedToUserRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIgnoreOrientationRequest(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    Bitmap _result = this.screenshotWallpaper();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 65: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    SurfaceControl _result = this.mirrorWallpaperSurface(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 66: {
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 67: {
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    IAssistDataReceiver _arg0 = IAssistDataReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestAssistScreenshot(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.hideTransientBars(_arg0);
                    break;
                }
                case 72: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsVisibility(_arg0);
                    break;
                }
                case 73: {
                    int _arg0 = data.readInt();
                    Rect[] _arg1 = data.createTypedArray(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateStaticPrivacyIndicatorBounds(_arg0, _arg1);
                    break;
                }
                case 74: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavBarVirtualKeyHapticFeedbackEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNavigationBar(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 76: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.lockNow(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 77: {
                    boolean _result = this.isSafeModeEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 78: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.clearWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 79: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    WindowContentFrameStats _result = this.getWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 80: {
                    int _result = this.getDockedStackSide();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 81: {
                    int _arg0 = data.readInt();
                    IPinnedTaskListener _arg1 = IPinnedTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPinnedTaskListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 82: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestAppKeyboardShortcuts(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 83: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestImeKeyboardShortcuts(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 84: {
                    int _arg0 = data.readInt();
                    Rect _arg1 = new Rect();
                    data.enforceNoDataAvail();
                    this.getStableInsets(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 85: {
                    long _arg0 = data.readLong();
                    IShortcutService _arg1 = IShortcutService.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerShortcutKey(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 86: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    InputChannel _arg3 = new InputChannel();
                    data.enforceNoDataAvail();
                    this.createInputConsumer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 87: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.destroyInputConsumer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 88: {
                    Region _result = this.getCurrentImeTouchRegion();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 89: {
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int[] _result = this.registerDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 92: {
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 93: {
                    this.startWindowTrace();
                    reply.writeNoException();
                    break;
                }
                case 94: {
                    this.stopWindowTrace();
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    this.saveWindowTraceToFile();
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    boolean _result = this.isWindowTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 97: {
                    this.startTransitionTrace();
                    reply.writeNoException();
                    break;
                }
                case 98: {
                    this.stopTransitionTrace();
                    reply.writeNoException();
                    break;
                }
                case 99: {
                    boolean _result = this.isTransitionTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 100: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getWindowingMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 101: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWindowingMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 102: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getRemoveContentMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 103: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRemoveContentMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 104: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldShowWithInsecureKeyguard(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 105: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldShowWithInsecureKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 106: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldShowSystemDecors(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 107: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldShowSystemDecors(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 108: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isEligibleForDesktopMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 109: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayImePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 110: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisplayImePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 111: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationShadeExpanded(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 112: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.syncInputTransactions(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 113: {
                    boolean _result = this.isLayerTracing();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 114: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLayerTracing(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 115: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = new SurfaceControl();
                    data.enforceNoDataAvail();
                    boolean _result = this.mirrorDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 116: {
                    int _arg0 = data.readInt();
                    IDisplayWindowInsetsController _arg1 = IDisplayWindowInsetsController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setDisplayWindowInsetsController(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 117: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ImeTracker.Token _arg3 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateDisplayWindowRequestedVisibleTypes(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 118: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateDisplayWindowAnimatingTypes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 119: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    InsetsState _arg2 = new InsetsState();
                    data.enforceNoDataAvail();
                    this.getWindowInsets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg2, 1);
                    break;
                }
                case 120: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<DisplayInfo> _result = this.getPossibleDisplayInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 121: {
                    this.showGlobalActions();
                    reply.writeNoException();
                    break;
                }
                case 122: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setLayerTracingFlags(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 123: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setActiveTransactionTracing(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 124: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    IScrollCaptureResponseListener _arg3 = IScrollCaptureResponseListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestScrollCapture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 125: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.holdLock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 126: {
                    String[] _result = this.getSupportedDisplayHashAlgorithms();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 127: {
                    DisplayHash _arg0 = data.readTypedObject(DisplayHash.CREATOR);
                    data.enforceNoDataAvail();
                    VerifiedDisplayHash _result = this.verifyDisplayHash(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 128: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDisplayHashThrottlingEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 129: {
                    IApplicationThread _arg0 = IApplicationThread.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    WindowContextInfo _result = this.attachWindowContextToDisplayArea(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 130: {
                    IApplicationThread _arg0 = IApplicationThread.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    WindowContextInfo _result = this.attachWindowContextToWindowToken(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 131: {
                    IApplicationThread _arg0 = IApplicationThread.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    WindowContextInfo _result = this.attachWindowContextToDisplayContent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 132: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.detachWindowContext(_arg0);
                    break;
                }
                case 133: {
                    IApplicationThread _arg0 = IApplicationThread.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.reparentWindowContextToDisplayArea(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 134: {
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 135: {
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 136: {
                    boolean _result = this.isTaskSnapshotSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 137: {
                    int _result = this.getImeDisplayId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 138: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTaskSnapshotEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 139: {
                    int _arg0 = data.readInt();
                    ITaskFpsCallback _arg1 = ITaskFpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTaskFpsCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 140: {
                    ITaskFpsCallback _arg0 = ITaskFpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterTaskFpsCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 141: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Bitmap _result = this.snapshotTaskForRecents(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 142: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsAppBehindSystemBars(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 143: {
                    int _result = this.getLetterboxBackgroundColorInArgb();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 144: {
                    boolean _result = this.isLetterboxBackgroundMultiColored();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 145: {
                    int _arg0 = data.readInt();
                    ScreenCapture.CaptureArgs _arg1 = data.readTypedObject(ScreenCapture.CaptureArgs.CREATOR);
                    ScreenCapture.ScreenCaptureListener _arg2 = data.readTypedObject(ScreenCapture.ScreenCaptureListener.CREATOR);
                    data.enforceNoDataAvail();
                    this.captureDisplay(_arg0, _arg1, _arg2);
                    break;
                }
                case 146: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isGlobalKey(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 147: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    ISurfaceSyncGroupCompletedListener _arg2 = ISurfaceSyncGroupCompletedListener.Stub.asInterface(data.readStrongBinder());
                    AddToSurfaceSyncGroupResult _arg3 = new AddToSurfaceSyncGroupResult();
                    data.enforceNoDataAvail();
                    boolean _result = this.addToSurfaceSyncGroup(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 148: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.markSurfaceSyncGroupReady(_arg0);
                    break;
                }
                case 149: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<ComponentName> _result = this.notifyScreenshotListeners(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 150: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.replaceContentOnDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 151: {
                    IDecorViewGestureListener _arg0 = IDecorViewGestureListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerDecorViewGestureListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 152: {
                    IDecorViewGestureListener _arg0 = IDecorViewGestureListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterDecorViewGestureListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 153: {
                    IBinder _arg0 = data.readStrongBinder();
                    ITrustedPresentationListener _arg1 = ITrustedPresentationListener.Stub.asInterface(data.readStrongBinder());
                    TrustedPresentationThresholds _arg2 = data.readTypedObject(TrustedPresentationThresholds.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerTrustedPresentationListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 154: {
                    ITrustedPresentationListener _arg0 = ITrustedPresentationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterTrustedPresentationListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 155: {
                    IScreenRecordingCallback _arg0 = IScreenRecordingCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerScreenRecordingCallback(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 156: {
                    IScreenRecordingCallback _arg0 = IScreenRecordingCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterScreenRecordingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 157: {
                    IGlobalDragListener _arg0 = IGlobalDragListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setGlobalDragListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 158: {
                    InputTransferToken _arg0 = data.readTypedObject(InputTransferToken.CREATOR);
                    InputTransferToken _arg1 = data.readTypedObject(InputTransferToken.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.transferTouchGesture(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 159: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    KeyboardShortcutGroup _result = this.getApplicationLaunchKeyboardShortcuts(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 160: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.getIgnoreOrientationRequest(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setForcedDisplaySize_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearForcedDisplaySize_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setForcedDisplayDensityForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearForcedDisplayDensityForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setForcedDisplayDensityRatio_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setConfigurationChangeSettingsForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setForcedDisplayScalingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addShellRoot_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_APP_TOKENS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setShellRootAccessibilityWindow_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_APP_TOKENS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void exitKeyguardSecurely_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DISABLE_KEYGUARD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNavBarVirtualKeyHapticFeedbackEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.STATUS_BAR", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getCurrentImeTouchRegion_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.RESTRICTED_VR_ACCESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDisplayWindowInsetsController_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_APP_TOKENS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void updateDisplayWindowRequestedVisibleTypes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_APP_TOKENS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void updateDisplayWindowAnimatingTypes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_APP_TOKENS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerScreenRecordingCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DETECT_SCREEN_RECORDING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterScreenRecordingCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DETECT_SCREEN_RECORDING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 159;
        }

        private static class Proxy
        implements IWindowManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startViewServer(int port) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(port);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopViewServer() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isViewServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
                IWindowSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = IWindowSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplaySize(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInitialDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBaseDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayIdByUniqueId(String uniqueId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(density);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayDensityRatio(int displayId, float ratio, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(ratio);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConfigurationChangeSettingsForUser(List<ConfigurationChangeSetting> settings, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(settings, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEventDispatching(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowToken(IBinder binder) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayChangeWindowController(IDisplayChangeWindowController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(client);
                    _data.writeInt(shellRootLayer);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shellRootLayer);
                    _data.writeStrongInterface(target);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(specsFuture);
                    _data.writeStrongInterface(startedCallback);
                    _data.writeBoolean(scaleUp);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(remoteAnimationAdapter, 0);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endProlongedAnimations() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(tag);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardLocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardSecure(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSwitchingUser(boolean switching) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(switching);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getAnimationScale(int which) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getAnimationScales() throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScale(int which, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScales(float[] scales) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(scales);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCurrentAnimatorScale() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchMode(boolean inTouch, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inTouch);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchModeOnAllDisplays(boolean inTouch) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inTouch);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInTouchMode(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showStrictModeViolation(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(enabled);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshScreenCaptureDisabled() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultDisplayRotation() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayUserRotation(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(watcher);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(watcher);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerProposedRotationListener(IBinder contextToken, IRotationWatcher listener) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(contextToken);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceStateAutoRotateSetting(int deviceState, boolean autoRotate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceState);
                    _data.writeBoolean(autoRotate);
                    boolean bl = this.mRemote.transact(54, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeRotation(int rotation, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawRotation(String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRotationFrozen() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRotationAtAngleIfAllowed(int rotation, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeDisplayRotation(int displayId, int rotation, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(rotation);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawDisplayRotation(int displayId, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(fixedToUserRotation);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(ignoreOrientationRequest);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap screenshotWallpaper() throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl mirrorWallpaperSurface(int displayId) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideTransientBars(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(71, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(72, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedArray(staticBounds, 0);
                    boolean bl = this.mRemote.transact(73, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNavigationBar(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockNow(Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSafeModeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
                WindowContentFrameStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContentFrameStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDockedStackSide() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestImeKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInsets.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(shortcutCode);
                    _data.writeStrongInterface(keySubscriber);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        inputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean destroyInputConsumer(IBinder token, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Region getCurrentImeTouchRegion() throws RemoteException {
                Region _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Region.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void saveWindowTraceToFile() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTransitionTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTransitionTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTransitionTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWindowingMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoveContentMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(shouldShow);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(shouldShow);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEligibleForDesktopMode(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayImePolicy(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(imePolicy);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationShadeExpanded(IBinder token, boolean expanded) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(expanded);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(waitForAnimations);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLayerTracing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracing(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(displayWindowInsetsController);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDisplayWindowRequestedVisibleTypes(int displayId, int visibleTypes, int mask, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(visibleTypes);
                    _data.writeInt(mask);
                    _data.writeTypedObject(statsToken, 0);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDisplayWindowAnimatingTypes(int displayId, int animatingTypes, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(animatingTypes);
                    _data.writeTypedObject(statsToken, 0);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getWindowInsets(int displayId, IBinder token, InsetsState outInsetsState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInsetsState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<DisplayInfo> getPossibleDisplayInfo(int displayId) throws RemoteException {
                ArrayList<DisplayInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(DisplayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showGlobalActions() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracingFlags(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveTransactionTracing(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(behindClient);
                    _data.writeInt(taskId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void holdLock(IBinder token, int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(durationMs);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
                VerifiedDisplayHash _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(displayHash, 0);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifiedDisplayHash.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContextInfo attachWindowContextToDisplayArea(IApplicationThread appThread, IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
                WindowContextInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(appThread);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContextInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContextInfo attachWindowContextToWindowToken(IApplicationThread appThread, IBinder clientToken, IBinder token) throws RemoteException {
                WindowContextInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(appThread);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContextInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContextInfo attachWindowContextToDisplayContent(IApplicationThread appThread, IBinder clientToken, int displayId) throws RemoteException {
                WindowContextInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(appThread);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContextInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachWindowContext(IBinder clientToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    boolean bl = this.mRemote.transact(132, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reparentWindowContextToDisplayArea(IApplicationThread appThread, IBinder clientToken, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(appThread);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTaskSnapshotSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getImeDisplayId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskSnapshotEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTaskFpsCallback(int taskId, ITaskFpsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTaskFpsCallback(ITaskFpsCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap snapshotTaskForRecents(int taskId) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsAppBehindSystemBars(boolean behindSystemBars) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(behindSystemBars);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLetterboxBackgroundColorInArgb() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(143, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLetterboxBackgroundMultiColored() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void captureDisplay(int displayId, ScreenCapture.CaptureArgs captureArgs, ScreenCapture.ScreenCaptureListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(captureArgs, 0);
                    _data.writeTypedObject(listener, 0);
                    boolean bl = this.mRemote.transact(145, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isGlobalKey(int keyCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(keyCode);
                    boolean _status = this.mRemote.transact(146, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addToSurfaceSyncGroup(IBinder syncGroupToken, boolean parentSyncGroupMerge, ISurfaceSyncGroupCompletedListener completedListener, AddToSurfaceSyncGroupResult addToSurfaceSyncGroupResult) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(syncGroupToken);
                    _data.writeBoolean(parentSyncGroupMerge);
                    _data.writeStrongInterface(completedListener);
                    boolean _status = this.mRemote.transact(147, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        addToSurfaceSyncGroupResult.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markSurfaceSyncGroupReady(IBinder syncGroupToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(syncGroupToken);
                    boolean bl = this.mRemote.transact(148, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ComponentName> notifyScreenshotListeners(int displayId) throws RemoteException {
                ArrayList<ComponentName> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(149, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean replaceContentOnDisplay(int displayId, SurfaceControl sc) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(sc, 0);
                    boolean _status = this.mRemote.transact(150, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDecorViewGestureListener(IDecorViewGestureListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDecorViewGestureListener(IDecorViewGestureListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(152, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTrustedPresentationListener(IBinder window, ITrustedPresentationListener listener, TrustedPresentationThresholds thresholds, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(thresholds, 0);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTrustedPresentationListener(ITrustedPresentationListener listener, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerScreenRecordingCallback(IScreenRecordingCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScreenRecordingCallback(IScreenRecordingCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGlobalDragListener(IGlobalDragListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(157, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean transferTouchGesture(InputTransferToken transferFromToken, InputTransferToken transferToToken) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(transferFromToken, 0);
                    _data.writeTypedObject(transferToToken, 0);
                    boolean _status = this.mRemote.transact(158, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardShortcutGroup getApplicationLaunchKeyboardShortcuts(int deviceId) throws RemoteException {
                KeyboardShortcutGroup _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(159, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyboardShortcutGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getIgnoreOrientationRequest(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(160, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWindowManager {
        @Override
        public boolean startViewServer(int port) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopViewServer() throws RemoteException {
            return false;
        }

        @Override
        public boolean isViewServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
        }

        @Override
        public void clearForcedDisplaySize(int displayId) throws RemoteException {
        }

        @Override
        public int getInitialDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getBaseDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getDisplayIdByUniqueId(String uniqueId) throws RemoteException {
            return 0;
        }

        @Override
        public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
        }

        @Override
        public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
        }

        @Override
        public void setForcedDisplayDensityRatio(int displayId, float ratio, int userId) throws RemoteException {
        }

        @Override
        public void setConfigurationChangeSettingsForUser(List<ConfigurationChangeSetting> settings, int userId) throws RemoteException {
        }

        @Override
        public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public void setEventDispatching(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isWindowToken(IBinder binder) throws RemoteException {
            return false;
        }

        @Override
        public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
        }

        @Override
        public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
        }

        @Override
        public void setDisplayChangeWindowController(IDisplayChangeWindowController controller) throws RemoteException {
        }

        @Override
        public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
            return null;
        }

        @Override
        public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
        }

        @Override
        public void endProlongedAnimations() throws RemoteException {
        }

        @Override
        public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
        }

        @Override
        public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
        }

        @Override
        public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
        }

        @Override
        public boolean isKeyguardLocked() throws RemoteException {
            return false;
        }

        @Override
        public boolean isKeyguardSecure(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void addKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
        }

        @Override
        public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
        }

        @Override
        public void setSwitchingUser(boolean switching) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(String reason) throws RemoteException {
        }

        @Override
        public float getAnimationScale(int which) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float[] getAnimationScales() throws RemoteException {
            return null;
        }

        @Override
        public void setAnimationScale(int which, float scale) throws RemoteException {
        }

        @Override
        public void setAnimationScales(float[] scales) throws RemoteException {
        }

        @Override
        public float getCurrentAnimatorScale() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setInTouchMode(boolean inTouch, int displayId) throws RemoteException {
        }

        @Override
        public void setInTouchModeOnAllDisplays(boolean inTouch) throws RemoteException {
        }

        @Override
        public boolean isInTouchMode(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void showStrictModeViolation(boolean on) throws RemoteException {
        }

        @Override
        public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
        }

        @Override
        public void refreshScreenCaptureDisabled() throws RemoteException {
        }

        @Override
        public int getDefaultDisplayRotation() throws RemoteException {
            return 0;
        }

        @Override
        public int getDisplayUserRotation(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
        }

        @Override
        public int registerProposedRotationListener(IBinder contextToken, IRotationWatcher listener) throws RemoteException {
            return 0;
        }

        @Override
        public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setDeviceStateAutoRotateSetting(int deviceState, boolean autoRotate) throws RemoteException {
        }

        @Override
        public void freezeRotation(int rotation, String caller) throws RemoteException {
        }

        @Override
        public void thawRotation(String caller) throws RemoteException {
        }

        @Override
        public boolean isRotationFrozen() throws RemoteException {
            return false;
        }

        @Override
        public void setRotationAtAngleIfAllowed(int rotation, String caller) throws RemoteException {
        }

        @Override
        public void freezeDisplayRotation(int displayId, int rotation, String caller) throws RemoteException {
        }

        @Override
        public void thawDisplayRotation(int displayId, String caller) throws RemoteException {
        }

        @Override
        public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
        }

        @Override
        public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
        }

        @Override
        public Bitmap screenshotWallpaper() throws RemoteException {
            return null;
        }

        @Override
        public SurfaceControl mirrorWallpaperSurface(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
        }

        @Override
        public void hideTransientBars(int displayId) throws RemoteException {
        }

        @Override
        public void setRecentsVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
        }

        @Override
        public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean hasNavigationBar(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void lockNow(Bundle options) throws RemoteException {
        }

        @Override
        public boolean isSafeModeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public int getDockedStackSide() throws RemoteException {
            return 0;
        }

        @Override
        public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void requestImeKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
        }

        @Override
        public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
        }

        @Override
        public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
        }

        @Override
        public boolean destroyInputConsumer(IBinder token, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public Region getCurrentImeTouchRegion() throws RemoteException {
            return null;
        }

        @Override
        public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public int[] registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
        }

        @Override
        public void startWindowTrace() throws RemoteException {
        }

        @Override
        public void stopWindowTrace() throws RemoteException {
        }

        @Override
        public void saveWindowTraceToFile() throws RemoteException {
        }

        @Override
        public boolean isWindowTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void startTransitionTrace() throws RemoteException {
        }

        @Override
        public void stopTransitionTrace() throws RemoteException {
        }

        @Override
        public boolean isTransitionTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public int getWindowingMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setWindowingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public int getRemoveContentMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public boolean isEligibleForDesktopMode(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public int getDisplayImePolicy(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
        }

        @Override
        public void onNotificationShadeExpanded(IBinder token, boolean expanded) throws RemoteException {
        }

        @Override
        public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
        }

        @Override
        public boolean isLayerTracing() throws RemoteException {
            return false;
        }

        @Override
        public void setLayerTracing(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
            return false;
        }

        @Override
        public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
        }

        @Override
        public void updateDisplayWindowRequestedVisibleTypes(int displayId, int visibleTypes, int mask, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void updateDisplayWindowAnimatingTypes(int displayId, int animatingTypes, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void getWindowInsets(int displayId, IBinder token, InsetsState outInsetsState) throws RemoteException {
        }

        @Override
        public List<DisplayInfo> getPossibleDisplayInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void showGlobalActions() throws RemoteException {
        }

        @Override
        public void setLayerTracingFlags(int flags) throws RemoteException {
        }

        @Override
        public void setActiveTransactionTracing(boolean active) throws RemoteException {
        }

        @Override
        public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
        }

        @Override
        public void holdLock(IBinder token, int durationMs) throws RemoteException {
        }

        @Override
        public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
            return null;
        }

        @Override
        public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
            return null;
        }

        @Override
        public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public WindowContextInfo attachWindowContextToDisplayArea(IApplicationThread appThread, IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
            return null;
        }

        @Override
        public WindowContextInfo attachWindowContextToWindowToken(IApplicationThread appThread, IBinder clientToken, IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public WindowContextInfo attachWindowContextToDisplayContent(IApplicationThread appThread, IBinder clientToken, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void detachWindowContext(IBinder clientToken) throws RemoteException {
        }

        @Override
        public boolean reparentWindowContextToDisplayArea(IApplicationThread appThread, IBinder clientToken, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
        }

        @Override
        public boolean isTaskSnapshotSupported() throws RemoteException {
            return false;
        }

        @Override
        public int getImeDisplayId() throws RemoteException {
            return 0;
        }

        @Override
        public void setTaskSnapshotEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void registerTaskFpsCallback(int taskId, ITaskFpsCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterTaskFpsCallback(ITaskFpsCallback listener) throws RemoteException {
        }

        @Override
        public Bitmap snapshotTaskForRecents(int taskId) throws RemoteException {
            return null;
        }

        @Override
        public void setRecentsAppBehindSystemBars(boolean behindSystemBars) throws RemoteException {
        }

        @Override
        public int getLetterboxBackgroundColorInArgb() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isLetterboxBackgroundMultiColored() throws RemoteException {
            return false;
        }

        @Override
        public void captureDisplay(int displayId, ScreenCapture.CaptureArgs captureArgs, ScreenCapture.ScreenCaptureListener listener) throws RemoteException {
        }

        @Override
        public boolean isGlobalKey(int keyCode) throws RemoteException {
            return false;
        }

        @Override
        public boolean addToSurfaceSyncGroup(IBinder syncGroupToken, boolean parentSyncGroupMerge, ISurfaceSyncGroupCompletedListener completedListener, AddToSurfaceSyncGroupResult addToSurfaceSyncGroupResult) throws RemoteException {
            return false;
        }

        @Override
        public void markSurfaceSyncGroupReady(IBinder syncGroupToken) throws RemoteException {
        }

        @Override
        public List<ComponentName> notifyScreenshotListeners(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public boolean replaceContentOnDisplay(int displayId, SurfaceControl sc) throws RemoteException {
            return false;
        }

        @Override
        public void registerDecorViewGestureListener(IDecorViewGestureListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void unregisterDecorViewGestureListener(IDecorViewGestureListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void registerTrustedPresentationListener(IBinder window, ITrustedPresentationListener listener, TrustedPresentationThresholds thresholds, int id2) throws RemoteException {
        }

        @Override
        public void unregisterTrustedPresentationListener(ITrustedPresentationListener listener, int id2) throws RemoteException {
        }

        @Override
        public boolean registerScreenRecordingCallback(IScreenRecordingCallback callback) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterScreenRecordingCallback(IScreenRecordingCallback callback) throws RemoteException {
        }

        @Override
        public void setGlobalDragListener(IGlobalDragListener listener) throws RemoteException {
        }

        @Override
        public boolean transferTouchGesture(InputTransferToken transferFromToken, InputTransferToken transferToToken) throws RemoteException {
            return false;
        }

        @Override
        public KeyboardShortcutGroup getApplicationLaunchKeyboardShortcuts(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean getIgnoreOrientationRequest(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

