/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.Nullable;
import android.graphics.Insets;
import android.graphics.Rect;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InternalInsetsAnimationController;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.animation.Interpolator;
import android.view.inputmethod.ImeTracker;

public class InsetsResizeAnimationRunner
implements InsetsAnimationControlRunner,
InternalInsetsAnimationController,
WindowInsetsAnimationControlListener {
    private final InsetsState mFromState;
    private final InsetsState mToState;
    private final int mTypes;
    private final WindowInsetsAnimation mAnimation;
    private final InsetsAnimationControlCallbacks mController;
    private ValueAnimator mAnimator;
    private boolean mCancelled;
    private boolean mFinished;

    public InsetsResizeAnimationRunner(Rect frame, Rect hostBounds, InsetsState fromState, InsetsState toState, Interpolator interpolator2, long duration, int types, InsetsAnimationControlCallbacks controller) {
        this.mFromState = fromState;
        this.mToState = toState;
        this.mTypes = types;
        this.mController = controller;
        this.mAnimation = new WindowInsetsAnimation(types, interpolator2, duration);
        this.mAnimation.setAlpha(1.0f);
        Insets fromInsets = fromState.calculateInsets(frame, hostBounds, types, false);
        Insets toInsets = toState.calculateInsets(frame, hostBounds, types, false);
        controller.startAnimation(this, this, types, this.mAnimation, new WindowInsetsAnimation.Bounds(Insets.min(fromInsets, toInsets), Insets.max(fromInsets, toInsets)));
    }

    @Override
    public int getTypes() {
        return this.mTypes;
    }

    @Override
    public int getControllingTypes() {
        return this.mTypes;
    }

    @Override
    public WindowInsetsAnimation getAnimation() {
        return this.mAnimation;
    }

    @Override
    public int getAnimationType() {
        return 3;
    }

    @Override
    public InsetsAnimationControlRunner.SurfaceParamsApplier getSurfaceParamsApplier() {
        return InsetsAnimationControlRunner.SurfaceParamsApplier.DEFAULT;
    }

    @Override
    @Nullable
    public ImeTracker.Token getStatsToken() {
        return null;
    }

    @Override
    public void cancel() {
        if (this.mCancelled || this.mFinished) {
            return;
        }
        this.mCancelled = true;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public void onReady(WindowInsetsAnimationController controller, int types) {
        if (this.mCancelled) {
            return;
        }
        this.mAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        this.mAnimator.setDuration(this.mAnimation.getDurationMillis());
        this.mAnimator.addUpdateListener(animation -> {
            this.mAnimation.setFraction(animation.getAnimatedFraction());
            this.mController.scheduleApplyChangeInsets(this);
        });
        this.mAnimator.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                InsetsResizeAnimationRunner.this.mFinished = true;
                InsetsResizeAnimationRunner.this.mController.scheduleApplyChangeInsets(InsetsResizeAnimationRunner.this);
            }
        });
        this.mAnimator.start();
    }

    @Override
    public boolean applyChangeInsets(final InsetsState outState) {
        if (this.mCancelled) {
            return false;
        }
        final float fraction2 = this.mAnimation.getInterpolatedFraction();
        InsetsState.traverse(this.mFromState, this.mToState, new InsetsState.OnTraverseCallbacks(){

            @Override
            public void onIdMatch(InsetsSource fromSource, InsetsSource toSource) {
                Rect fromFrame = fromSource.getFrame();
                Rect toFrame = toSource.getFrame();
                Rect frame = new Rect((int)((float)fromFrame.left + fraction2 * (float)(toFrame.left - fromFrame.left)), (int)((float)fromFrame.top + fraction2 * (float)(toFrame.top - fromFrame.top)), (int)((float)fromFrame.right + fraction2 * (float)(toFrame.right - fromFrame.right)), (int)((float)fromFrame.bottom + fraction2 * (float)(toFrame.bottom - fromFrame.bottom)));
                InsetsSource source = new InsetsSource(fromSource.getId(), fromSource.getType());
                source.setFrame(frame);
                source.setVisible(toSource.isVisible());
                outState.addSource(source);
            }
        });
        if (this.mFinished) {
            this.mController.notifyFinished(this, true);
        }
        return this.mFinished;
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mCancelled);
        proto.write(1133871366146L, this.mFinished);
        proto.write(1138166333443L, "null");
        proto.write(1138166333444L, "null");
        proto.write(1108101562373L, this.mAnimation.getInterpolatedFraction());
        proto.write(1133871366150L, true);
        proto.write(1108101562375L, 1.0f);
        proto.write(1108101562376L, 1.0f);
        proto.end(token);
    }

    @Override
    public Insets getHiddenStateInsets() {
        return Insets.NONE;
    }

    @Override
    public Insets getShownStateInsets() {
        return Insets.NONE;
    }

    @Override
    public Insets getCurrentInsets() {
        return Insets.NONE;
    }

    @Override
    public float getCurrentFraction() {
        return 0.0f;
    }

    @Override
    public float getCurrentAlpha() {
        return 0.0f;
    }

    @Override
    public void setInsetsAndAlpha(Insets insets, float alpha, float fraction2) {
    }

    @Override
    public void finish(boolean shown) {
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void notifyControlRevoked(int types) {
    }

    @Override
    public void updateSurfacePosition(SparseArray<InsetsSourceControl> controls) {
    }

    @Override
    public boolean willUpdateSurface() {
        return false;
    }

    @Override
    public boolean hasZeroInsetsIme() {
        return false;
    }

    @Override
    public long getDurationMs() {
        return 0L;
    }

    @Override
    public Interpolator getInsetsInterpolator() {
        return null;
    }

    @Override
    public void setReadyDispatched(boolean dispatched) {
    }

    @Override
    public void onFinished(WindowInsetsAnimationController controller) {
    }

    @Override
    public void onCancelled(WindowInsetsAnimationController controller) {
    }

    @Override
    public void updateLayoutInsetsDuringAnimation(int layoutInsetsDuringAnimation) {
    }
}

