/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.gui.EarlyWakeupInfo;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.internal.annotations.VisibleForTesting;
import java.util.function.Consumer;

public class SyncRtSurfaceTransactionApplier {
    public static final int FLAG_ALL = -1;
    public static final int FLAG_ALPHA = 1;
    public static final int FLAG_MATRIX = 2;
    public static final int FLAG_WINDOW_CROP = 4;
    public static final int FLAG_LAYER = 8;
    public static final int FLAG_CORNER_RADIUS = 16;
    public static final int FLAG_BACKGROUND_BLUR_RADIUS = 32;
    public static final int FLAG_BACKGROUND_BLUR_SCALE = 64;
    public static final int FLAG_VISIBILITY = 128;
    public static final int FLAG_TRANSACTION = 256;
    public static final int FLAG_EARLY_WAKEUP_START = 512;
    public static final int FLAG_EARLY_WAKEUP_END = 1024;
    public static final int FLAG_OPAQUE = 2048;
    private SurfaceControl mTargetSc;
    private final ViewRootImpl mTargetViewRootImpl;
    private final float[] mTmpFloat9 = new float[9];

    public SyncRtSurfaceTransactionApplier(View targetView) {
        this.mTargetViewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
    }

    public void scheduleApply(SurfaceParams ... params) {
        if (this.mTargetViewRootImpl == null) {
            return;
        }
        this.mTargetSc = this.mTargetViewRootImpl.getSurfaceControl();
        SurfaceControl.Transaction t = new SurfaceControl.Transaction();
        this.applyParams(t, params);
        this.mTargetViewRootImpl.registerRtFrameCallback(frame -> {
            if (this.mTargetSc != null && this.mTargetSc.isValid()) {
                this.applyTransaction(t, frame);
            }
            t.close();
        });
        this.mTargetViewRootImpl.getView().invalidate();
    }

    void applyParams(SurfaceControl.Transaction t, SurfaceParams ... params) {
        for (int i = params.length - 1; i >= 0; --i) {
            SurfaceParams surfaceParams = params[i];
            SurfaceControl surface = surfaceParams.surface;
            SyncRtSurfaceTransactionApplier.applyParams(t, surfaceParams, this.mTmpFloat9);
        }
    }

    void applyTransaction(SurfaceControl.Transaction t, long frame) {
        if (this.mTargetViewRootImpl != null) {
            this.mTargetViewRootImpl.mergeWithNextTransaction(t, frame);
        } else {
            t.apply();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static void applyParams(SurfaceControl.Transaction t, SurfaceParams params, float[] tmpFloat9) {
        if ((params.flags & 0x100) != 0) {
            t.merge(params.mergeTransaction);
        }
        if ((params.flags & 2) != 0) {
            t.setMatrix(params.surface, params.matrix, tmpFloat9);
        }
        if ((params.flags & 4) != 0) {
            t.setWindowCrop(params.surface, params.windowCrop);
        }
        if ((params.flags & 1) != 0) {
            t.setAlpha(params.surface, params.alpha);
        }
        if ((params.flags & 8) != 0) {
            t.setLayer(params.surface, params.layer);
        }
        if ((params.flags & 0x10) != 0) {
            t.setCornerRadius(params.surface, params.cornerRadius);
        }
        if ((params.flags & 0x20) != 0) {
            t.setBackgroundBlurRadius(params.surface, params.backgroundBlurRadius);
        }
        if ((params.flags & 0x40) != 0) {
            t.setBackgroundBlurScale(params.surface, params.backgroundBlurScale);
        }
        if ((params.flags & 0x80) != 0) {
            if (params.visible) {
                t.show(params.surface);
            } else {
                t.hide(params.surface);
            }
        }
        if ((params.flags & 0x200) != 0) {
            t.setEarlyWakeupStart(params.earlyWakeupInfo);
        }
        if ((params.flags & 0x400) != 0) {
            t.setEarlyWakeupEnd(params.earlyWakeupInfo);
        }
        if ((params.flags & 0x800) != 0) {
            t.setOpaque(params.surface, params.opaque);
        }
    }

    public static void create(final View targetView, final Consumer<SyncRtSurfaceTransactionApplier> callback) {
        if (targetView == null) {
            callback.accept(null);
        } else if (targetView.getViewRootImpl() != null) {
            callback.accept(new SyncRtSurfaceTransactionApplier(targetView));
        } else {
            targetView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                @Override
                public void onViewAttachedToWindow(View v) {
                    targetView.removeOnAttachStateChangeListener(this);
                    callback.accept(new SyncRtSurfaceTransactionApplier(targetView));
                }

                @Override
                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    public static class SurfaceParams {
        private final int flags;
        @VisibleForTesting
        public final SurfaceControl surface;
        @VisibleForTesting
        public final float alpha;
        @VisibleForTesting
        public final float cornerRadius;
        @VisibleForTesting
        public final int backgroundBlurRadius;
        @VisibleForTesting
        public final float backgroundBlurScale;
        @VisibleForTesting
        public final Matrix matrix;
        @VisibleForTesting
        public final Rect windowCrop;
        @VisibleForTesting
        public final int layer;
        public final boolean visible;
        public final SurfaceControl.Transaction mergeTransaction;
        public final boolean opaque;
        public final EarlyWakeupInfo earlyWakeupInfo;

        private SurfaceParams(SurfaceControl surface, int params, float alpha, Matrix matrix, Rect windowCrop, int layer, float cornerRadius, int backgroundBlurRadius, float backgroundBlurScale, boolean visible, SurfaceControl.Transaction mergeTransaction, boolean opaque, EarlyWakeupInfo earlyWakeupInfo) {
            this.flags = params;
            this.surface = surface;
            this.alpha = alpha;
            this.matrix = matrix;
            this.windowCrop = windowCrop;
            this.layer = layer;
            this.cornerRadius = cornerRadius;
            this.backgroundBlurRadius = backgroundBlurRadius;
            this.backgroundBlurScale = backgroundBlurScale;
            this.visible = visible;
            this.mergeTransaction = mergeTransaction;
            this.opaque = opaque;
            this.earlyWakeupInfo = earlyWakeupInfo;
        }

        public static class Builder {
            final SurfaceControl surface;
            int flags;
            float alpha;
            float cornerRadius;
            int backgroundBlurRadius;
            float backgroundBlurScale;
            Matrix matrix;
            Rect windowCrop;
            int layer;
            boolean visible;
            boolean opaque;
            SurfaceControl.Transaction mergeTransaction;
            EarlyWakeupInfo earlyWakeupInfo;

            public Builder(SurfaceControl surface) {
                this.surface = surface;
            }

            public Builder withAlpha(float alpha) {
                this.alpha = alpha;
                this.flags |= 1;
                return this;
            }

            public Builder withMatrix(Matrix matrix) {
                this.matrix = new Matrix(matrix);
                this.flags |= 2;
                return this;
            }

            public Builder withWindowCrop(Rect windowCrop) {
                this.windowCrop = new Rect(windowCrop);
                this.flags |= 4;
                return this;
            }

            public Builder withLayer(int layer) {
                this.layer = layer;
                this.flags |= 8;
                return this;
            }

            public Builder withCornerRadius(float radius) {
                this.cornerRadius = radius;
                this.flags |= 0x10;
                return this;
            }

            public Builder withBackgroundBlurRadius(int radius) {
                this.backgroundBlurRadius = radius;
                this.flags |= 0x20;
                return this;
            }

            public Builder withBackgroundBlurScale(float scale) {
                this.backgroundBlurScale = scale;
                this.flags |= 0x40;
                return this;
            }

            public Builder withVisibility(boolean visible) {
                this.visible = visible;
                this.flags |= 0x80;
                return this;
            }

            public Builder withMergeTransaction(SurfaceControl.Transaction mergeTransaction) {
                this.mergeTransaction = mergeTransaction;
                this.flags |= 0x100;
                return this;
            }

            public Builder withEarlyWakeupStart(EarlyWakeupInfo earlyWakeupInfo) {
                this.earlyWakeupInfo = earlyWakeupInfo;
                this.flags |= 0x200;
                return this;
            }

            public Builder withEarlyWakeupEnd(EarlyWakeupInfo earlyWakeupInfo) {
                this.earlyWakeupInfo = earlyWakeupInfo;
                this.flags |= 0x400;
                return this;
            }

            public Builder withOpaque(boolean opaque) {
                this.opaque = opaque;
                this.flags |= 0x800;
                return this;
            }

            public SurfaceParams build() {
                return new SurfaceParams(this.surface, this.flags, this.alpha, this.matrix, this.windowCrop, this.layer, this.cornerRadius, this.backgroundBlurRadius, this.backgroundBlurScale, this.visible, this.mergeTransaction, this.opaque, this.earlyWakeupInfo);
            }
        }
    }
}

