/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.concurrent.Executor;

public abstract class TunnelModeEnabledListener {
    private long mNativeListener;
    private final Executor mExecutor;

    public TunnelModeEnabledListener(Executor executor) {
        this.mExecutor = executor;
        this.mNativeListener = TunnelModeEnabledListener.nativeCreate(this);
    }

    public void destroy() {
        if (this.mNativeListener == 0L) {
            return;
        }
        TunnelModeEnabledListener.unregister(this);
        TunnelModeEnabledListener.nativeDestroy(this.mNativeListener);
        this.mNativeListener = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onTunnelModeEnabledChanged(boolean var1);

    public static void register(TunnelModeEnabledListener listener) {
        if (listener.mNativeListener == 0L) {
            return;
        }
        TunnelModeEnabledListener.nativeRegister(listener.mNativeListener);
    }

    public static void unregister(TunnelModeEnabledListener listener) {
        if (listener.mNativeListener == 0L) {
            return;
        }
        TunnelModeEnabledListener.nativeUnregister(listener.mNativeListener);
    }

    @VisibleForTesting
    public static void dispatchOnTunnelModeEnabledChanged(TunnelModeEnabledListener listener, boolean tunnelModeEnabled) {
        listener.mExecutor.execute(() -> listener.onTunnelModeEnabledChanged(tunnelModeEnabled));
    }

    private static long nativeCreate(TunnelModeEnabledListener tunnelModeEnabledListener) {
        return OverrideMethod.invokeL("android.view.TunnelModeEnabledListener#nativeCreate(Landroid/view/TunnelModeEnabledListener;)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.TunnelModeEnabledListener#nativeDestroy(J)V", true, null);
    }

    private static void nativeRegister(long l) {
        OverrideMethod.invokeV("android.view.TunnelModeEnabledListener#nativeRegister(J)V", true, null);
    }

    private static void nativeUnregister(long l) {
        OverrideMethod.invokeV("android.view.TunnelModeEnabledListener#nativeUnregister(J)V", true, null);
    }
}

