/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Insets;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.session.MediaController;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.util.Pair;
import android.view.ActionMode;
import android.view.AttachedSurfaceControl;
import android.view.FrameMetrics;
import android.view.IScrollCaptureResponseListener;
import android.view.InputEvent;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.ScrollCaptureCallback;
import android.view.SearchEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.window.OnBackInvokedDispatcher;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.view.flags.Flags;
import java.util.Collections;
import java.util.List;

public abstract class Window {
    public static final int FEATURE_OPTIONS_PANEL = 0;
    public static final int FEATURE_NO_TITLE = 1;
    @Deprecated
    public static final int FEATURE_PROGRESS = 2;
    public static final int FEATURE_LEFT_ICON = 3;
    public static final int FEATURE_RIGHT_ICON = 4;
    @Deprecated
    public static final int FEATURE_INDETERMINATE_PROGRESS = 5;
    public static final int FEATURE_CONTEXT_MENU = 6;
    public static final int FEATURE_CUSTOM_TITLE = 7;
    public static final int FEATURE_ACTION_BAR = 8;
    public static final int FEATURE_ACTION_BAR_OVERLAY = 9;
    public static final int FEATURE_ACTION_MODE_OVERLAY = 10;
    @Deprecated
    public static final int FEATURE_SWIPE_TO_DISMISS = 11;
    public static final int FEATURE_CONTENT_TRANSITIONS = 12;
    public static final int FEATURE_ACTIVITY_TRANSITIONS = 13;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int FEATURE_MAX = 13;
    @Deprecated
    public static final int PROGRESS_VISIBILITY_ON = -1;
    @Deprecated
    public static final int PROGRESS_VISIBILITY_OFF = -2;
    @Deprecated
    public static final int PROGRESS_INDETERMINATE_ON = -3;
    @Deprecated
    public static final int PROGRESS_INDETERMINATE_OFF = -4;
    @Deprecated
    public static final int PROGRESS_START = 0;
    @Deprecated
    public static final int PROGRESS_END = 10000;
    @Deprecated
    public static final int PROGRESS_SECONDARY_START = 20000;
    @Deprecated
    public static final int PROGRESS_SECONDARY_END = 30000;
    public static final String STATUS_BAR_BACKGROUND_TRANSITION_NAME = "android:status:background";
    public static final String NAVIGATION_BAR_BACKGROUND_TRANSITION_NAME = "android:navigation:background";
    @Deprecated
    protected static final int DEFAULT_FEATURES = 65;
    public static final int ID_ANDROID_CONTENT = 0x1020002;
    public static final int DECOR_CAPTION_SHADE_AUTO = 0;
    public static final int DECOR_CAPTION_SHADE_LIGHT = 1;
    public static final int DECOR_CAPTION_SHADE_DARK = 2;
    @UnsupportedAppUsage
    private final Context mContext;
    @UnsupportedAppUsage
    private TypedArray mWindowStyle;
    @UnsupportedAppUsage
    private Callback mCallback;
    private OnWindowDismissedCallback mOnWindowDismissedCallback;
    private OnWindowSwipeDismissedCallback mOnWindowSwipeDismissedCallback;
    private WindowControllerCallback mWindowControllerCallback;
    private int mSystemBarAppearance;
    private DecorCallback mDecorCallback;
    private OnRestrictedCaptionAreaChangedListener mOnRestrictedCaptionAreaChangedListener;
    private Rect mRestrictedCaptionAreaRect;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private WindowManager mWindowManager;
    @UnsupportedAppUsage
    private IBinder mAppToken;
    @UnsupportedAppUsage
    private String mAppName;
    @UnsupportedAppUsage
    private boolean mHardwareAccelerated;
    private Window mContainer;
    private Window mActiveChild;
    private boolean mIsActive = false;
    private boolean mHasChildren = false;
    private boolean mCloseOnTouchOutside = false;
    private boolean mSetCloseOnTouchOutside = false;
    private int mForcedWindowFlags = 0;
    @UnsupportedAppUsage
    private int mFeatures;
    @UnsupportedAppUsage
    private int mLocalFeatures;
    private boolean mHaveWindowFormat = false;
    private boolean mHaveDimAmount = false;
    private int mDefaultWindowFormat = -1;
    private boolean mHasSoftInputMode = false;
    @UnsupportedAppUsage
    private boolean mDestroyed;
    private boolean mOverlayWithDecorCaptionEnabled = true;
    private boolean mCloseOnSwipeEnabled = false;
    protected static boolean sToolkitSetFrameRateReadOnlyFlagValue = Flags.toolkitSetFrameRateReadOnly();
    @UnsupportedAppUsage
    private final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();

    public Window(Context context) {
        this.mContext = context;
        this.mFeatures = this.mLocalFeatures = Window.getDefaultFeatures(context);
    }

    public Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedArray getWindowStyle() {
        Window window = this;
        synchronized (window) {
            if (this.mWindowStyle == null) {
                this.mWindowStyle = this.mContext.obtainStyledAttributes(R.styleable.Window);
            }
            return this.mWindowStyle;
        }
    }

    public void setContainer(Window container) {
        this.mContainer = container;
        if (container != null) {
            this.mFeatures |= 2;
            this.mLocalFeatures |= 2;
            container.mHasChildren = true;
        }
    }

    public Window getContainer() {
        return this.mContainer;
    }

    public boolean hasChildren() {
        return this.mHasChildren;
    }

    public void destroy() {
        this.mDestroyed = true;
        this.onDestroy();
    }

    protected void onDestroy() {
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public void setWindowManager(WindowManager wm, IBinder appToken, String appName) {
        this.setWindowManager(wm, appToken, appName, false);
    }

    public void setWindowManager(WindowManager wm, IBinder appToken, String appName, boolean hardwareAccelerated) {
        this.setWindowManager(wm, appToken, appName, hardwareAccelerated, true);
    }

    public void setWindowManager(@Nullable WindowManager wm, @Nullable IBinder appToken, @Nullable String appName, boolean hardwareAccelerated, boolean createLocalWindowManager) {
        createLocalWindowManager |= !com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.enableWindowContextOverrideType();
        this.mAppToken = appToken;
        this.mAppName = appName;
        this.mHardwareAccelerated = hardwareAccelerated;
        if (wm == null) {
            wm = (WindowManager)this.mContext.getSystemService("window");
        }
        if (createLocalWindowManager) {
            this.mWindowManager = wm.createLocalWindowManager(this);
        } else {
            this.mWindowManager = wm;
            wm.setParentWindow(this);
        }
    }

    void adjustLayoutParamsForSubWindow(WindowManager.LayoutParams wp) {
        CharSequence curTitle = wp.getTitle();
        if (wp.type >= 1000 && wp.type <= 1999) {
            View decor;
            if (wp.token == null && (decor = this.peekDecorView()) != null) {
                wp.token = decor.getWindowToken();
            }
            if (curTitle == null || curTitle.length() == 0) {
                StringBuilder title = new StringBuilder(32);
                if (wp.type == 1001) {
                    title.append("Media");
                } else if (wp.type == 1004) {
                    title.append("MediaOvr");
                } else if (wp.type == 1000) {
                    title.append("Panel");
                } else if (wp.type == 1002) {
                    title.append("SubPanel");
                } else if (wp.type == 1005) {
                    title.append("AboveSubPanel");
                } else if (wp.type == 1003) {
                    title.append("AtchDlg");
                } else {
                    title.append(wp.type);
                }
                if (this.mAppName != null) {
                    title.append(":").append(this.mAppName);
                }
                wp.setTitle(title);
            }
        } else if (wp.type >= 2000 && wp.type <= 2999) {
            if (curTitle == null || curTitle.length() == 0) {
                StringBuilder title = new StringBuilder(32);
                title.append("Sys").append(wp.type);
                if (this.mAppName != null) {
                    title.append(":").append(this.mAppName);
                }
                wp.setTitle(title);
            }
        } else {
            if (wp.token == null) {
                IBinder iBinder = wp.token = this.mContainer == null ? this.mAppToken : this.mContainer.mAppToken;
            }
            if ((curTitle == null || curTitle.length() == 0) && this.mAppName != null) {
                wp.setTitle(this.mAppName);
            }
        }
        if (wp.packageName == null) {
            wp.packageName = this.mContext.getPackageName();
        }
        if (this.mHardwareAccelerated || (this.mWindowAttributes.flags & 0x1000000) != 0) {
            wp.flags |= 0x1000000;
        }
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public void addOnFrameMetricsAvailableListener(@NonNull OnFrameMetricsAvailableListener listener, Handler handler) {
        View decorView = this.getDecorView();
        if (decorView == null) {
            throw new IllegalStateException("can't observe a Window without an attached view");
        }
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        decorView.addFrameMetricsListener(this, listener, handler);
    }

    public void removeOnFrameMetricsAvailableListener(OnFrameMetricsAvailableListener listener) {
        View decorView = this.getDecorView();
        if (decorView != null) {
            this.getDecorView().removeFrameMetricsListener(listener);
        }
    }

    public void setOnWindowDismissedCallback(OnWindowDismissedCallback dcb) {
        this.mOnWindowDismissedCallback = dcb;
    }

    public void dispatchOnWindowDismissed(boolean finishTask, boolean suppressWindowTransition) {
        if (this.mOnWindowDismissedCallback != null) {
            this.mOnWindowDismissedCallback.onWindowDismissed(finishTask, suppressWindowTransition);
        }
    }

    public void setOnWindowSwipeDismissedCallback(OnWindowSwipeDismissedCallback sdcb) {
        this.mOnWindowSwipeDismissedCallback = sdcb;
    }

    public void dispatchOnWindowSwipeDismissed() {
        if (this.mOnWindowSwipeDismissedCallback != null) {
            this.mOnWindowSwipeDismissedCallback.onWindowSwipeDismissed();
        }
    }

    public void setWindowControllerCallback(WindowControllerCallback wccb) {
        this.mWindowControllerCallback = wccb;
    }

    public WindowControllerCallback getWindowControllerCallback() {
        return this.mWindowControllerCallback;
    }

    public void setDecorCallback(DecorCallback decorCallback) {
        this.mDecorCallback = decorCallback;
    }

    public void setSystemBarAppearance(int appearance) {
        this.mSystemBarAppearance = appearance;
    }

    public int getSystemBarAppearance() {
        return this.mSystemBarAppearance;
    }

    public void dispatchOnSystemBarAppearanceChanged(int appearance) {
        this.setSystemBarAppearance(appearance);
        if (this.mDecorCallback != null) {
            this.mDecorCallback.onSystemBarAppearanceChanged(appearance);
        }
        if (this.mWindowControllerCallback != null) {
            this.mWindowControllerCallback.updateSystemBarsAppearance(appearance);
        }
    }

    public boolean onDrawLegacyNavigationBarBackgroundChanged(boolean drawLegacyNavigationBarBackground) {
        if (this.mDecorCallback == null) {
            return false;
        }
        return this.mDecorCallback.onDrawLegacyNavigationBarBackgroundChanged(drawLegacyNavigationBarBackground);
    }

    public void setRestrictedCaptionAreaListener(OnRestrictedCaptionAreaChangedListener listener) {
        this.mOnRestrictedCaptionAreaChangedListener = listener;
        this.mRestrictedCaptionAreaRect = listener != null ? new Rect() : null;
    }

    @RequiresPermission(value="android.permission.HIDE_OVERLAY_WINDOWS")
    public void setHideOverlayWindows(boolean hide) {
        if (this.mContext.checkSelfPermission("android.permission.HIDE_NON_SYSTEM_OVERLAY_WINDOWS") != 0 && this.mContext.checkSelfPermission("android.permission.HIDE_OVERLAY_WINDOWS") != 0) {
            throw new SecurityException("Permission denial: setHideOverlayWindows: HIDE_OVERLAY_WINDOWS");
        }
        this.setPrivateFlags(hide ? 524288 : 0, 524288);
    }

    public abstract void takeSurface(SurfaceHolder.Callback2 var1);

    public abstract void takeInputQueue(InputQueue.Callback var1);

    public abstract boolean isFloating();

    public void setLayout(int width, int height) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.width = width;
        attrs.height = height;
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setGravity(int gravity) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.gravity = gravity;
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setType(int type) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.type = type;
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setFormat(int format) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (format != 0) {
            attrs.format = format;
            this.mHaveWindowFormat = true;
        } else {
            attrs.format = this.mDefaultWindowFormat;
            this.mHaveWindowFormat = false;
        }
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setWindowAnimations(int resId) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.windowAnimations = resId;
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setSoftInputMode(int mode) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (mode != 0) {
            attrs.softInputMode = mode;
            this.mHasSoftInputMode = true;
        } else {
            this.mHasSoftInputMode = false;
        }
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void addFlags(int flags) {
        this.setFlags(flags, flags);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addPrivateFlags(int flags) {
        this.setPrivateFlags(flags, flags);
    }

    @SystemApi
    public void addSystemFlags(int flags) {
        this.addPrivateFlags(flags);
    }

    public void clearFlags(int flags) {
        this.setFlags(0, flags);
    }

    public void setFlags(int flags, int mask) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.flags = attrs.flags & ~mask | flags & mask;
        this.mForcedWindowFlags |= mask;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private void setPrivateFlags(int flags, int mask) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.privateFlags = attrs.privateFlags & ~mask | flags & mask;
        this.dispatchWindowAttributesChanged(attrs);
    }

    protected void dispatchWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setColorMode(int colorMode) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.setColorMode(colorMode);
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setDesiredHdrHeadroom(float desiredHeadroom) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.setDesiredHdrHeadroom(desiredHeadroom);
        this.dispatchWindowAttributesChanged(attrs);
    }

    public float getDesiredHdrHeadroom() {
        return this.getAttributes().getDesiredHdrHeadroom();
    }

    @FlaggedApi(value="android.view.flags.toolkit_set_frame_rate_read_only")
    public void setFrameRateBoostOnTouchEnabled(boolean enabled) {
        if (sToolkitSetFrameRateReadOnlyFlagValue) {
            WindowManager.LayoutParams attrs = this.getAttributes();
            attrs.setFrameRateBoostOnTouchEnabled(enabled);
            this.dispatchWindowAttributesChanged(attrs);
        }
    }

    @FlaggedApi(value="android.view.flags.toolkit_set_frame_rate_read_only")
    public boolean getFrameRateBoostOnTouchEnabled() {
        if (sToolkitSetFrameRateReadOnlyFlagValue) {
            return this.getAttributes().getFrameRateBoostOnTouchEnabled();
        }
        return true;
    }

    @FlaggedApi(value="android.view.flags.toolkit_set_frame_rate_read_only")
    public void setFrameRatePowerSavingsBalanced(boolean enabled) {
        if (sToolkitSetFrameRateReadOnlyFlagValue) {
            WindowManager.LayoutParams attrs = this.getAttributes();
            attrs.setFrameRatePowerSavingsBalanced(enabled);
            this.dispatchWindowAttributesChanged(attrs);
        }
    }

    @FlaggedApi(value="android.view.flags.toolkit_set_frame_rate_read_only")
    public boolean isFrameRatePowerSavingsBalanced() {
        if (sToolkitSetFrameRateReadOnlyFlagValue) {
            return this.getAttributes().isFrameRatePowerSavingsBalanced();
        }
        return false;
    }

    public void setPreferMinimalPostProcessing(boolean isPreferred) {
        this.mWindowAttributes.preferMinimalPostProcessing = isPreferred;
        this.dispatchWindowAttributesChanged(this.mWindowAttributes);
    }

    public int getColorMode() {
        return this.getAttributes().getColorMode();
    }

    public boolean isWideColorGamut() {
        return this.getColorMode() == 1 && this.getContext().getResources().getConfiguration().isScreenWideColorGamut();
    }

    public void setDimAmount(float amount) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.dimAmount = amount;
        this.mHaveDimAmount = true;
        this.dispatchWindowAttributesChanged(attrs);
    }

    public void setDecorFitsSystemWindows(boolean decorFitsSystemWindows) {
    }

    public boolean decorFitsSystemWindows() {
        return false;
    }

    public void setAttributes(WindowManager.LayoutParams a) {
        this.mWindowAttributes.copyFrom(a);
        this.dispatchWindowAttributesChanged(this.mWindowAttributes);
    }

    public WindowManager.LayoutParams getAttributes() {
        return this.mWindowAttributes;
    }

    protected int getForcedWindowFlags() {
        return this.mForcedWindowFlags;
    }

    protected boolean hasSoftInputMode() {
        return this.mHasSoftInputMode;
    }

    @UnsupportedAppUsage
    public void setCloseOnTouchOutside(boolean close) {
        this.mCloseOnTouchOutside = close;
        this.mSetCloseOnTouchOutside = true;
    }

    @UnsupportedAppUsage
    public void setCloseOnTouchOutsideIfNotSet(boolean close) {
        if (!this.mSetCloseOnTouchOutside) {
            this.mCloseOnTouchOutside = close;
            this.mSetCloseOnTouchOutside = true;
        }
    }

    public boolean shouldCloseOnTouchOutside() {
        return this.mCloseOnTouchOutside;
    }

    @UnsupportedAppUsage
    public abstract void alwaysReadCloseOnTouchAttr();

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean shouldCloseOnTouch(Context context, MotionEvent event) {
        boolean isOutside;
        boolean bl = isOutside = event.getAction() == 1 && this.isOutOfBounds(context, event) || event.getAction() == 4;
        return this.mCloseOnTouchOutside && this.peekDecorView() != null && isOutside;
    }

    public void setSustainedPerformanceMode(boolean enable) {
        this.setPrivateFlags(enable ? 65536 : 0, 65536);
    }

    private boolean isOutOfBounds(Context context, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(context).getScaledWindowTouchSlop();
        View decorView = this.getDecorView();
        return x < -slop || y < -slop || x > decorView.getWidth() + slop || y > decorView.getHeight() + slop;
    }

    public boolean requestFeature(int featureId) {
        int flag = 1 << featureId;
        this.mFeatures |= flag;
        this.mLocalFeatures |= this.mContainer != null ? flag & ~this.mContainer.mFeatures : flag;
        return (this.mFeatures & flag) != 0;
    }

    protected void removeFeature(int featureId) {
        int flag = 1 << featureId;
        this.mFeatures &= ~flag;
        this.mLocalFeatures &= ~(this.mContainer != null ? flag & ~this.mContainer.mFeatures : flag);
    }

    public void makeActive() {
        if (this.mContainer != null) {
            if (this.mContainer.mActiveChild != null) {
                this.mContainer.mActiveChild.mIsActive = false;
            }
            this.mContainer.mActiveChild = this;
        }
        this.mIsActive = true;
        this.onActive();
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public <T extends View> T findViewById(int id2) {
        return this.getDecorView().findViewById(id2);
    }

    @NonNull
    public <T extends View> T requireViewById(int id2) {
        T view = this.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this Window");
        }
        return view;
    }

    public abstract void setContentView(int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void clearContentView();

    @Nullable
    public abstract View getCurrentFocus();

    @NonNull
    public abstract LayoutInflater getLayoutInflater();

    public abstract void setTitle(CharSequence var1);

    @Deprecated
    public abstract void setTitleColor(int var1);

    public abstract void openPanel(int var1, KeyEvent var2);

    public abstract void closePanel(int var1);

    public abstract void togglePanel(int var1, KeyEvent var2);

    public abstract void invalidatePanelMenu(int var1);

    public abstract boolean performPanelShortcut(int var1, int var2, KeyEvent var3, int var4);

    public abstract boolean performPanelIdentifierAction(int var1, int var2, int var3);

    public abstract void closeAllPanels();

    public abstract boolean performContextMenuIdentifierAction(int var1, int var2);

    public abstract void onConfigurationChanged(Configuration var1);

    public void setElevation(float elevation) {
    }

    public float getElevation() {
        return 0.0f;
    }

    public void setClipToOutline(boolean clipToOutline) {
    }

    public void setBackgroundDrawableResource(int resId) {
        this.setBackgroundDrawable(this.mContext.getDrawable(resId));
    }

    public abstract void setBackgroundDrawable(Drawable var1);

    public void setBackgroundBlurRadius(int blurRadius) {
    }

    public abstract void setFeatureDrawableResource(int var1, int var2);

    public abstract void setFeatureDrawableUri(int var1, Uri var2);

    public abstract void setFeatureDrawable(int var1, Drawable var2);

    public abstract void setFeatureDrawableAlpha(int var1, int var2);

    public abstract void setFeatureInt(int var1, int var2);

    public abstract void takeKeyEvents(boolean var1);

    public abstract boolean superDispatchKeyEvent(KeyEvent var1);

    public abstract boolean superDispatchKeyShortcutEvent(KeyEvent var1);

    public abstract boolean superDispatchTouchEvent(MotionEvent var1);

    public abstract boolean superDispatchTrackballEvent(MotionEvent var1);

    public abstract boolean superDispatchGenericMotionEvent(MotionEvent var1);

    @NonNull
    public abstract View getDecorView();

    @Nullable
    public View getStatusBarBackgroundView() {
        return null;
    }

    @Nullable
    public View getNavigationBarBackgroundView() {
        return null;
    }

    public abstract View peekDecorView();

    public abstract Bundle saveHierarchyState();

    public abstract void restoreHierarchyState(Bundle var1);

    protected abstract void onActive();

    protected int getFeatures() {
        return this.mFeatures;
    }

    public static int getDefaultFeatures(Context context) {
        int features = 0;
        Resources res = context.getResources();
        if (res.getBoolean(17891640)) {
            features |= 1;
        }
        if (res.getBoolean(17891639)) {
            features |= 0x40;
        }
        return features;
    }

    public boolean hasFeature(int feature) {
        return (this.getFeatures() & 1 << feature) != 0;
    }

    protected int getLocalFeatures() {
        return this.mLocalFeatures;
    }

    protected void setDefaultWindowFormat(int format) {
        this.mDefaultWindowFormat = format;
        if (!this.mHaveWindowFormat) {
            WindowManager.LayoutParams attrs = this.getAttributes();
            attrs.format = format;
            this.dispatchWindowAttributesChanged(attrs);
        }
    }

    protected boolean haveDimAmount() {
        return this.mHaveDimAmount;
    }

    public abstract void setChildDrawable(int var1, Drawable var2);

    public abstract void setChildInt(int var1, int var2);

    public abstract boolean isShortcutKey(int var1, KeyEvent var2);

    public abstract void setVolumeControlStream(int var1);

    public abstract int getVolumeControlStream();

    public void setMediaController(MediaController controller) {
    }

    public MediaController getMediaController() {
        return null;
    }

    public void setUiOptions(int uiOptions) {
    }

    public void setUiOptions(int uiOptions, int mask) {
    }

    public void setIcon(int resId) {
    }

    public void setDefaultIcon(int resId) {
    }

    public void setLogo(int resId) {
    }

    public void setDefaultLogo(int resId) {
    }

    public void setLocalFocus(boolean hasFocus, boolean inTouchMode) {
    }

    public void injectInputEvent(InputEvent event) {
    }

    public TransitionManager getTransitionManager() {
        return null;
    }

    public void setTransitionManager(TransitionManager tm) {
        throw new UnsupportedOperationException();
    }

    public Scene getContentScene() {
        return null;
    }

    public void setEnterTransition(Transition transition2) {
    }

    public void setReturnTransition(Transition transition2) {
    }

    public void setExitTransition(Transition transition2) {
    }

    public void setReenterTransition(Transition transition2) {
    }

    public Transition getEnterTransition() {
        return null;
    }

    public Transition getReturnTransition() {
        return null;
    }

    public Transition getExitTransition() {
        return null;
    }

    public Transition getReenterTransition() {
        return null;
    }

    public void setSharedElementEnterTransition(Transition transition2) {
    }

    public void setSharedElementReturnTransition(Transition transition2) {
    }

    public Transition getSharedElementEnterTransition() {
        return null;
    }

    public Transition getSharedElementReturnTransition() {
        return null;
    }

    public void setSharedElementExitTransition(Transition transition2) {
    }

    public void setSharedElementReenterTransition(Transition transition2) {
    }

    public Transition getSharedElementExitTransition() {
        return null;
    }

    public Transition getSharedElementReenterTransition() {
        return null;
    }

    public void setAllowEnterTransitionOverlap(boolean allow) {
    }

    public boolean getAllowEnterTransitionOverlap() {
        return true;
    }

    public void setAllowReturnTransitionOverlap(boolean allow) {
    }

    public boolean getAllowReturnTransitionOverlap() {
        return true;
    }

    public long getTransitionBackgroundFadeDuration() {
        return 0L;
    }

    public void setTransitionBackgroundFadeDuration(long fadeDurationMillis) {
    }

    public boolean getSharedElementsUseOverlay() {
        return true;
    }

    public void setSharedElementsUseOverlay(boolean sharedElementsUseOverlay) {
    }

    @Deprecated
    public abstract int getStatusBarColor();

    @Deprecated
    public abstract void setStatusBarColor(int var1);

    @Deprecated
    public abstract int getNavigationBarColor();

    @Deprecated
    public abstract void setNavigationBarColor(int var1);

    @Deprecated
    public void setNavigationBarDividerColor(int dividerColor) {
    }

    @Deprecated
    public int getNavigationBarDividerColor() {
        return 0;
    }

    @Deprecated
    public void setStatusBarContrastEnforced(boolean ensureContrast) {
    }

    @Deprecated
    public boolean isStatusBarContrastEnforced() {
        return false;
    }

    public void setNavigationBarContrastEnforced(boolean enforceContrast) {
    }

    public boolean isNavigationBarContrastEnforced() {
        return false;
    }

    public void setSystemGestureExclusionRects(@NonNull List<Rect> rects) {
        throw new UnsupportedOperationException("window does not support gesture exclusion rects");
    }

    @NonNull
    public List<Rect> getSystemGestureExclusionRects() {
        return Collections.emptyList();
    }

    public void requestScrollCapture(IScrollCaptureResponseListener listener) {
    }

    public void registerScrollCaptureCallback(@NonNull ScrollCaptureCallback callback) {
    }

    public void unregisterScrollCaptureCallback(@NonNull ScrollCaptureCallback callback) {
    }

    public void setTheme(int resId) {
    }

    public void setOverlayWithDecorCaptionEnabled(boolean enabled) {
        this.mOverlayWithDecorCaptionEnabled = enabled;
    }

    public boolean isOverlayWithDecorCaptionEnabled() {
        return this.mOverlayWithDecorCaptionEnabled;
    }

    public void notifyRestrictedCaptionAreaCallback(int left, int top, int right, int bottom) {
        if (this.mOnRestrictedCaptionAreaChangedListener != null) {
            this.mRestrictedCaptionAreaRect.set(left, top, right, bottom);
            this.mOnRestrictedCaptionAreaChangedListener.onRestrictedCaptionAreaChanged(this.mRestrictedCaptionAreaRect);
        }
    }

    public abstract void setDecorCaptionShade(int var1);

    public abstract void setResizingCaptionDrawable(Drawable var1);

    public abstract void onMultiWindowModeChanged();

    public abstract void onPictureInPictureModeChanged(boolean var1);

    @Nullable
    public WindowInsetsController getInsetsController() {
        return null;
    }

    @Nullable
    public AttachedSurfaceControl getRootSurfaceControl() {
        return null;
    }

    @NonNull
    public OnBackInvokedDispatcher getOnBackInvokedDispatcher() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public static interface Callback {
        public boolean dispatchKeyEvent(KeyEvent var1);

        public boolean dispatchKeyShortcutEvent(KeyEvent var1);

        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean dispatchTrackballEvent(MotionEvent var1);

        public boolean dispatchGenericMotionEvent(MotionEvent var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        @Nullable
        public View onCreatePanelView(int var1);

        public boolean onCreatePanelMenu(int var1, @NonNull Menu var2);

        public boolean onPreparePanel(int var1, @Nullable View var2, @NonNull Menu var3);

        public boolean onMenuOpened(int var1, @NonNull Menu var2);

        public boolean onMenuItemSelected(int var1, @NonNull MenuItem var2);

        public void onWindowAttributesChanged(WindowManager.LayoutParams var1);

        public void onContentChanged();

        public void onWindowFocusChanged(boolean var1);

        public void onAttachedToWindow();

        public void onDetachedFromWindow();

        public void onPanelClosed(int var1, @NonNull Menu var2);

        public boolean onSearchRequested();

        public boolean onSearchRequested(SearchEvent var1);

        @Nullable
        public ActionMode onWindowStartingActionMode(ActionMode.Callback var1);

        @Nullable
        public ActionMode onWindowStartingActionMode(ActionMode.Callback var1, int var2);

        public void onActionModeStarted(ActionMode var1);

        public void onActionModeFinished(ActionMode var1);

        default public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> data, @Nullable Menu menu2, int deviceId) {
        }

        default public void onPointerCaptureChanged(boolean hasCapture) {
        }
    }

    public static interface OnFrameMetricsAvailableListener {
        public void onFrameMetricsAvailable(Window var1, FrameMetrics var2, int var3);
    }

    public static interface OnWindowDismissedCallback {
        public void onWindowDismissed(boolean var1, boolean var2);
    }

    public static interface OnWindowSwipeDismissedCallback {
        public void onWindowSwipeDismissed();
    }

    public static interface WindowControllerCallback {
        public void toggleFreeformWindowingMode();

        public void enterPictureInPictureModeIfPossible();

        public boolean isTaskRoot();

        public void updateStatusBarColor(int var1);

        public void updateSystemBarsAppearance(int var1);

        public void updateNavigationBarColor(int var1);
    }

    public static interface DecorCallback {
        public void onSystemBarAppearanceChanged(int var1);

        public boolean onDrawLegacyNavigationBarBackgroundChanged(boolean var1);
    }

    public static interface OnRestrictedCaptionAreaChangedListener {
        public void onRestrictedCaptionAreaChanged(Rect var1);
    }

    public static interface OnContentApplyWindowInsetsListener {
        @NonNull
        public Pair<Insets, WindowInsets> onContentApplyWindowInsets(@NonNull View var1, @NonNull WindowInsets var2);
    }
}

