/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.view.WindowInsets;
import java.util.function.Supplier;

public class WindowMetrics {
    @NonNull
    private final Rect mBounds;
    private WindowInsets mWindowInsets;
    private Supplier<WindowInsets> mWindowInsetsSupplier;
    private final float mDensity;

    @Deprecated
    public WindowMetrics(@NonNull Rect bounds, @NonNull WindowInsets windowInsets) {
        this(bounds, windowInsets, 1.0f);
    }

    public WindowMetrics(@NonNull Rect bounds, @NonNull WindowInsets windowInsets, float density) {
        this.mBounds = bounds;
        this.mWindowInsets = windowInsets;
        this.mDensity = density;
    }

    public WindowMetrics(@NonNull Rect bounds, @NonNull Supplier<WindowInsets> windowInsetsSupplier, float density) {
        this.mBounds = bounds;
        this.mWindowInsetsSupplier = windowInsetsSupplier;
        this.mDensity = density;
    }

    @NonNull
    public Rect getBounds() {
        return this.mBounds;
    }

    @NonNull
    public WindowInsets getWindowInsets() {
        if (this.mWindowInsets != null) {
            return this.mWindowInsets;
        }
        this.mWindowInsets = this.mWindowInsetsSupplier.get();
        return this.mWindowInsets;
    }

    public float getDensity() {
        return this.mDensity;
    }

    public String toString() {
        return WindowMetrics.class.getSimpleName() + ":{bounds=" + this.mBounds + ", windowInsets=" + this.mWindowInsets + ", density=" + this.mDensity + "}";
    }
}

