/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class ClipRectAnimation
extends Animation {
    protected final Rect mFromRect = new Rect();
    protected final Rect mToRect = new Rect();
    private int mFromLeftType = 0;
    private int mFromTopType = 0;
    private int mFromRightType = 0;
    private int mFromBottomType = 0;
    private int mToLeftType = 0;
    private int mToTopType = 0;
    private int mToRightType = 0;
    private int mToBottomType = 0;
    private float mFromLeftValue;
    private float mFromTopValue;
    private float mFromRightValue;
    private float mFromBottomValue;
    private float mToLeftValue;
    private float mToTopValue;
    private float mToRightValue;
    private float mToBottomValue;

    public ClipRectAnimation(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ClipRectAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(1), context);
        this.mFromLeftType = d.type;
        this.mFromLeftValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(3), context);
        this.mFromTopType = d.type;
        this.mFromTopValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(2), context);
        this.mFromRightType = d.type;
        this.mFromRightValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(0), context);
        this.mFromBottomType = d.type;
        this.mFromBottomValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(5), context);
        this.mToLeftType = d.type;
        this.mToLeftValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(7), context);
        this.mToTopType = d.type;
        this.mToTopValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(6), context);
        this.mToRightType = d.type;
        this.mToRightValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(4), context);
        this.mToBottomType = d.type;
        this.mToBottomValue = d.value;
        a.recycle();
    }

    public ClipRectAnimation(Rect fromClip, Rect toClip) {
        if (fromClip == null || toClip == null) {
            throw new RuntimeException("Expected non-null animation clip rects");
        }
        this.mFromLeftValue = fromClip.left;
        this.mFromTopValue = fromClip.top;
        this.mFromRightValue = fromClip.right;
        this.mFromBottomValue = fromClip.bottom;
        this.mToLeftValue = toClip.left;
        this.mToTopValue = toClip.top;
        this.mToRightValue = toClip.right;
        this.mToBottomValue = toClip.bottom;
    }

    public ClipRectAnimation(int fromL, int fromT, int fromR, int fromB, int toL, int toT, int toR, int toB) {
        this(new Rect(fromL, fromT, fromR, fromB), new Rect(toL, toT, toR, toB));
    }

    @Override
    protected void applyTransformation(float it, Transformation tr) {
        int l = this.mFromRect.left + (int)((float)(this.mToRect.left - this.mFromRect.left) * it);
        int t = this.mFromRect.top + (int)((float)(this.mToRect.top - this.mFromRect.top) * it);
        int r = this.mFromRect.right + (int)((float)(this.mToRect.right - this.mFromRect.right) * it);
        int b = this.mFromRect.bottom + (int)((float)(this.mToRect.bottom - this.mFromRect.bottom) * it);
        tr.setClipRect(l, t, r, b);
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return false;
    }

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromRect.set((int)this.resolveSize(this.mFromLeftType, this.mFromLeftValue, width, parentWidth), (int)this.resolveSize(this.mFromTopType, this.mFromTopValue, height, parentHeight), (int)this.resolveSize(this.mFromRightType, this.mFromRightValue, width, parentWidth), (int)this.resolveSize(this.mFromBottomType, this.mFromBottomValue, height, parentHeight));
        this.mToRect.set((int)this.resolveSize(this.mToLeftType, this.mToLeftValue, width, parentWidth), (int)this.resolveSize(this.mToTopType, this.mToTopValue, height, parentHeight), (int)this.resolveSize(this.mToRightType, this.mToRightValue, width, parentWidth), (int)this.resolveSize(this.mToBottomType, this.mToBottomValue, height, parentHeight));
    }
}

