/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;

public class LayoutAnimationController {
    public static final int ORDER_NORMAL = 0;
    public static final int ORDER_REVERSE = 1;
    public static final int ORDER_RANDOM = 2;
    protected Animation mAnimation;
    protected Random mRandomizer;
    protected Interpolator mInterpolator;
    private float mDelay;
    private int mOrder;
    private long mDuration;
    private long mMaxDelay;

    public LayoutAnimationController(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LayoutAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(1), context);
        this.mDelay = d.value;
        this.mOrder = a.getInt(3, 0);
        int resource = a.getResourceId(2, 0);
        if (resource > 0) {
            this.setAnimation(context, resource);
        }
        if ((resource = a.getResourceId(0, 0)) > 0) {
            this.setInterpolator(context, resource);
        }
        a.recycle();
    }

    public LayoutAnimationController(Animation animation) {
        this(animation, 0.5f);
    }

    public LayoutAnimationController(Animation animation, float delay) {
        this.mDelay = delay;
        this.setAnimation(animation);
    }

    public int getOrder() {
        return this.mOrder;
    }

    public void setOrder(int order) {
        this.mOrder = order;
    }

    public void setAnimation(Context context, int resourceID) {
        this.setAnimation(AnimationUtils.loadAnimation(context, resourceID));
    }

    public void setAnimation(Animation animation) {
        this.mAnimation = animation;
        this.mAnimation.setFillBefore(true);
    }

    public Animation getAnimation() {
        return this.mAnimation;
    }

    public void setInterpolator(Context context, int resourceID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resourceID));
    }

    public void setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public float getDelay() {
        return this.mDelay;
    }

    public void setDelay(float delay) {
        this.mDelay = delay;
    }

    public boolean willOverlap() {
        return this.mDelay < 1.0f;
    }

    public void start() {
        this.mDuration = this.mAnimation.getDuration();
        this.mMaxDelay = Long.MIN_VALUE;
        this.mAnimation.setStartTime(-1L);
    }

    public Animation getAnimationForView(View view) {
        long delay = this.getDelayForView(view) + this.mAnimation.getStartOffset();
        this.mMaxDelay = Math.max(this.mMaxDelay, delay);
        try {
            Animation animation = this.mAnimation.clone();
            animation.setStartOffset(delay);
            return animation;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isDone() {
        return AnimationUtils.currentAnimationTimeMillis() > this.mAnimation.getStartTime() + this.mMaxDelay + this.mDuration;
    }

    protected long getDelayForView(View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        AnimationParameters params = lp.layoutAnimationParameters;
        if (params == null) {
            return 0L;
        }
        float delay = this.mDelay * (float)this.mAnimation.getDuration();
        long viewDelay = (long)((float)this.getTransformedIndex(params) * delay);
        float totalDelay = delay * (float)params.count;
        if (this.mInterpolator == null) {
            this.mInterpolator = new LinearInterpolator();
        }
        float normalizedDelay = (float)viewDelay / totalDelay;
        normalizedDelay = this.mInterpolator.getInterpolation(normalizedDelay);
        return (long)(normalizedDelay * totalDelay);
    }

    protected int getTransformedIndex(AnimationParameters params) {
        switch (this.getOrder()) {
            case 1: {
                return params.count - 1 - params.index;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    this.mRandomizer = new Random();
                }
                return (int)((float)params.count * this.mRandomizer.nextFloat());
            }
        }
        return params.index;
    }

    public static class AnimationParameters {
        public int count;
        public int index;
    }
}

