/*
 * Decompiled with CFR 0.152.
 */
package android.view.displayhash;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;

public class DisplayHash
implements Parcelable {
    private final long mTimeMillis;
    @NonNull
    private final Rect mBoundsInWindow;
    @NonNull
    private final String mHashAlgorithm;
    @NonNull
    private final byte[] mImageHash;
    @NonNull
    private final byte[] mHmac;
    @NonNull
    public static final Parcelable.Creator<DisplayHash> CREATOR = new Parcelable.Creator<DisplayHash>(){

        public DisplayHash[] newArray(int size) {
            return new DisplayHash[size];
        }

        @Override
        public DisplayHash createFromParcel(@NonNull Parcel in) {
            return new DisplayHash(in);
        }
    };

    @SystemApi
    public DisplayHash(long timeMillis, @NonNull Rect boundsInWindow, @NonNull String hashAlgorithm, @NonNull byte[] imageHash, @NonNull byte[] hmac) {
        this.mTimeMillis = timeMillis;
        this.mBoundsInWindow = boundsInWindow;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBoundsInWindow);
        this.mHashAlgorithm = hashAlgorithm;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHashAlgorithm);
        this.mImageHash = imageHash;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mImageHash);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
    }

    @SystemApi
    public long getTimeMillis() {
        return this.mTimeMillis;
    }

    @SystemApi
    @NonNull
    public Rect getBoundsInWindow() {
        return this.mBoundsInWindow;
    }

    @SystemApi
    @NonNull
    public String getHashAlgorithm() {
        return this.mHashAlgorithm;
    }

    @SystemApi
    @NonNull
    public byte[] getImageHash() {
        return this.mImageHash;
    }

    @SystemApi
    @NonNull
    public byte[] getHmac() {
        return this.mHmac;
    }

    public String toString() {
        return "DisplayHash { timeMillis = " + this.mTimeMillis + ", boundsInWindow = " + this.mBoundsInWindow + ", hashAlgorithm = " + this.mHashAlgorithm + ", imageHash = " + this.byteArrayToString(this.mImageHash) + ", hmac = " + this.byteArrayToString(this.mHmac) + " }";
    }

    private String byteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            return "null";
        }
        int iMax = byteArray.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            String formatted = String.format("%02X", byteArray[i] & 0xFF);
            b.append(formatted);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @Override
    @SystemApi
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mTimeMillis);
        dest.writeTypedObject(this.mBoundsInWindow, flags);
        dest.writeString(this.mHashAlgorithm);
        dest.writeByteArray(this.mImageHash);
        dest.writeByteArray(this.mHmac);
    }

    @Override
    @SystemApi
    public int describeContents() {
        return 0;
    }

    private DisplayHash(@NonNull Parcel in) {
        this.mTimeMillis = in.readLong();
        Rect boundsInWindow = in.readTypedObject(Rect.CREATOR);
        String hashAlgorithm = in.readString();
        byte[] imageHash = in.createByteArray();
        byte[] hmac = in.createByteArray();
        this.mBoundsInWindow = boundsInWindow;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBoundsInWindow);
        this.mHashAlgorithm = hashAlgorithm;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHashAlgorithm);
        this.mImageHash = imageHash;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mImageHash);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
    }
}

