/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class EditorBoundsInfo
implements Parcelable {
    private final RectF mEditorBounds;
    private final RectF mHandwritingBounds;
    private final int mHashCode;
    @NonNull
    public static final Parcelable.Creator<EditorBoundsInfo> CREATOR = new Parcelable.Creator<EditorBoundsInfo>(){

        @Override
        public EditorBoundsInfo createFromParcel(@NonNull Parcel source) {
            return new EditorBoundsInfo(source);
        }

        public EditorBoundsInfo[] newArray(int size) {
            return new EditorBoundsInfo[size];
        }
    };

    private EditorBoundsInfo(@NonNull Parcel source) {
        this.mHashCode = source.readInt();
        this.mEditorBounds = source.readTypedObject(RectF.CREATOR);
        this.mHandwritingBounds = source.readTypedObject(RectF.CREATOR);
    }

    @Nullable
    public RectF getEditorBounds() {
        return this.mEditorBounds;
    }

    @Nullable
    public RectF getHandwritingBounds() {
        return this.mHandwritingBounds;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public String toString() {
        return "EditorBoundsInfo{mEditorBounds=" + this.mEditorBounds + " mHandwritingBounds=" + this.mHandwritingBounds + "}";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EditorBoundsInfo)) {
            return false;
        }
        EditorBoundsInfo bounds = (EditorBoundsInfo)obj;
        return Objects.equals(bounds.mEditorBounds, this.mEditorBounds) && Objects.equals(bounds.mHandwritingBounds, this.mHandwritingBounds);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mHashCode);
        dest.writeTypedObject(this.mEditorBounds, flags);
        dest.writeTypedObject(this.mHandwritingBounds, flags);
    }

    private EditorBoundsInfo(Builder builder) {
        this.mEditorBounds = builder.mEditorBounds;
        this.mHandwritingBounds = builder.mHandwritingBounds;
        int hash = Objects.hashCode(this.mEditorBounds);
        hash *= 31;
        this.mHashCode = hash += Objects.hashCode(this.mHandwritingBounds);
    }

    public static class Builder {
        private RectF mEditorBounds = null;
        private RectF mHandwritingBounds = null;

        @NonNull
        public Builder setEditorBounds(@Nullable RectF bounds) {
            this.mEditorBounds = bounds;
            return this;
        }

        @NonNull
        public Builder setHandwritingBounds(@Nullable RectF bounds) {
            this.mHandwritingBounds = bounds;
            return this;
        }

        @NonNull
        public EditorBoundsInfo build() {
            return new EditorBoundsInfo(this);
        }
    }
}

