/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.compat.CompatChanges;
import android.os.Bundle;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.widget.inline.InlinePresentationSpec;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.InlinePresentationStyleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InlineSuggestionsRequest
implements Parcelable {
    public static final int SUGGESTION_COUNT_UNLIMITED = Integer.MAX_VALUE;
    private final int mMaxSuggestionCount;
    @NonNull
    private final List<InlinePresentationSpec> mInlinePresentationSpecs;
    @NonNull
    private String mHostPackageName;
    @NonNull
    private LocaleList mSupportedLocales;
    @NonNull
    private Bundle mExtras;
    @Nullable
    private IBinder mHostInputToken;
    private int mHostDisplayId;
    @Nullable
    private InlinePresentationSpec mInlineTooltipPresentationSpec;
    private static final long IME_AUTOFILL_DEFAULT_SUPPORTED_LOCALES_IS_EMPTY = 169273070L;
    @NonNull
    public static final Parcelable.Creator<InlineSuggestionsRequest> CREATOR = new Parcelable.Creator<InlineSuggestionsRequest>(){

        public InlineSuggestionsRequest[] newArray(int size) {
            return new InlineSuggestionsRequest[size];
        }

        @Override
        public InlineSuggestionsRequest createFromParcel(@NonNull Parcel in) {
            return new InlineSuggestionsRequest(in);
        }
    };

    public void setHostInputToken(IBinder hostInputToken) {
        this.mHostInputToken = hostInputToken;
    }

    private boolean extrasEquals(@NonNull Bundle extras) {
        return InlinePresentationStyleUtils.bundleEquals(this.mExtras, extras);
    }

    private void parcelHostInputToken(@NonNull Parcel parcel, int flags) {
        parcel.writeStrongBinder(this.mHostInputToken);
    }

    @Nullable
    private IBinder unparcelHostInputToken(Parcel parcel) {
        return parcel.readStrongBinder();
    }

    public void setHostDisplayId(int hostDisplayId) {
        this.mHostDisplayId = hostDisplayId;
    }

    private void onConstructed() {
        Preconditions.checkState(!this.mInlinePresentationSpecs.isEmpty());
        Preconditions.checkState(this.mMaxSuggestionCount >= this.mInlinePresentationSpecs.size());
    }

    public void filterContentTypes() {
        InlinePresentationStyleUtils.filterContentTypes(this.mExtras);
        for (int i = 0; i < this.mInlinePresentationSpecs.size(); ++i) {
            this.mInlinePresentationSpecs.get(i).filterContentTypes();
        }
        if (this.mInlineTooltipPresentationSpec != null) {
            this.mInlineTooltipPresentationSpec.filterContentTypes();
        }
    }

    private static int defaultMaxSuggestionCount() {
        return Integer.MAX_VALUE;
    }

    private static String defaultHostPackageName() {
        return ActivityThread.currentPackageName();
    }

    private static InlinePresentationSpec defaultInlineTooltipPresentationSpec() {
        return null;
    }

    private static LocaleList defaultSupportedLocales() {
        if (CompatChanges.isChangeEnabled(169273070L)) {
            return LocaleList.getEmptyLocaleList();
        }
        return LocaleList.getDefault();
    }

    @Nullable
    private static IBinder defaultHostInputToken() {
        return null;
    }

    @Nullable
    private static int defaultHostDisplayId() {
        return -1;
    }

    @NonNull
    private static Bundle defaultExtras() {
        return Bundle.EMPTY;
    }

    InlineSuggestionsRequest(int maxSuggestionCount, @NonNull List<InlinePresentationSpec> inlinePresentationSpecs, @NonNull String hostPackageName, @NonNull LocaleList supportedLocales, @NonNull Bundle extras, @Nullable IBinder hostInputToken, int hostDisplayId, @Nullable InlinePresentationSpec inlineTooltipPresentationSpec) {
        this.mMaxSuggestionCount = maxSuggestionCount;
        this.mInlinePresentationSpecs = inlinePresentationSpecs;
        AnnotationValidations.validate(NonNull.class, null, this.mInlinePresentationSpecs);
        this.mHostPackageName = hostPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHostPackageName);
        this.mSupportedLocales = supportedLocales;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSupportedLocales);
        this.mExtras = extras;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExtras);
        this.mHostInputToken = hostInputToken;
        this.mHostDisplayId = hostDisplayId;
        this.mInlineTooltipPresentationSpec = inlineTooltipPresentationSpec;
        this.onConstructed();
    }

    public int getMaxSuggestionCount() {
        return this.mMaxSuggestionCount;
    }

    @NonNull
    public List<InlinePresentationSpec> getInlinePresentationSpecs() {
        return this.mInlinePresentationSpecs;
    }

    @NonNull
    public String getHostPackageName() {
        return this.mHostPackageName;
    }

    @NonNull
    public LocaleList getSupportedLocales() {
        return this.mSupportedLocales;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Nullable
    public IBinder getHostInputToken() {
        return this.mHostInputToken;
    }

    public int getHostDisplayId() {
        return this.mHostDisplayId;
    }

    @Nullable
    public InlinePresentationSpec getInlineTooltipPresentationSpec() {
        return this.mInlineTooltipPresentationSpec;
    }

    public String toString() {
        return "InlineSuggestionsRequest { maxSuggestionCount = " + this.mMaxSuggestionCount + ", inlinePresentationSpecs = " + this.mInlinePresentationSpecs + ", hostPackageName = " + this.mHostPackageName + ", supportedLocales = " + this.mSupportedLocales + ", extras = " + this.mExtras + ", hostInputToken = " + this.mHostInputToken + ", hostDisplayId = " + this.mHostDisplayId + ", inlineTooltipPresentationSpec = " + this.mInlineTooltipPresentationSpec + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineSuggestionsRequest that = (InlineSuggestionsRequest)o;
        return this.mMaxSuggestionCount == that.mMaxSuggestionCount && Objects.equals(this.mInlinePresentationSpecs, that.mInlinePresentationSpecs) && Objects.equals(this.mHostPackageName, that.mHostPackageName) && Objects.equals(this.mSupportedLocales, that.mSupportedLocales) && this.extrasEquals(that.mExtras) && Objects.equals(this.mHostInputToken, that.mHostInputToken) && this.mHostDisplayId == that.mHostDisplayId && Objects.equals(this.mInlineTooltipPresentationSpec, that.mInlineTooltipPresentationSpec);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mMaxSuggestionCount;
        _hash = 31 * _hash + Objects.hashCode(this.mInlinePresentationSpecs);
        _hash = 31 * _hash + Objects.hashCode(this.mHostPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mSupportedLocales);
        _hash = 31 * _hash + Objects.hashCode(this.mExtras);
        _hash = 31 * _hash + Objects.hashCode(this.mHostInputToken);
        _hash = 31 * _hash + this.mHostDisplayId;
        _hash = 31 * _hash + Objects.hashCode(this.mInlineTooltipPresentationSpec);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        int flg = 0;
        if (this.mHostInputToken != null) {
            flg |= 0x20;
        }
        if (this.mInlineTooltipPresentationSpec != null) {
            flg |= 0x80;
        }
        dest.writeInt(flg);
        dest.writeInt(this.mMaxSuggestionCount);
        dest.writeParcelableList(this.mInlinePresentationSpecs, flags);
        dest.writeString(this.mHostPackageName);
        dest.writeTypedObject(this.mSupportedLocales, flags);
        dest.writeBundle(this.mExtras);
        this.parcelHostInputToken(dest, flags);
        dest.writeInt(this.mHostDisplayId);
        if (this.mInlineTooltipPresentationSpec != null) {
            dest.writeTypedObject(this.mInlineTooltipPresentationSpec, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    InlineSuggestionsRequest(@NonNull Parcel in) {
        int flg = in.readInt();
        int maxSuggestionCount = in.readInt();
        ArrayList<InlinePresentationSpec> inlinePresentationSpecs = new ArrayList<InlinePresentationSpec>();
        in.readParcelableList(inlinePresentationSpecs, InlinePresentationSpec.class.getClassLoader());
        String hostPackageName = in.readString();
        LocaleList supportedLocales = in.readTypedObject(LocaleList.CREATOR);
        Bundle extras = in.readBundle();
        IBinder hostInputToken = this.unparcelHostInputToken(in);
        int hostDisplayId = in.readInt();
        InlinePresentationSpec inlineTooltipPresentationSpec = (flg & 0x80) == 0 ? null : in.readTypedObject(InlinePresentationSpec.CREATOR);
        this.mMaxSuggestionCount = maxSuggestionCount;
        this.mInlinePresentationSpecs = inlinePresentationSpecs;
        AnnotationValidations.validate(NonNull.class, null, this.mInlinePresentationSpecs);
        this.mHostPackageName = hostPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHostPackageName);
        this.mSupportedLocales = supportedLocales;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSupportedLocales);
        this.mExtras = extras;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExtras);
        this.mHostInputToken = hostInputToken;
        this.mHostDisplayId = hostDisplayId;
        this.mInlineTooltipPresentationSpec = inlineTooltipPresentationSpec;
        this.onConstructed();
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        private int mMaxSuggestionCount;
        @NonNull
        private List<InlinePresentationSpec> mInlinePresentationSpecs;
        @NonNull
        private String mHostPackageName;
        @NonNull
        private LocaleList mSupportedLocales;
        @NonNull
        private Bundle mExtras;
        @Nullable
        private IBinder mHostInputToken;
        private int mHostDisplayId;
        @Nullable
        private InlinePresentationSpec mInlineTooltipPresentationSpec;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull List<InlinePresentationSpec> inlinePresentationSpecs) {
            this.mInlinePresentationSpecs = inlinePresentationSpecs;
            AnnotationValidations.validate(NonNull.class, null, this.mInlinePresentationSpecs);
        }

        @NonNull
        public Builder setMaxSuggestionCount(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mMaxSuggestionCount = value;
            return this;
        }

        @Override
        @NonNull
        public Builder setInlinePresentationSpecs(@NonNull List<InlinePresentationSpec> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mInlinePresentationSpecs = value;
            return this;
        }

        @NonNull
        public Builder addInlinePresentationSpecs(@NonNull InlinePresentationSpec value) {
            if (this.mInlinePresentationSpecs == null) {
                this.setInlinePresentationSpecs(new ArrayList<InlinePresentationSpec>());
            }
            this.mInlinePresentationSpecs.add(value);
            return this;
        }

        @Override
        @NonNull
        Builder setHostPackageName(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mHostPackageName = value;
            return this;
        }

        @NonNull
        public Builder setSupportedLocales(@NonNull LocaleList value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mSupportedLocales = value;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mExtras = value;
            return this;
        }

        @Override
        @NonNull
        Builder setHostInputToken(@NonNull IBinder value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mHostInputToken = value;
            return this;
        }

        @Override
        @NonNull
        Builder setHostDisplayId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mHostDisplayId = value;
            return this;
        }

        @NonNull
        public Builder setInlineTooltipPresentationSpec(@NonNull InlinePresentationSpec value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            this.mInlineTooltipPresentationSpec = value;
            return this;
        }

        @NonNull
        public InlineSuggestionsRequest build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x100L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mMaxSuggestionCount = InlineSuggestionsRequest.defaultMaxSuggestionCount();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mHostPackageName = InlineSuggestionsRequest.defaultHostPackageName();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mSupportedLocales = InlineSuggestionsRequest.defaultSupportedLocales();
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mExtras = InlineSuggestionsRequest.defaultExtras();
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mHostInputToken = InlineSuggestionsRequest.defaultHostInputToken();
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mHostDisplayId = InlineSuggestionsRequest.defaultHostDisplayId();
            }
            if ((this.mBuilderFieldsSet & 0x80L) == 0L) {
                this.mInlineTooltipPresentationSpec = InlineSuggestionsRequest.defaultInlineTooltipPresentationSpec();
            }
            InlineSuggestionsRequest o = new InlineSuggestionsRequest(this.mMaxSuggestionCount, this.mInlinePresentationSpecs, this.mHostPackageName, this.mSupportedLocales, this.mExtras, this.mHostInputToken, this.mHostDisplayId, this.mInlineTooltipPresentationSpec);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x100L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }

        abstract Builder setInlinePresentationSpecs(@NonNull List<InlinePresentationSpec> var1);

        abstract Builder setHostPackageName(@Nullable String var1);

        abstract Builder setHostInputToken(IBinder var1);

        abstract Builder setHostDisplayId(int var1);
    }
}

