/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.HandwritingGesture;
import java.util.Objects;

public class JoinOrSplitGesture
extends HandwritingGesture
implements Parcelable {
    private final PointF mPoint;
    @NonNull
    public static final Parcelable.Creator<JoinOrSplitGesture> CREATOR = new Parcelable.Creator<JoinOrSplitGesture>(){

        @Override
        public JoinOrSplitGesture createFromParcel(Parcel source) {
            return new JoinOrSplitGesture(source);
        }

        public JoinOrSplitGesture[] newArray(int size) {
            return new JoinOrSplitGesture[size];
        }
    };

    private JoinOrSplitGesture(PointF point, String fallbackText) {
        this.mType = 16;
        this.mPoint = point;
        this.mFallbackText = fallbackText;
    }

    private JoinOrSplitGesture(@NonNull Parcel source) {
        this.mType = 16;
        this.mPoint = source.readTypedObject(PointF.CREATOR);
        this.mFallbackText = source.readString8();
    }

    @NonNull
    public PointF getJoinOrSplitPoint() {
        return this.mPoint;
    }

    public int hashCode() {
        return Objects.hash(this.mPoint, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JoinOrSplitGesture)) {
            return false;
        }
        JoinOrSplitGesture that = (JoinOrSplitGesture)o;
        return Objects.equals(this.mPoint, that.mPoint) && Objects.equals(this.mFallbackText, that.mFallbackText);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mPoint, flags);
        dest.writeString8(this.mFallbackText);
    }

    public static class Builder {
        private PointF mPoint;
        private String mFallbackText;

        @NonNull
        public Builder setJoinOrSplitPoint(@NonNull PointF point) {
            this.mPoint = point;
            return this;
        }

        @NonNull
        public Builder setFallbackText(@Nullable String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        @NonNull
        public JoinOrSplitGesture build() {
            if (this.mPoint == null) {
                throw new IllegalArgumentException("Point must be set.");
            }
            return new JoinOrSplitGesture(this.mPoint, this.mFallbackText);
        }
    }
}

