/*
 * Decompiled with CFR 0.152.
 */
package android.view.selectiontoolbar;

import android.annotation.NonNull;
import android.content.Context;
import android.os.RemoteException;
import android.view.selectiontoolbar.ISelectionToolbarCallback;
import android.view.selectiontoolbar.ISelectionToolbarManager;
import android.view.selectiontoolbar.ShowInfo;
import com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags;
import java.util.Objects;

public class SelectionToolbarManager {
    public static final long NO_TOOLBAR_ID = 0L;
    private final ISelectionToolbarManager mService;

    public SelectionToolbarManager(@NonNull ISelectionToolbarManager service) {
        this.mService = service;
    }

    public void showToolbar(@NonNull ShowInfo showInfo, @NonNull ISelectionToolbarCallback callback) {
        try {
            Objects.requireNonNull(showInfo);
            Objects.requireNonNull(callback);
            this.mService.showToolbar(showInfo, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void hideToolbar(long widgetToken) {
        try {
            this.mService.hideToolbar(widgetToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void dismissToolbar(long widgetToken) {
        try {
            this.mService.dismissToolbar(widgetToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean isRemoteSelectionToolbarEnabled() {
        return Flags.systemSelectionToolbarEnabled();
    }

    public static boolean isRemoteSelectionToolbarEnabled(Context context) {
        SelectionToolbarManager manager = context.getSystemService(SelectionToolbarManager.class);
        if (manager != null) {
            return manager.isRemoteSelectionToolbarEnabled();
        }
        return false;
    }
}

