/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.icu.util.ULocale;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.SystemTextClassifierMetadata;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TextLanguage
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<TextLanguage> CREATOR = new Parcelable.Creator<TextLanguage>(){

        @Override
        public TextLanguage createFromParcel(Parcel in) {
            return TextLanguage.readFromParcel(in);
        }

        public TextLanguage[] newArray(int size) {
            return new TextLanguage[size];
        }
    };
    static final TextLanguage EMPTY = new Builder().build();
    @Nullable
    private final String mId;
    private final EntityConfidence mEntityConfidence;
    private final Bundle mBundle;

    private TextLanguage(@Nullable String id2, EntityConfidence entityConfidence, Bundle bundle) {
        this.mId = id2;
        this.mEntityConfidence = entityConfidence;
        this.mBundle = bundle;
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    public int getLocaleHypothesisCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    @NonNull
    public ULocale getLocale(int index) {
        return ULocale.forLanguageTag(this.mEntityConfidence.getEntities().get(index));
    }

    public float getConfidenceScore(@NonNull ULocale locale) {
        return this.mEntityConfidence.getConfidenceScore(locale.toLanguageTag());
    }

    @NonNull
    public Bundle getExtras() {
        return this.mBundle;
    }

    public String toString() {
        return String.format(Locale.US, "TextLanguage {id=%s, locales=%s, bundle=%s}", this.mId, this.mEntityConfidence, this.mBundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeBundle(this.mBundle);
    }

    private static TextLanguage readFromParcel(Parcel in) {
        return new TextLanguage(in.readString(), EntityConfidence.CREATOR.createFromParcel(in), in.readBundle());
    }

    public static class Builder {
        @Nullable
        private String mId;
        private final Map<String, Float> mEntityConfidenceMap = new ArrayMap<String, Float>();
        @Nullable
        private Bundle mBundle;

        @NonNull
        public Builder putLocale(@NonNull ULocale locale, float confidenceScore) {
            Objects.requireNonNull(locale);
            this.mEntityConfidenceMap.put(locale.toLanguageTag(), Float.valueOf(confidenceScore));
            return this;
        }

        @NonNull
        public Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle bundle) {
            this.mBundle = Objects.requireNonNull(bundle);
            return this;
        }

        @NonNull
        public TextLanguage build() {
            this.mBundle = this.mBundle == null ? Bundle.EMPTY : this.mBundle;
            return new TextLanguage(this.mId, new EntityConfidence(this.mEntityConfidenceMap), this.mBundle);
        }
    }

    public static class Request
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };
        private final CharSequence mText;
        private final Bundle mExtra;
        @Nullable
        private SystemTextClassifierMetadata mSystemTcMetadata;

        private Request(CharSequence text, Bundle bundle) {
            this.mText = text;
            this.mExtra = bundle;
        }

        @NonNull
        public CharSequence getText() {
            return this.mText;
        }

        @Nullable
        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void setSystemTextClassifierMetadata(@Nullable SystemTextClassifierMetadata systemTcMetadata) {
            this.mSystemTcMetadata = systemTcMetadata;
        }

        @Nullable
        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtra;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeCharSequence(this.mText);
            dest.writeBundle(this.mExtra);
            dest.writeParcelable(this.mSystemTcMetadata, flags);
        }

        private static Request readFromParcel(Parcel in) {
            CharSequence text = in.readCharSequence();
            Bundle extra = in.readBundle();
            SystemTextClassifierMetadata systemTcMetadata = in.readParcelable(null, SystemTextClassifierMetadata.class);
            Request request = new Request(text, extra);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        public static class Builder {
            private final CharSequence mText;
            @Nullable
            private Bundle mBundle;

            public Builder(@NonNull CharSequence text) {
                this.mText = Objects.requireNonNull(text);
            }

            @NonNull
            public Builder setExtras(@NonNull Bundle bundle) {
                this.mBundle = Objects.requireNonNull(bundle);
                return this;
            }

            @NonNull
            public Request build() {
                return new Request(this.mText.toString(), this.mBundle == null ? Bundle.EMPTY : this.mBundle);
            }
        }
    }
}

