/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import android.widget.ThemedSpinnerAdapter;
import com.android.internal.hidden_from_bootclasspath.android.widget.flags.Flags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ArrayAdapter<T>
extends BaseAdapter
implements Filterable,
ThemedSpinnerAdapter {
    @UnsupportedAppUsage
    private final Object mLock = new Object();
    private final LayoutInflater mInflater;
    private final Context mContext;
    private final int mResource;
    private int mDropDownResource;
    @UnsupportedAppUsage
    private List<T> mObjects;
    private boolean mObjectsFromResources;
    private int mFieldId = 0;
    private boolean mNotifyOnChange = true;
    @UnsupportedAppUsage
    private ArrayList<T> mOriginalValues;
    private ArrayFilter mFilter;
    private LayoutInflater mDropDownInflater;
    private static final boolean sBoostCpuLoadFlag = Flags.boostCpuLoadForLongTextRendering();
    private static final int BOOST_CPU_TEXT_LENGTH_THRESHOLD = 500;

    public ArrayAdapter(@NonNull Context context, int resource) {
        this(context, resource, 0, new ArrayList());
    }

    public ArrayAdapter(@NonNull Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList());
    }

    public ArrayAdapter(@NonNull Context context, int resource, @NonNull T[] objects) {
        this(context, resource, 0, Arrays.asList(objects));
    }

    public ArrayAdapter(@NonNull Context context, int resource, int textViewResourceId, @NonNull T[] objects) {
        this(context, resource, textViewResourceId, Arrays.asList(objects));
    }

    public ArrayAdapter(@NonNull Context context, int resource, @NonNull List<T> objects) {
        this(context, resource, 0, objects);
    }

    public ArrayAdapter(@NonNull Context context, int resource, int textViewResourceId, @NonNull List<T> objects) {
        this(context, resource, textViewResourceId, objects, false);
    }

    private ArrayAdapter(@NonNull Context context, int resource, int textViewResourceId, @NonNull List<T> objects, boolean objsFromResources) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from(context);
        this.mResource = this.mDropDownResource = resource;
        this.mObjects = objects;
        this.mObjectsFromResources = objsFromResources;
        this.mFieldId = textViewResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@Nullable T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(object);
            } else {
                this.mObjects.add(object);
            }
            this.mObjectsFromResources = false;
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@NonNull Collection<? extends T> collection) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.addAll(collection);
            } else {
                this.mObjects.addAll(collection);
            }
            this.mObjectsFromResources = false;
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(T ... items) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                Collections.addAll(this.mOriginalValues, items);
            } else {
                Collections.addAll(this.mObjects, items);
            }
            this.mObjectsFromResources = false;
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@Nullable T object, int index) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(index, object);
            } else {
                this.mObjects.add(index, object);
            }
            this.mObjectsFromResources = false;
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nullable T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.remove(object);
            } else {
                this.mObjects.remove(object);
            }
            this.mObjectsFromResources = false;
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.clear();
            } else {
                this.mObjects.clear();
            }
            this.mObjectsFromResources = false;
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@NonNull Comparator<? super T> comparator) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                Collections.sort(this.mOriginalValues, comparator);
            } else {
                Collections.sort(this.mObjects, comparator);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNotifyOnChange = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.mNotifyOnChange = notifyOnChange;
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public int getCount() {
        return this.mObjects.size();
    }

    @Nullable
    public T getItem(int position) {
        return this.mObjects.get(position);
    }

    public int getPosition(@Nullable T item) {
        return this.mObjects.indexOf(item);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return this.createViewFromResource(this.mInflater, position, convertView, parent, this.mResource);
    }

    @NonNull
    private View createViewFromResource(@NonNull LayoutInflater inflater, int position, @Nullable View convertView, @NonNull ViewGroup parent, int resource) {
        CharSequence textContent;
        int textLength;
        TextView text;
        View view = convertView == null ? inflater.inflate(resource, parent, false) : convertView;
        try {
            if (this.mFieldId == 0) {
                text = (TextView)view;
            } else {
                text = (TextView)view.findViewById(this.mFieldId);
                if (text == null) {
                    throw new RuntimeException("Failed to find view with ID " + this.mContext.getResources().getResourceName(this.mFieldId) + " in item layout");
                }
            }
        }
        catch (ClassCastException e) {
            Log.e("ArrayAdapter", "You must supply a resource ID for a TextView");
            throw new IllegalStateException("ArrayAdapter requires the resource ID to be a TextView", e);
        }
        T item = this.getItem(position);
        if (item instanceof CharSequence) {
            textLength = ((CharSequence)item).length();
            textContent = (CharSequence)item;
        } else {
            textLength = item.toString() == null ? 0 : item.toString().length();
            textContent = item.toString();
        }
        if (sBoostCpuLoadFlag && parent.isAttachedToWindow() && textLength > 500) {
            parent.getViewRootImpl().notifyRendererOfExpensiveFrame("ADPF_SendHint: Expensive text rendering");
        }
        text.setText(textContent);
        return view;
    }

    public void setDropDownViewResource(int resource) {
        this.mDropDownResource = resource;
    }

    @Override
    public void setDropDownViewTheme(@Nullable Resources.Theme theme) {
        if (theme == null) {
            this.mDropDownInflater = null;
        } else if (theme == this.mInflater.getContext().getTheme()) {
            this.mDropDownInflater = this.mInflater;
        } else {
            ContextThemeWrapper context = new ContextThemeWrapper(this.mContext, theme);
            this.mDropDownInflater = LayoutInflater.from(context);
        }
    }

    @Override
    @Nullable
    public Resources.Theme getDropDownViewTheme() {
        return this.mDropDownInflater == null ? null : this.mDropDownInflater.getContext().getTheme();
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater inflater = this.mDropDownInflater == null ? this.mInflater : this.mDropDownInflater;
        return this.createViewFromResource(inflater, position, convertView, parent, this.mDropDownResource);
    }

    @NonNull
    public static ArrayAdapter<CharSequence> createFromResource(@NonNull Context context, int textArrayResId, int textViewResId) {
        CharSequence[] strings = context.getResources().getTextArray(textArrayResId);
        return new ArrayAdapter<CharSequence>(context, textViewResId, 0, Arrays.asList(strings), true);
    }

    @Override
    @NonNull
    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    @Override
    public CharSequence[] getAutofillOptions() {
        CharSequence[] explicitOptions = super.getAutofillOptions();
        if (explicitOptions != null) {
            return explicitOptions;
        }
        if (!this.mObjectsFromResources || this.mObjects == null || this.mObjects.isEmpty()) {
            return null;
        }
        int size = this.mObjects.size();
        CharSequence[] options = new CharSequence[size];
        this.mObjects.toArray(options);
        return options;
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (ArrayAdapter.this.mOriginalValues == null) {
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    ArrayAdapter.this.mOriginalValues = new ArrayList(ArrayAdapter.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                ArrayList list;
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    list = new ArrayList(ArrayAdapter.this.mOriginalValues);
                }
                results.values = list;
                results.count = list.size();
            } else {
                ArrayList values;
                String prefixString = prefix.toString().toLowerCase();
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    values = new ArrayList(ArrayAdapter.this.mOriginalValues);
                }
                int count = values.size();
                ArrayList newValues = new ArrayList();
                block9: for (int i = 0; i < count; ++i) {
                    String[] words;
                    Object value = values.get(i);
                    String valueText = value.toString().toLowerCase();
                    if (valueText.startsWith(prefixString)) {
                        newValues.add(value);
                        continue;
                    }
                    for (String word : words = valueText.split(" ")) {
                        if (!word.startsWith(prefixString)) continue;
                        newValues.add(value);
                        continue block9;
                    }
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        @Override
        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                ArrayAdapter.this.notifyDataSetChanged();
            } else {
                ArrayAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

