/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ValueAnimator;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.util.AttributeSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class EdgeEffect {
    public static final long USE_STRETCH_EDGE_EFFECT_BY_DEFAULT = 171228096L;
    public static final BlendMode DEFAULT_BLEND_MODE = BlendMode.SRC_ATOP;
    private static final int TYPE_NONE = -1;
    private static final int TYPE_GLOW = 0;
    private static final int TYPE_STRETCH = 1;
    private static final double VELOCITY_THRESHOLD = 0.01;
    private static final float LINEAR_VELOCITY_TAKE_OVER = 200.0f;
    private static final double VALUE_THRESHOLD = 0.001;
    private static final double LINEAR_DISTANCE_TAKE_OVER = 8.0;
    private static final double NATURAL_FREQUENCY = 24.657;
    private static final double DAMPING_RATIO = 0.98;
    private static final float ON_ABSORB_VELOCITY_ADJUSTMENT = 13.0f;
    private static final float LINEAR_STRETCH_INTENSITY = 0.016f;
    private static final float EXP_STRETCH_INTENSITY = 0.016f;
    private static final float SCROLL_DIST_AFFECTED_BY_EXP_STRETCH = 0.33f;
    private static final String TAG = "EdgeEffect";
    private static final int RECEDE_TIME = 600;
    private static final int PULL_TIME = 167;
    private static final int PULL_DECAY_TIME = 2000;
    private static final float MAX_ALPHA = 0.15f;
    private static final float GLOW_ALPHA_START = 0.09f;
    private static final float MAX_GLOW_SCALE = 2.0f;
    private static final float PULL_GLOW_BEGIN = 0.0f;
    private static final int MIN_VELOCITY = 100;
    private static final int MAX_VELOCITY = 10000;
    private static final float EPSILON = 0.001f;
    private static final double ANGLE = 0.5235987755982988;
    private static final float SIN = (float)Math.sin(0.5235987755982988);
    private static final float COS = (float)Math.cos(0.5235987755982988);
    private static final float RADIUS_FACTOR = 0.6f;
    private float mGlowAlpha;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mGlowScaleY;
    private float mDistance;
    private float mVelocity;
    private float mGlowAlphaStart;
    private float mGlowAlphaFinish;
    private float mGlowScaleYStart;
    private float mGlowScaleYFinish;
    private long mStartTime;
    private float mDuration;
    private final Interpolator mInterpolator = new DecelerateInterpolator();
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_ABSORB = 2;
    private static final int STATE_RECEDE = 3;
    private static final int STATE_PULL_DECAY = 4;
    private static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static final int VELOCITY_GLOW_FACTOR = 6;
    private int mState = 0;
    private float mPullDistance;
    private final Rect mBounds = new Rect();
    private float mWidth;
    private float mHeight;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769450L)
    private final Paint mPaint = new Paint();
    private float mRadius;
    private float mBaseGlowScale;
    private float mDisplacement = 0.5f;
    private float mTargetDisplacement = 0.5f;
    private int mEdgeEffectType = 0;
    private Matrix mTmpMatrix = null;
    private float[] mTmpPoints = null;

    public EdgeEffect(Context context) {
        this(context, null);
    }

    public EdgeEffect(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EdgeEffect);
        int themeColor = a.getColor(0, -10066330);
        this.mEdgeEffectType = Compatibility.isChangeEnabled(171228096L) ? 1 : 0;
        a.recycle();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(themeColor & 0xFFFFFF | 0x33000000);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setBlendMode(DEFAULT_BLEND_MODE);
    }

    private int getCurrentEdgeEffectBehavior() {
        if (!ValueAnimator.areAnimatorsEnabled()) {
            return -1;
        }
        return this.mEdgeEffectType;
    }

    public void setSize(int width, int height) {
        float r = (float)width * 0.6f / SIN;
        float y = COS * r;
        float h = r - y;
        float or = (float)height * 0.6f / SIN;
        float oy = COS * or;
        float oh = or - oy;
        this.mRadius = r;
        this.mBaseGlowScale = h > 0.0f ? Math.min(oh / h, 1.0f) : 1.0f;
        this.mBounds.set(this.mBounds.left, this.mBounds.top, width, (int)Math.min((float)height, h));
        this.mWidth = width;
        this.mHeight = height;
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public void finish() {
        this.mState = 0;
        this.mDistance = 0.0f;
        this.mVelocity = 0.0f;
    }

    public void onPull(float deltaDistance) {
        this.onPull(deltaDistance, 0.5f);
    }

    public void onPull(float deltaDistance, float displacement) {
        int edgeEffectBehavior = this.getCurrentEdgeEffectBehavior();
        if (edgeEffectBehavior == -1) {
            this.finish();
            return;
        }
        long now = AnimationUtils.currentAnimationTimeMillis();
        this.mTargetDisplacement = displacement;
        if (this.mState == 4 && (float)(now - this.mStartTime) < this.mDuration && edgeEffectBehavior == 0) {
            return;
        }
        if (this.mState != 1) {
            if (edgeEffectBehavior == 1) {
                this.mPullDistance = this.mDistance;
            } else {
                this.mGlowScaleY = Math.max(0.0f, this.mGlowScaleY);
            }
        }
        this.mState = 1;
        this.mStartTime = now;
        this.mDuration = 167.0f;
        this.mPullDistance += deltaDistance;
        if (edgeEffectBehavior == 1) {
            this.mPullDistance = Math.min(1.0f, this.mPullDistance);
        }
        this.mDistance = Math.max(0.0f, this.mPullDistance);
        this.mVelocity = 0.0f;
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleYStart = 0.0f;
            this.mGlowScaleY = 0.0f;
            this.mGlowAlphaStart = 0.0f;
            this.mGlowAlpha = 0.0f;
        } else {
            float scale;
            float absdd = Math.abs(deltaDistance);
            this.mGlowAlpha = this.mGlowAlphaStart = Math.min(0.15f, this.mGlowAlpha + absdd * 0.8f);
            this.mGlowScaleY = this.mGlowScaleYStart = (scale = (float)(Math.max(0.0, 1.0 - 1.0 / Math.sqrt(Math.abs(this.mPullDistance) * (float)this.mBounds.height()) - 0.3) / 0.7));
        }
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
        if (edgeEffectBehavior == 1 && this.mDistance == 0.0f) {
            this.mState = 0;
        }
    }

    public float onPullDistance(float deltaDistance, float displacement) {
        int edgeEffectBehavior = this.getCurrentEdgeEffectBehavior();
        if (edgeEffectBehavior == -1) {
            return 0.0f;
        }
        float finalDistance = Math.max(0.0f, deltaDistance + this.mDistance);
        float delta = finalDistance - this.mDistance;
        if (delta == 0.0f && this.mDistance == 0.0f) {
            return 0.0f;
        }
        if (this.mState != 1 && this.mState != 4 && edgeEffectBehavior == 0) {
            this.mPullDistance = this.mDistance;
            this.mState = 1;
        }
        this.onPull(delta, displacement);
        return delta;
    }

    public float getDistance() {
        return this.mDistance;
    }

    public void onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mVelocity = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 600.0f;
    }

    public void onAbsorb(int velocity) {
        int edgeEffectBehavior = this.getCurrentEdgeEffectBehavior();
        if (edgeEffectBehavior == 1) {
            this.mState = 3;
            this.mVelocity = (float)velocity * 13.0f;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        } else if (edgeEffectBehavior == 0) {
            this.mState = 2;
            this.mVelocity = 0.0f;
            velocity = Math.min(Math.max(100, Math.abs(velocity)), 10000);
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = 0.15f + (float)velocity * 0.02f;
            this.mGlowAlphaStart = 0.09f;
            this.mGlowScaleYStart = Math.max(this.mGlowScaleY, 0.0f);
            this.mGlowScaleYFinish = Math.min(0.025f + (float)(velocity * (velocity / 100)) * 1.5E-4f / 2.0f, 1.0f);
            this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min((float)(velocity * 6) * 1.0E-5f, 0.15f));
            this.mTargetDisplacement = 0.5f;
        } else {
            this.finish();
        }
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void setBlendMode(@Nullable BlendMode blendmode) {
        this.mPaint.setBlendMode(blendmode);
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    @Nullable
    public BlendMode getBlendMode() {
        return this.mPaint.getBlendMode();
    }

    public boolean draw(Canvas canvas) {
        int edgeEffectBehavior = this.getCurrentEdgeEffectBehavior();
        if (edgeEffectBehavior == 0) {
            this.update();
            int count = canvas.save();
            float centerX = this.mBounds.centerX();
            float centerY = (float)this.mBounds.height() - this.mRadius;
            canvas.scale(1.0f, Math.min(this.mGlowScaleY, 1.0f) * this.mBaseGlowScale, centerX, 0.0f);
            float displacement = Math.max(0.0f, Math.min(this.mDisplacement, 1.0f)) - 0.5f;
            float translateX = (float)this.mBounds.width() * displacement / 2.0f;
            canvas.clipRect(this.mBounds);
            canvas.translate(translateX, 0.0f);
            this.mPaint.setAlpha((int)(255.0f * this.mGlowAlpha));
            canvas.drawCircle(centerX, centerY, this.mRadius, this.mPaint);
            canvas.restoreToCount(count);
        } else if (edgeEffectBehavior == 1 && canvas instanceof RecordingCanvas) {
            if (this.mState == 3) {
                this.updateSpring();
            }
            if (this.mDistance != 0.0f) {
                boolean hasValidVectors;
                RecordingCanvas recordingCanvas = (RecordingCanvas)canvas;
                if (this.mTmpMatrix == null) {
                    this.mTmpMatrix = new Matrix();
                    this.mTmpPoints = new float[12];
                }
                recordingCanvas.getMatrix(this.mTmpMatrix);
                this.mTmpPoints[0] = 0.0f;
                this.mTmpPoints[1] = 0.0f;
                this.mTmpPoints[2] = this.mWidth;
                this.mTmpPoints[3] = 0.0f;
                this.mTmpPoints[4] = this.mWidth;
                this.mTmpPoints[5] = this.mHeight;
                this.mTmpPoints[6] = 0.0f;
                this.mTmpPoints[7] = this.mHeight;
                this.mTmpPoints[8] = this.mWidth * this.mDisplacement;
                this.mTmpPoints[9] = 0.0f;
                this.mTmpPoints[10] = this.mWidth * this.mDisplacement;
                this.mTmpPoints[11] = this.mHeight * this.mDistance;
                this.mTmpMatrix.mapPoints(this.mTmpPoints);
                RenderNode renderNode = recordingCanvas.mNode;
                float left = (float)renderNode.getLeft() + this.min(this.mTmpPoints[0], this.mTmpPoints[2], this.mTmpPoints[4], this.mTmpPoints[6]);
                float top = (float)renderNode.getTop() + this.min(this.mTmpPoints[1], this.mTmpPoints[3], this.mTmpPoints[5], this.mTmpPoints[7]);
                float right = (float)renderNode.getLeft() + this.max(this.mTmpPoints[0], this.mTmpPoints[2], this.mTmpPoints[4], this.mTmpPoints[6]);
                float bottom = (float)renderNode.getTop() + this.max(this.mTmpPoints[1], this.mTmpPoints[3], this.mTmpPoints[5], this.mTmpPoints[7]);
                float x = this.mTmpPoints[10] - this.mTmpPoints[8];
                float width = right - left;
                float vecX = this.dampStretchVector(Math.max(-1.0f, Math.min(1.0f, x / width)));
                float y = this.mTmpPoints[11] - this.mTmpPoints[9];
                float height = bottom - top;
                float vecY = this.dampStretchVector(Math.max(-1.0f, Math.min(1.0f, y / height)));
                boolean bl = hasValidVectors = Float.isFinite(vecX) && Float.isFinite(vecY);
                if (right > left && bottom > top && this.mWidth > 0.0f && this.mHeight > 0.0f && hasValidVectors) {
                    renderNode.stretch(vecX, vecY, this.mWidth, this.mHeight);
                }
            }
        } else {
            this.mState = 0;
            this.mDistance = 0.0f;
            this.mVelocity = 0.0f;
        }
        boolean oneLastFrame = false;
        if (this.mState == 3 && this.mDistance == 0.0f && this.mVelocity == 0.0f) {
            this.mState = 0;
            oneLastFrame = true;
        }
        return this.mState != 0 || oneLastFrame;
    }

    private float min(float f1, float f2, float f3, float f4) {
        float min = Math.min(f1, f2);
        min = Math.min(min, f3);
        return Math.min(min, f4);
    }

    private float max(float f1, float f2, float f3, float f4) {
        float max = Math.max(f1, f2);
        max = Math.max(max, f3);
        return Math.max(max, f4);
    }

    public int getMaxHeight() {
        return (int)this.mHeight;
    }

    private void update() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(time - this.mStartTime) / this.mDuration, 1.0f);
        float interp = this.mInterpolator.getInterpolation(t);
        this.mGlowAlpha = this.mGlowAlphaStart + (this.mGlowAlphaFinish - this.mGlowAlphaStart) * interp;
        this.mGlowScaleY = this.mGlowScaleYStart + (this.mGlowScaleYFinish - this.mGlowScaleYStart) * interp;
        if (this.mState != 1) {
            this.mDistance = this.calculateDistanceFromGlowValues(this.mGlowScaleY, this.mGlowAlpha);
        }
        this.mDisplacement = (this.mDisplacement + this.mTargetDisplacement) / 2.0f;
        if (t >= 0.999f) {
            switch (this.mState) {
                case 2: {
                    this.mState = 3;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 600.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 1: {
                    this.mState = 4;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 2000.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 4: {
                    this.mState = 3;
                    break;
                }
                case 3: {
                    this.mState = 0;
                }
            }
        }
    }

    private void updateSpring() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float deltaT = (float)(time - this.mStartTime) / 1000.0f;
        if (deltaT < 0.001f) {
            return;
        }
        this.mStartTime = time;
        if (Math.abs(this.mVelocity) <= 200.0f && (double)Math.abs(this.mDistance * this.mHeight) < 8.0 && Math.signum(this.mVelocity) == -Math.signum(this.mDistance)) {
            this.mVelocity = Math.signum(this.mVelocity) * 200.0f;
            float targetDistance = this.mDistance + this.mVelocity * deltaT / this.mHeight;
            if (Math.signum(targetDistance) != Math.signum(this.mDistance)) {
                this.mDistance = 0.0f;
                this.mVelocity = 0.0f;
            } else {
                this.mDistance = targetDistance;
            }
            return;
        }
        double mDampedFreq = 24.657 * Math.sqrt(0.03960000000000008);
        double cosCoeff = this.mDistance * this.mHeight;
        double sinCoeff = 1.0 / mDampedFreq * (24.16386 * (double)this.mDistance * (double)this.mHeight + (double)this.mVelocity);
        double distance = Math.pow(Math.E, -24.16386 * (double)deltaT) * (cosCoeff * Math.cos(mDampedFreq * (double)deltaT) + sinCoeff * Math.sin(mDampedFreq * (double)deltaT));
        double velocity = distance * -24.657 * 0.98 + Math.pow(Math.E, -24.16386 * (double)deltaT) * (-mDampedFreq * cosCoeff * Math.sin(mDampedFreq * (double)deltaT) + mDampedFreq * sinCoeff * Math.cos(mDampedFreq * (double)deltaT));
        this.mDistance = (float)distance / this.mHeight;
        this.mVelocity = (float)velocity;
        if (this.mDistance > 1.0f) {
            this.mDistance = 1.0f;
            this.mVelocity = 0.0f;
        }
        if (this.isAtEquilibrium()) {
            this.mDistance = 0.0f;
            this.mVelocity = 0.0f;
        }
    }

    private float calculateDistanceFromGlowValues(float scale, float alpha) {
        if (scale >= 1.0f) {
            return 1.0f;
        }
        if (scale > 0.0f) {
            float v = 1.4285715f / (this.mGlowScaleY - 1.0f);
            return v * v / (float)this.mBounds.height();
        }
        return alpha / 0.8f;
    }

    private boolean isAtEquilibrium() {
        double displacement = this.mDistance * this.mHeight;
        double velocity = this.mVelocity;
        return displacement < 0.0 || Math.abs(velocity) < 0.01 && displacement < 0.001;
    }

    private float dampStretchVector(float normalizedVec) {
        float sign = normalizedVec > 0.0f ? 1.0f : -1.0f;
        float overscroll = Math.abs(normalizedVec);
        float linearIntensity = 0.016f * overscroll;
        double scalar = 8.237217334679498;
        double expIntensity = (double)0.016f * (1.0 - Math.exp((double)(-overscroll) * scalar));
        return sign * (float)((double)linearIntensity + expIntensity);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EdgeEffectType {
    }
}

