/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.app.ITransientNotificationCallback;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.view.accessibility.IAccessibilityManager;
import android.widget.TextView;
import android.widget.ToastPresenter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Toast {
    static final String TAG = "Toast";
    static final boolean localLOGV = false;
    public static final int LENGTH_SHORT = 0;
    public static final int LENGTH_LONG = 1;
    private static final long CHANGE_TEXT_TOASTS_IN_THE_SYSTEM = 147798919L;
    private final Binder mToken;
    private final Context mContext;
    private final Handler mHandler;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final TN mTN;
    @UnsupportedAppUsage
    int mDuration;
    @GuardedBy(value={"mCallbacks"})
    private final List<Callback> mCallbacks;
    @Nullable
    private View mNextView;
    @Nullable
    private CharSequence mText;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static INotificationManager sService;

    public Toast(Context context) {
        this(context, null);
    }

    public Toast(@NonNull Context context, @Nullable Looper looper) {
        this.mContext = context;
        this.mToken = new Binder();
        looper = this.getLooper(looper);
        this.mHandler = new Handler(looper);
        this.mCallbacks = new ArrayList<Callback>();
        this.mTN = new TN(context, context.getPackageName(), this.mToken, this.mCallbacks, looper);
        this.mTN.mY = context.getResources().getDimensionPixelSize(17105828);
        this.mTN.mGravity = context.getResources().getInteger(17695057);
    }

    private Looper getLooper(@Nullable Looper looper) {
        if (looper != null) {
            return looper;
        }
        return Preconditions.checkNotNull(Looper.myLooper(), "Can't toast on a thread that has not called Looper.prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        if (Compatibility.isChangeEnabled(147798919L)) {
            Preconditions.checkState(this.mNextView != null || this.mText != null, "You must either set a text or a view");
        } else if (this.mNextView == null) {
            throw new RuntimeException("setView must have been called");
        }
        INotificationManager service = Toast.getService();
        String pkg = this.mContext.getOpPackageName();
        TN tn = this.mTN;
        tn.mNextView = this.mNextView;
        boolean isUiContext = this.mContext.isUiContext();
        int displayId = this.mContext.getDisplayId();
        boolean wasEnqueued = false;
        try {
            if (Compatibility.isChangeEnabled(147798919L)) {
                if (this.mNextView != null) {
                    wasEnqueued = service.enqueueToast(pkg, this.mToken, tn, this.mDuration, isUiContext, displayId);
                } else {
                    CallbackBinder callback = new CallbackBinder(this.mCallbacks, this.mHandler);
                    wasEnqueued = service.enqueueTextToast(pkg, this.mToken, this.mText, this.mDuration, isUiContext, displayId, callback);
                }
            } else {
                wasEnqueued = service.enqueueToast(pkg, this.mToken, tn, this.mDuration, isUiContext, displayId);
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            if (!wasEnqueued) {
                tn.mNextViewWeakRef = null;
                tn.mNextView = null;
            }
        }
    }

    public void cancel() {
        if (Compatibility.isChangeEnabled(147798919L) && this.mNextView == null) {
            try {
                Toast.getService().cancelToast(this.mContext.getOpPackageName(), this.mToken);
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mTN.cancel();
        }
    }

    @Deprecated
    public void setView(View view) {
        this.mNextView = view;
    }

    @Deprecated
    @Nullable
    public View getView() {
        return this.mNextView;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        this.mTN.mDuration = duration;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setMargin(float horizontalMargin, float verticalMargin) {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "setMargin() shouldn't be called on text toasts, the values won't be used");
        }
        this.mTN.mHorizontalMargin = horizontalMargin;
        this.mTN.mVerticalMargin = verticalMargin;
    }

    public float getHorizontalMargin() {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "getHorizontalMargin() shouldn't be called on text toasts, the result may not reflect actual values.");
        }
        return this.mTN.mHorizontalMargin;
    }

    public float getVerticalMargin() {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "getVerticalMargin() shouldn't be called on text toasts, the result may not reflect actual values.");
        }
        return this.mTN.mVerticalMargin;
    }

    public void setGravity(int gravity, int xOffset, int yOffset) {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "setGravity() shouldn't be called on text toasts, the values won't be used");
        }
        this.mTN.mGravity = gravity;
        this.mTN.mX = xOffset;
        this.mTN.mY = yOffset;
    }

    public int getGravity() {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "getGravity() shouldn't be called on text toasts, the result may not reflect actual values.");
        }
        return this.mTN.mGravity;
    }

    public int getXOffset() {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "getXOffset() shouldn't be called on text toasts, the result may not reflect actual values.");
        }
        return this.mTN.mX;
    }

    public int getYOffset() {
        if (this.isSystemRenderedTextToast()) {
            Log.e(TAG, "getYOffset() shouldn't be called on text toasts, the result may not reflect actual values.");
        }
        return this.mTN.mY;
    }

    private boolean isSystemRenderedTextToast() {
        return Compatibility.isChangeEnabled(147798919L) && this.mNextView == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(@NonNull Callback callback) {
        Preconditions.checkNotNull(callback);
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(@NonNull Callback callback) {
        List<Callback> list = this.mCallbacks;
        synchronized (list) {
            this.mCallbacks.remove(callback);
        }
    }

    @UnsupportedAppUsage
    @Nullable
    public WindowManager.LayoutParams getWindowParams() {
        if (Compatibility.isChangeEnabled(147798919L)) {
            if (this.mNextView != null) {
                return this.mTN.mParams;
            }
            return null;
        }
        return this.mTN.mParams;
    }

    public static Toast makeText(Context context, CharSequence text, int duration) {
        return Toast.makeText(context, null, text, duration);
    }

    public static Toast makeText(@NonNull Context context, @Nullable Looper looper, @NonNull CharSequence text, int duration) {
        Toast result = new Toast(context, looper);
        if (Compatibility.isChangeEnabled(147798919L)) {
            result.mText = text;
        } else {
            result.mNextView = ToastPresenter.getTextToastView(context, text);
        }
        result.mDuration = duration;
        return result;
    }

    public static Toast makeCustomToastWithIcon(@NonNull Context context, @Nullable Looper looper, @NonNull CharSequence text, int duration, @NonNull Drawable icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Drawable icon should not be null for makeCustomToastWithIcon");
        }
        Toast result = new Toast(context, looper);
        result.mNextView = ToastPresenter.getTextToastViewWithIcon(context, text, icon);
        result.mDuration = duration;
        return result;
    }

    public static Toast makeText(Context context, int resId, int duration) throws Resources.NotFoundException {
        return Toast.makeText(context, context.getResources().getText(resId), duration);
    }

    public void setText(int resId) {
        this.setText(this.mContext.getText(resId));
    }

    public void setText(CharSequence s) {
        if (Compatibility.isChangeEnabled(147798919L)) {
            if (this.mNextView != null) {
                throw new IllegalStateException("Text provided for custom toast, remove previous setView() calls if you want a text toast instead.");
            }
            this.mText = s;
        } else {
            if (this.mNextView == null) {
                throw new RuntimeException("This Toast was not created with Toast.makeText()");
            }
            TextView tv = (TextView)this.mNextView.findViewById(16908299);
            if (tv == null) {
                throw new RuntimeException("This Toast was not created with Toast.makeText()");
            }
            tv.setText(s);
        }
    }

    @VisibleForTesting
    public TN getTn() {
        return this.mTN;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    private static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        sService = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        return sService;
    }

    @VisibleForTesting
    public static class TN
    extends ITransientNotification.Stub {
        @UnsupportedAppUsage(maxTargetSdk=28)
        private final WindowManager.LayoutParams mParams;
        private static final int SHOW = 0;
        private static final int HIDE = 1;
        private static final int CANCEL = 2;
        final Handler mHandler;
        @UnsupportedAppUsage(maxTargetSdk=28)
        int mGravity;
        int mX;
        @UnsupportedAppUsage(maxTargetSdk=28)
        int mY;
        float mHorizontalMargin;
        float mVerticalMargin;
        @UnsupportedAppUsage(maxTargetSdk=28)
        View mView;
        @UnsupportedAppUsage(maxTargetSdk=28)
        WeakReference<View> mNextViewWeakRef;
        @UnsupportedAppUsage(maxTargetSdk=28)
        View mNextView;
        int mDuration;
        WindowManager mWM;
        final String mPackageName;
        final Binder mToken;
        private final ToastPresenter mPresenter;
        @GuardedBy(value={"mCallbacks"})
        private final WeakReference<List<Callback>> mCallbacks;

        TN(Context context, String packageName, Binder token, List<Callback> callbacks, @Nullable Looper looper) {
            IAccessibilityManager accessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
            this.mPresenter = new ToastPresenter(context, accessibilityManager, Toast.getService(), packageName);
            this.mParams = this.mPresenter.getLayoutParams();
            this.mPackageName = packageName;
            this.mToken = token;
            this.mCallbacks = new WeakReference<List<Callback>>(callbacks);
            this.mHandler = new Handler(looper, null){

                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            IBinder token = (IBinder)msg.obj;
                            this.handleShow(token);
                            break;
                        }
                        case 1: {
                            this.handleHide();
                            mNextView = null;
                            break;
                        }
                        case 2: {
                            this.handleHide();
                            mNextView = null;
                            try {
                                Toast.getService().cancelToast(mPackageName, mToken);
                                break;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Callback> getCallbacks() {
            WeakReference<List<Callback>> weakReference = this.mCallbacks;
            synchronized (weakReference) {
                if (this.mCallbacks.get() != null) {
                    return new ArrayList<Callback>((Collection)this.mCallbacks.get());
                }
                return new ArrayList<Callback>();
            }
        }

        @Override
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public void show(IBinder windowToken) {
            this.mHandler.obtainMessage(0, windowToken).sendToTarget();
        }

        @Override
        public void hide() {
            this.mHandler.obtainMessage(1).sendToTarget();
        }

        public void cancel() {
            this.mHandler.obtainMessage(2).sendToTarget();
        }

        public void handleShow(IBinder windowToken) {
            if (this.mHandler.hasMessages(2) || this.mHandler.hasMessages(1)) {
                return;
            }
            if (this.mNextView != null && this.mView != this.mNextView) {
                this.handleHide();
                this.mView = this.mNextView;
                if (this.mView != null) {
                    this.mPresenter.show(this.mView, this.mToken, windowToken, this.mDuration, this.mGravity, this.mX, this.mY, this.mHorizontalMargin, this.mVerticalMargin, new CallbackBinder(this.getCallbacks(), this.mHandler));
                }
            }
        }

        @UnsupportedAppUsage
        public void handleHide() {
            if (this.mView != null) {
                Preconditions.checkState(this.mView == this.mPresenter.getView(), "Trying to hide toast view different than the last one displayed");
                this.mPresenter.hide(new CallbackBinder(this.getCallbacks(), this.mHandler));
                this.mView = null;
            }
        }

        @VisibleForTesting
        public View getNextView() {
            return this.mNextView;
        }
    }

    private static class CallbackBinder
    extends ITransientNotificationCallback.Stub {
        private final Handler mHandler;
        @GuardedBy(value={"mCallbacks"})
        private final List<Callback> mCallbacks;

        private CallbackBinder(List<Callback> callbacks, Handler handler) {
            this.mCallbacks = callbacks;
            this.mHandler = handler;
        }

        @Override
        public void onToastShown() {
            this.mHandler.post(() -> {
                for (Callback callback : this.getCallbacks()) {
                    callback.onToastShown();
                }
            });
        }

        @Override
        public void onToastHidden() {
            this.mHandler.post(() -> {
                for (Callback callback : this.getCallbacks()) {
                    callback.onToastHidden();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Callback> getCallbacks() {
            List<Callback> list = this.mCallbacks;
            synchronized (list) {
                return new ArrayList<Callback>(this.mCallbacks);
            }
        }
    }

    public static abstract class Callback {
        public void onToastShown() {
        }

        public void onToastHidden() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }
}

