/*
 * Decompiled with CFR 0.152.
 */
package android.widget.inline;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Size;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.widget.InlinePresentationStyleUtils;
import java.util.Objects;

public class InlinePresentationSpec
implements Parcelable {
    @NonNull
    private final Size mMinSize;
    @NonNull
    private final Size mMaxSize;
    @NonNull
    private final Bundle mStyle;
    @NonNull
    public static final Parcelable.Creator<InlinePresentationSpec> CREATOR = new Parcelable.Creator<InlinePresentationSpec>(){

        public InlinePresentationSpec[] newArray(int size) {
            return new InlinePresentationSpec[size];
        }

        @Override
        public InlinePresentationSpec createFromParcel(@NonNull Parcel in) {
            return new InlinePresentationSpec(in);
        }
    };

    @NonNull
    private static Bundle defaultStyle() {
        return Bundle.EMPTY;
    }

    private boolean styleEquals(@NonNull Bundle style2) {
        return InlinePresentationStyleUtils.bundleEquals(this.mStyle, style2);
    }

    public void filterContentTypes() {
        InlinePresentationStyleUtils.filterContentTypes(this.mStyle);
    }

    InlinePresentationSpec(@NonNull Size minSize, @NonNull Size maxSize, @NonNull Bundle style2) {
        this.mMinSize = minSize;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMinSize);
        this.mMaxSize = maxSize;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMaxSize);
        this.mStyle = style2;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mStyle);
    }

    @NonNull
    public Size getMinSize() {
        return this.mMinSize;
    }

    @NonNull
    public Size getMaxSize() {
        return this.mMaxSize;
    }

    @NonNull
    public Bundle getStyle() {
        return this.mStyle;
    }

    public String toString() {
        return "InlinePresentationSpec { minSize = " + this.mMinSize + ", maxSize = " + this.mMaxSize + ", style = " + this.mStyle + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlinePresentationSpec that = (InlinePresentationSpec)o;
        return Objects.equals(this.mMinSize, that.mMinSize) && Objects.equals(this.mMaxSize, that.mMaxSize) && this.styleEquals(that.mStyle);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mMinSize);
        _hash = 31 * _hash + Objects.hashCode(this.mMaxSize);
        _hash = 31 * _hash + Objects.hashCode(this.mStyle);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeSize(this.mMinSize);
        dest.writeSize(this.mMaxSize);
        dest.writeBundle(this.mStyle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    InlinePresentationSpec(@NonNull Parcel in) {
        Size minSize = in.readSize();
        Size maxSize = in.readSize();
        Bundle style2 = in.readBundle();
        this.mMinSize = minSize;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMinSize);
        this.mMaxSize = maxSize;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMaxSize);
        this.mStyle = style2;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mStyle);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        @NonNull
        private Size mMinSize;
        @NonNull
        private Size mMaxSize;
        @NonNull
        private Bundle mStyle;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull Size minSize, @NonNull Size maxSize) {
            this.mMinSize = minSize;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mMinSize);
            this.mMaxSize = maxSize;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mMaxSize);
        }

        @NonNull
        public Builder setStyle(@NonNull Bundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mStyle = value;
            return this;
        }

        @NonNull
        public InlinePresentationSpec build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mStyle = InlinePresentationSpec.defaultStyle();
            }
            InlinePresentationSpec o = new InlinePresentationSpec(this.mMinSize, this.mMaxSize, this.mStyle);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 8L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }
    }
}

