/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.IBackAnimationRunner;
import java.util.ArrayList;

public class BackAnimationAdapter
implements Parcelable {
    public int mOriginDisplayId = -1;
    private final IBackAnimationRunner mRunner;
    private int[] mSupportedAnimators;
    @NonNull
    public static final Parcelable.Creator<BackAnimationAdapter> CREATOR = new Parcelable.Creator<BackAnimationAdapter>(){

        @Override
        public BackAnimationAdapter createFromParcel(Parcel in) {
            return new BackAnimationAdapter(in);
        }

        public BackAnimationAdapter[] newArray(int size) {
            return new BackAnimationAdapter[size];
        }
    };

    public BackAnimationAdapter(IBackAnimationRunner runner) {
        this.mRunner = runner;
    }

    public BackAnimationAdapter(Parcel in) {
        this.mRunner = IBackAnimationRunner.Stub.asInterface(in.readStrongBinder());
        this.mSupportedAnimators = new int[in.readInt()];
        in.readIntArray(this.mSupportedAnimators);
        this.mOriginDisplayId = in.readInt();
    }

    public IBackAnimationRunner getRunner() {
        return this.mRunner;
    }

    public void updateSupportedAnimators(@NonNull ArrayList<Integer> animators) {
        int size = animators.size();
        this.mSupportedAnimators = new int[size];
        for (int i = size - 1; i >= 0; --i) {
            this.mSupportedAnimators[i] = animators.get(i);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongInterface(this.mRunner);
        dest.writeInt(this.mSupportedAnimators.length);
        dest.writeIntArray(this.mSupportedAnimators);
        dest.writeInt(this.mOriginDisplayId);
    }

    public boolean isAnimatable(int backType) {
        if (this.mSupportedAnimators == null) {
            return false;
        }
        for (int i = this.mSupportedAnimators.length - 1; i >= 0; --i) {
            if (backType != this.mSupportedAnimators[i]) continue;
            return true;
        }
        return false;
    }
}

