/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.SystemProperties;
import android.util.MathUtils;
import android.view.RemoteAnimationTarget;
import android.window.BackMotionEvent;
import java.io.PrintWriter;

public class BackTouchTracker {
    private static final String PREDICTIVE_BACK_LINEAR_DISTANCE_PROP = "persist.wm.debug.predictive_back_linear_distance";
    private static final int LINEAR_DISTANCE = SystemProperties.getInt("persist.wm.debug.predictive_back_linear_distance", -1);
    private float mLinearDistance = LINEAR_DISTANCE;
    private float mMaxDistance;
    private float mNonLinearFactor;
    private float mLatestTouchX;
    private float mLatestTouchY;
    private boolean mTriggerBack;
    private float mInitTouchX;
    private float mInitTouchY;
    private float mStartThresholdX;
    private int mSwipeEdge;
    private boolean mShouldUpdateStartLocation = false;
    private TouchTrackerState mState = TouchTrackerState.INITIAL;
    private boolean mIsInterceptedMotionEvent;

    public void update(float touchX, float touchY) {
        if (touchX < this.mStartThresholdX && this.mSwipeEdge == 0 || touchX > this.mStartThresholdX && this.mSwipeEdge == 1) {
            this.mStartThresholdX = touchX;
            if (this.mSwipeEdge == 0 && this.mStartThresholdX < this.mInitTouchX || this.mSwipeEdge == 1 && this.mStartThresholdX > this.mInitTouchX) {
                this.mInitTouchX = this.mStartThresholdX;
            }
        }
        this.mLatestTouchX = touchX;
        this.mLatestTouchY = touchY;
    }

    public void setTriggerBack(boolean triggerBack) {
        if (this.mTriggerBack != triggerBack && !triggerBack) {
            this.mStartThresholdX = this.mLatestTouchX;
        }
        this.mTriggerBack = triggerBack;
    }

    public boolean getTriggerBack() {
        return this.mTriggerBack;
    }

    public boolean shouldUpdateStartLocation() {
        return this.mShouldUpdateStartLocation;
    }

    public void setShouldUpdateStartLocation(boolean shouldUpdate) {
        this.mShouldUpdateStartLocation = shouldUpdate;
    }

    public void setState(TouchTrackerState state) {
        this.mState = state;
    }

    public boolean isInInitialState() {
        return this.mState == TouchTrackerState.INITIAL;
    }

    public boolean isActive() {
        return this.mState == TouchTrackerState.ACTIVE;
    }

    public boolean isFinished() {
        return this.mState == TouchTrackerState.FINISHED;
    }

    public boolean isInterceptedMotionEvent() {
        return this.mIsInterceptedMotionEvent;
    }

    public void setMotionEventIntercepted() {
        this.mIsInterceptedMotionEvent = true;
    }

    public void setGestureStartLocation(float touchX, float touchY, int swipeEdge) {
        this.mInitTouchX = touchX;
        this.mInitTouchY = touchY;
        this.mLatestTouchX = touchX;
        this.mLatestTouchY = touchY;
        this.mSwipeEdge = swipeEdge;
        this.mStartThresholdX = this.mInitTouchX;
    }

    public void updateStartLocation() {
        this.mInitTouchX = this.mLatestTouchX;
        this.mInitTouchY = this.mLatestTouchY;
        this.mStartThresholdX = this.mInitTouchX;
        this.mShouldUpdateStartLocation = false;
    }

    public void updateSwipeEdge(int swipeEdge) {
        this.mSwipeEdge = swipeEdge;
    }

    public void reset() {
        this.mInitTouchX = 0.0f;
        this.mInitTouchY = 0.0f;
        this.mStartThresholdX = 0.0f;
        this.mTriggerBack = false;
        this.mState = TouchTrackerState.INITIAL;
        this.mSwipeEdge = 0;
        this.mShouldUpdateStartLocation = false;
        this.mIsInterceptedMotionEvent = false;
    }

    public BackMotionEvent createStartEvent(RemoteAnimationTarget target) {
        return new BackMotionEvent(this.mInitTouchX, this.mInitTouchY, 0L, 0.0f, this.mTriggerBack, this.mSwipeEdge, target);
    }

    public BackMotionEvent createProgressEvent() {
        float progress = this.getProgress(this.mLatestTouchX);
        return this.createProgressEvent(progress);
    }

    public float getProgress(float touchX) {
        float progress;
        float startX = this.mTriggerBack ? this.mInitTouchX : this.mStartThresholdX;
        float distance = this.mSwipeEdge == 0 ? touchX - startX : startX - touchX;
        float deltaX = Math.max(0.0f, distance);
        float linearDistance = this.mLinearDistance;
        float maxDistance = this.getMaxDistance();
        float f = maxDistance = maxDistance == 0.0f ? 1.0f : maxDistance;
        if (linearDistance < maxDistance) {
            boolean isLinear;
            float nonLinearDistance = maxDistance - linearDistance;
            float initialTarget = linearDistance + nonLinearDistance * this.mNonLinearFactor;
            boolean bl = isLinear = deltaX <= linearDistance;
            if (isLinear) {
                progress = deltaX / initialTarget;
            } else {
                float nonLinearDeltaX = deltaX - linearDistance;
                float nonLinearProgress = nonLinearDeltaX / nonLinearDistance;
                float currentTarget = MathUtils.lerp(initialTarget, maxDistance, nonLinearProgress);
                progress = deltaX / currentTarget;
            }
        } else {
            progress = deltaX / maxDistance;
        }
        return MathUtils.constrain(progress, 0.0f, 1.0f);
    }

    public float getMaxDistance() {
        return this.mMaxDistance;
    }

    public float getLinearDistance() {
        return this.mLinearDistance;
    }

    public float getNonLinearFactor() {
        return this.mNonLinearFactor;
    }

    public BackMotionEvent createProgressEvent(float progress) {
        return new BackMotionEvent(this.mLatestTouchX, this.mLatestTouchY, 0L, progress, this.mTriggerBack, this.mSwipeEdge, null);
    }

    public void setProgressThresholds(float linearDistance, float maxDistance, float nonLinearFactor) {
        this.mLinearDistance = LINEAR_DISTANCE >= 0 ? (float)LINEAR_DISTANCE : linearDistance;
        this.mMaxDistance = maxDistance;
        this.mNonLinearFactor = nonLinearFactor;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "BackTouchTracker state:");
        pw.println(prefix + "  mState=" + (Object)((Object)this.mState));
        pw.println(prefix + "  mTriggerBack=" + this.mTriggerBack);
    }

    public static enum TouchTrackerState {
        INITIAL,
        ACTIVE,
        FINISHED;

    }
}

