/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.RemoteAnimationTarget;
import android.window.IBackAnimationFinishedCallback;

public interface IBackAnimationRunner
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IBackAnimationRunner";

    public void onAnimationCancelled() throws RemoteException;

    public void onAnimationStart(RemoteAnimationTarget[] var1, IBinder var2, IBackAnimationFinishedCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackAnimationRunner {
        static final int TRANSACTION_onAnimationCancelled = 2;
        static final int TRANSACTION_onAnimationStart = 3;

        public Stub() {
            this.attachInterface(this, IBackAnimationRunner.DESCRIPTOR);
        }

        public static IBackAnimationRunner asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBackAnimationRunner.DESCRIPTOR);
            if (iin != null && iin instanceof IBackAnimationRunner) {
                return (IBackAnimationRunner)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 2: {
                    return "onAnimationCancelled";
                }
                case 3: {
                    return "onAnimationStart";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBackAnimationRunner.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    this.onAnimationCancelled();
                    break;
                }
                case 3: {
                    RemoteAnimationTarget[] _arg0 = data.createTypedArray(RemoteAnimationTarget.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    IBackAnimationFinishedCallback _arg2 = IBackAnimationFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onAnimationStart(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IBackAnimationRunner {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBackAnimationRunner.DESCRIPTOR;
            }

            @Override
            public void onAnimationCancelled() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBackAnimationRunner.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnimationStart(RemoteAnimationTarget[] apps, IBinder prepareOpenTransition, IBackAnimationFinishedCallback finishedCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBackAnimationRunner.DESCRIPTOR);
                    _data.writeTypedArray(apps, 0);
                    _data.writeStrongBinder(prepareOpenTransition);
                    _data.writeStrongInterface(finishedCallback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBackAnimationRunner {
        @Override
        public void onAnimationCancelled() throws RemoteException {
        }

        @Override
        public void onAnimationStart(RemoteAnimationTarget[] apps, IBinder prepareOpenTransition, IBackAnimationFinishedCallback finishedCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

