/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class WindowContextInfo
implements Parcelable {
    @NonNull
    private final Configuration mConfiguration;
    private final int mDisplayId;
    @NonNull
    public static final Parcelable.Creator<WindowContextInfo> CREATOR = new Parcelable.Creator<WindowContextInfo>(){

        @Override
        public WindowContextInfo createFromParcel(Parcel in) {
            return new WindowContextInfo(in);
        }

        public WindowContextInfo[] newArray(int size) {
            return new WindowContextInfo[size];
        }
    };

    public WindowContextInfo(@NonNull Configuration configuration, int displayId) {
        this.mConfiguration = Objects.requireNonNull(configuration);
        this.mDisplayId = displayId;
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mConfiguration, flags);
        dest.writeInt(this.mDisplayId);
    }

    private WindowContextInfo(@NonNull Parcel in) {
        this.mConfiguration = in.readTypedObject(Configuration.CREATOR);
        this.mDisplayId = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowContextInfo other = (WindowContextInfo)o;
        return Objects.equals(this.mConfiguration, other.mConfiguration) && this.mDisplayId == other.mDisplayId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mConfiguration);
        result = 31 * result + this.mDisplayId;
        return result;
    }

    public String toString() {
        return "WindowContextInfo{config=" + this.mConfiguration + ", displayId=" + this.mDisplayId + "}";
    }
}

