/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import com.android.adservices.LogUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AdServicesParcelableUtil {
    public static <T> void writeNullableToParcel(@NonNull Parcel targetParcel, @Nullable T nullableField, @NonNull ParcelWriter<T> parcelWriter) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(parcelWriter);
        boolean isFieldPresent = nullableField != null;
        targetParcel.writeBoolean(isFieldPresent);
        if (isFieldPresent) {
            parcelWriter.write(targetParcel, nullableField);
        }
    }

    public static <T> T readNullableFromParcel(@NonNull Parcel sourceParcel, @NonNull ParcelReader<T> parcelReader) {
        Objects.requireNonNull(sourceParcel);
        Objects.requireNonNull(parcelReader);
        if (sourceParcel.readBoolean()) {
            return parcelReader.read(sourceParcel);
        }
        return null;
    }

    public static <K, V extends Parcelable> void writeMapToParcel(@NonNull Parcel targetParcel, @NonNull Map<K, V> sourceMap) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceMap);
        Bundle tempBundle = new Bundle();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            tempBundle.putParcelable(entry.getKey().toString(), (Parcelable)entry.getValue());
        }
        targetParcel.writeBundle(tempBundle);
    }

    public static <K, V extends Parcelable> Map<K, V> readMapFromParcel(@NonNull Parcel sourceParcel, @NonNull StringToObjectConverter<K> stringToKeyConverter, @NonNull Class<V> valueClass) {
        Objects.requireNonNull(sourceParcel);
        Objects.requireNonNull(stringToKeyConverter);
        Objects.requireNonNull(valueClass);
        Bundle tempBundle = Bundle.CREATOR.createFromParcel(sourceParcel);
        tempBundle.setClassLoader(valueClass.getClassLoader());
        HashMap resultMap = new HashMap();
        for (String key : tempBundle.keySet()) {
            Object value = _Original_Build.VERSION.SDK_INT < 33 ? tempBundle.getParcelable(key) : (Parcelable)tempBundle.getParcelable(key, valueClass);
            resultMap.put(stringToKeyConverter.convertFromString(key), value);
        }
        return resultMap;
    }

    public static <T extends Parcelable> void writeSetToParcel(@NonNull Parcel targetParcel, @NonNull Set<T> sourceSet) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceSet);
        ArrayList<T> tempList = new ArrayList<T>(sourceSet);
        targetParcel.writeTypedList(tempList);
    }

    public static <T extends Parcelable> Set<T> readSetFromParcel(@NonNull Parcel sourceParcel, @NonNull Parcelable.Creator<T> creator) {
        Objects.requireNonNull(sourceParcel);
        Objects.requireNonNull(creator);
        return new HashSet(Objects.requireNonNull(sourceParcel.createTypedArrayList(creator)));
    }

    public static void writeStringSetToParcel(@NonNull Parcel targetParcel, @NonNull Set<String> sourceSet) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceSet);
        ArrayList<String> tempList = new ArrayList<String>(sourceSet);
        targetParcel.writeStringList(tempList);
    }

    public static Set<String> readStringSetFromParcel(@NonNull Parcel sourceParcel) {
        Objects.requireNonNull(sourceParcel);
        return new HashSet<String>((Collection)Objects.requireNonNull(sourceParcel.createStringArrayList()));
    }

    public static void writeIntegerSetToParcel(@NonNull Parcel targetParcel, @NonNull Set<Integer> sourceSet) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceSet);
        int[] tempArray = new int[sourceSet.size()];
        int actualArraySize = 0;
        for (Integer integer2 : sourceSet) {
            if (integer2 == null) {
                LogUtil.w("Null value encountered while parceling Integer to int array; skipping element");
                continue;
            }
            tempArray[actualArraySize++] = integer2;
        }
        int[] writeArray = new int[actualArraySize];
        System.arraycopy(tempArray, 0, writeArray, 0, actualArraySize);
        targetParcel.writeInt(actualArraySize);
        targetParcel.writeIntArray(writeArray);
    }

    public static Set<Integer> readIntegerSetFromParcel(@NonNull Parcel sourceParcel) {
        Objects.requireNonNull(sourceParcel);
        int setSize = sourceParcel.readInt();
        int[] tempArray = new int[setSize];
        HashSet<Integer> targetSet = new HashSet<Integer>();
        sourceParcel.readIntArray(tempArray);
        for (int index = 0; index < setSize; ++index) {
            targetSet.add(tempArray[index]);
        }
        return targetSet;
    }

    public static void writeInstantListToParcel(@NonNull Parcel targetParcel, @NonNull List<Instant> sourceList) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceList);
        long[] tempArray = new long[sourceList.size()];
        int actualArraySize = 0;
        for (Instant instant : sourceList) {
            long instantAsEpochMilli;
            try {
                instantAsEpochMilli = instant.toEpochMilli();
            }
            catch (Exception exception) {
                LogUtil.w(exception, "Error encountered while parceling Instant %s to long; skipping element", instant);
                continue;
            }
            tempArray[actualArraySize++] = instantAsEpochMilli;
        }
        long[] writeArray = new long[actualArraySize];
        System.arraycopy(tempArray, 0, writeArray, 0, actualArraySize);
        targetParcel.writeInt(actualArraySize);
        targetParcel.writeLongArray(writeArray);
    }

    public static List<Instant> readInstantListFromParcel(@NonNull Parcel sourceParcel) {
        Objects.requireNonNull(sourceParcel);
        int listSize = sourceParcel.readInt();
        long[] tempArray = new long[listSize];
        ArrayList<Instant> targetList = new ArrayList<Instant>(listSize);
        sourceParcel.readLongArray(tempArray);
        for (int ii = 0; ii < listSize; ++ii) {
            Instant instantFromMilli;
            try {
                instantFromMilli = Instant.ofEpochMilli(tempArray[ii]);
            }
            catch (Exception exception) {
                LogUtil.w(exception, "Error encountered while unparceling Instant from long %d; skipping element", tempArray[ii]);
                continue;
            }
            targetList.add(instantFromMilli);
        }
        return targetList;
    }

    @FunctionalInterface
    public static interface ParcelWriter<T> {
        public void write(@NonNull Parcel var1, @NonNull T var2);
    }

    @FunctionalInterface
    public static interface ParcelReader<T> {
        public T read(@NonNull Parcel var1);
    }

    @FunctionalInterface
    public static interface StringToObjectConverter<T> {
        public T convertFromString(@NonNull String var1);
    }
}

