/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import com.android.i18n.timezone.TzDataSetVersion;
import java.io.File;
import java.io.IOException;

public class TimeZoneDataFiles {
    private static final String ANDROID_ROOT_ENV = "ANDROID_ROOT";
    private static final String ANDROID_TZDATA_ROOT_ENV = "ANDROID_TZDATA_ROOT";

    private TimeZoneDataFiles() {
    }

    public static String[] getTimeZoneFilePaths(String fileName) {
        return new String[]{TimeZoneDataFiles.getTimeZoneModuleTzFile(fileName)};
    }

    public static String getTimeZoneModuleTzFile(String fileName) {
        return TimeZoneDataFiles.getTimeZoneModuleFile("tz/versioned/" + TzDataSetVersion.currentFormatMajorVersion() + "/" + fileName);
    }

    public static String getTimeZoneModuleTzVersionFile() {
        return TimeZoneDataFiles.getTimeZoneModuleTzFile("tz_version");
    }

    public static TzDataSetVersion readTimeZoneModuleVersion() throws IOException, TzDataSetVersion.TzDataSetException {
        String tzVersionFileName = TimeZoneDataFiles.getTimeZoneModuleTzFile("tz_version");
        return TzDataSetVersion.readFromFile(new File(tzVersionFileName));
    }

    public static String getTimeZoneModuleFile(String fileName) {
        return System.getenv(ANDROID_TZDATA_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String getSystemTzFile(String fileName) {
        return TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/share/zoneinfo/" + fileName);
    }

    public static String getSystemIcuFile(String fileName) {
        return TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/icu/" + fileName);
    }

    private static String getEnvironmentPath(String environmentVariable, String path) {
        String variable = System.getenv(environmentVariable);
        if (variable == null) {
            return null;
        }
        return variable + path;
    }
}

