/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.media.MediaRouter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Comparator;

public class MediaRouteChooserContentManager {
    Context mContext;
    Delegate mDelegate;
    private final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    private int mRouteTypes;
    private RouteAdapter mAdapter;
    private boolean mAttachedToWindow;

    public MediaRouteChooserContentManager(Context context, Delegate delegate) {
        this.mContext = context;
        this.mDelegate = delegate;
        this.mRouter = context.getSystemService(MediaRouter.class);
        this.mCallback = new MediaRouterCallback();
        this.mAdapter = new RouteAdapter(this.mContext);
    }

    public void bindViews(View containerView) {
        Object emptyView = containerView.findViewById(16908292);
        ListView listView = (ListView)containerView.findViewById(16909284);
        listView.setAdapter(this.mAdapter);
        listView.setOnItemClickListener(this.mAdapter);
        listView.setEmptyView((View)emptyView);
        if (!this.mDelegate.showProgressBarWhenEmpty()) {
            ((View)containerView.findViewById(16909285)).setVisibility(8);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)((View)emptyView).getLayoutParams();
            params.gravity = 17;
            ((View)emptyView).setLayoutParams(params);
        }
    }

    public void onAttachedToWindow() {
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 1);
        this.refreshRoutes();
    }

    public void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
    }

    public int getRouteTypes() {
        return this.mRouteTypes;
    }

    public void setRouteTypes(int types) {
        if (this.mRouteTypes != types) {
            this.mRouteTypes = types;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(types, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    public void refreshRoutes() {
        if (this.mAttachedToWindow) {
            this.mAdapter.update();
        }
    }

    public boolean onFilterRoute(MediaRouter.RouteInfo route) {
        return !route.isDefault() && route.isEnabled() && route.matchesTypes(this.mRouteTypes);
    }

    public static interface Delegate {
        public void dismissView();

        public boolean showProgressBarWhenEmpty();
    }

    private class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserContentManager.this.refreshRoutes();
        }

        @Override
        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserContentManager.this.refreshRoutes();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserContentManager.this.refreshRoutes();
        }

        @Override
        public void onRouteSelected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            MediaRouteChooserContentManager.this.mDelegate.dismissView();
        }
    }

    private class RouteAdapter
    extends ArrayAdapter<MediaRouter.RouteInfo>
    implements AdapterView.OnItemClickListener {
        private final LayoutInflater mInflater;

        RouteAdapter(Context context) {
            super(context, 0);
            this.mInflater = LayoutInflater.from(context);
        }

        public void update() {
            this.clear();
            int count = MediaRouteChooserContentManager.this.mRouter.getRouteCount();
            for (int i = 0; i < count; ++i) {
                MediaRouter.RouteInfo route = MediaRouteChooserContentManager.this.mRouter.getRouteAt(i);
                if (!MediaRouteChooserContentManager.this.onFilterRoute(route)) continue;
                this.add(route);
            }
            this.sort(RouteComparator.sInstance);
            this.notifyDataSetChanged();
        }

        @Override
        public boolean areAllItemsEnabled() {
            return false;
        }

        @Override
        public boolean isEnabled(int position) {
            return ((MediaRouter.RouteInfo)this.getItem(position)).isEnabled();
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.mInflater.inflate(17367218, parent, false);
            }
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            TextView text1 = (TextView)view.findViewById(16908308);
            TextView text2 = (TextView)view.findViewById(16908309);
            text1.setText(route.getName());
            CharSequence description = route.getDescription();
            if (TextUtils.isEmpty(description)) {
                text2.setVisibility(8);
                text2.setText("");
            } else {
                text2.setVisibility(0);
                text2.setText(description);
            }
            view.setEnabled(route.isEnabled());
            return view;
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            if (route.isEnabled()) {
                route.select();
                MediaRouteChooserContentManager.this.mDelegate.dismissView();
            }
        }
    }

    private static class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        public static final RouteComparator sInstance = new RouteComparator();

        private RouteComparator() {
        }

        @Override
        public int compare(MediaRouter.RouteInfo lhs, MediaRouter.RouteInfo rhs) {
            return lhs.getName().toString().compareTo(rhs.getName().toString());
        }
    }
}

