/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Message;
import android.os.UserHandle;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.chooser.TargetInfo;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class NoOpResolverComparator
extends AbstractResolverComparator {
    @Nullable
    private List<ResolveInfo> mOriginalTargetOrder = null;

    public NoOpResolverComparator(Context launchedFromContext, Intent intent, List<UserHandle> targetUserSpaceList) {
        super(launchedFromContext, intent, targetUserSpaceList);
    }

    @Override
    public void doCompute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.mOriginalTargetOrder = new ArrayList<ResolveInfo>();
        for (ResolverActivity.ResolvedComponentInfo target : targets) {
            this.mOriginalTargetOrder.add(target.getResolveInfoAt(0));
        }
        this.afterCompute();
    }

    @Override
    public int compare(ResolveInfo lhs, ResolveInfo rhs) {
        Comparator<ResolveInfo> c = Comparator.comparingDouble(r -> this.getScore((ResolveInfo)r));
        c = c.reversed();
        return c.compare(lhs, rhs);
    }

    @Override
    public float getScore(TargetInfo targetInfo) {
        return this.getScore(targetInfo.getResolveInfo());
    }

    @Override
    public void handleResultMessage(Message message) {
    }

    @VisibleForTesting
    public float getScore(ResolveInfo resolveInfo) {
        if (!this.mOriginalTargetOrder.contains(resolveInfo)) {
            return 0.0f;
        }
        float rank = this.mOriginalTargetOrder.indexOf(resolveInfo);
        return 1.0f - rank / (float)(1 + this.mOriginalTargetOrder.size());
    }
}

