/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.PermissionChecker;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.SimpleIconFactory;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.app.chooser.TargetInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResolverListAdapter
extends BaseAdapter {
    private static final String TAG = "ResolverListAdapter";
    private final List<Intent> mIntents;
    private final Intent[] mInitialIntents;
    private final List<ResolveInfo> mBaseResolveList;
    private final PackageManager mPm;
    protected final Context mContext;
    private static ColorMatrixColorFilter sSuspendedMatrixColorFilter;
    private final int mIconDpi;
    protected ResolveInfo mLastChosen;
    private DisplayResolveInfo mOtherProfile;
    ResolverListController mResolverListController;
    private int mPlaceholderCount;
    protected final LayoutInflater mInflater;
    List<DisplayResolveInfo> mDisplayList;
    private List<ResolverActivity.ResolvedComponentInfo> mUnfilteredResolveList;
    private int mLastChosenPosition = -1;
    private boolean mFilterLastUsed;
    final ResolverListCommunicator mResolverListCommunicator;
    private Runnable mPostListReadyRunnable;
    private final boolean mIsAudioCaptureDevice;
    private boolean mIsTabLoaded;
    private final Map<DisplayResolveInfo, LoadIconTask> mIconLoaders = new HashMap<DisplayResolveInfo, LoadIconTask>();
    private final Map<DisplayResolveInfo, LoadLabelTask> mLabelLoaders = new HashMap<DisplayResolveInfo, LoadLabelTask>();
    private final UserHandle mInitialIntentsUserSpace;

    public ResolverListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed, ResolverListController resolverListController, ResolverListCommunicator resolverListCommunicator, boolean isAudioCaptureDevice, UserHandle initialIntentsUserSpace) {
        this.mContext = context;
        this.mIntents = payloadIntents;
        this.mInitialIntents = initialIntents;
        this.mBaseResolveList = rList;
        this.mInflater = LayoutInflater.from(context);
        this.mPm = context.getPackageManager();
        this.mDisplayList = new ArrayList<DisplayResolveInfo>();
        this.mFilterLastUsed = filterLastUsed;
        this.mResolverListController = resolverListController;
        this.mResolverListCommunicator = resolverListCommunicator;
        this.mIsAudioCaptureDevice = isAudioCaptureDevice;
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
        this.mInitialIntentsUserSpace = initialIntentsUserSpace;
    }

    public ResolverListController getResolverListController() {
        return this.mResolverListController;
    }

    public void handlePackagesChanged() {
        this.mResolverListCommunicator.onHandlePackagesChanged(this);
    }

    public void setPlaceholderCount(int count) {
        this.mPlaceholderCount = count;
    }

    public int getPlaceholderCount() {
        return this.mPlaceholderCount;
    }

    @Nullable
    public DisplayResolveInfo getFilteredItem() {
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
            return this.mDisplayList.get(this.mLastChosenPosition);
        }
        return null;
    }

    public DisplayResolveInfo getOtherProfile() {
        return this.mOtherProfile;
    }

    public int getFilteredPosition() {
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
            return this.mLastChosenPosition;
        }
        return -1;
    }

    public boolean hasFilteredItem() {
        return this.mFilterLastUsed && this.mLastChosen != null;
    }

    public float getScore(DisplayResolveInfo target) {
        return this.mResolverListController.getScore(target);
    }

    public float getScore(TargetInfo targetInfo) {
        return this.mResolverListController.getScore(targetInfo);
    }

    public void updateModel(TargetInfo targetInfo) {
        this.mResolverListController.updateModel(targetInfo);
    }

    public void updateChooserCounts(String packageName, String action, UserHandle userHandle) {
        this.mResolverListController.updateChooserCounts(packageName, userHandle, action);
    }

    List<ResolverActivity.ResolvedComponentInfo> getUnfilteredResolveList() {
        return this.mUnfilteredResolveList;
    }

    protected boolean rebuildList(boolean doPostProcessing) {
        boolean needsCopyOfUnfiltered;
        List<ResolverActivity.ResolvedComponentInfo> originalList;
        Trace.beginSection("ResolverListAdapter#rebuildList");
        this.mDisplayList.clear();
        this.mIsTabLoaded = false;
        this.mLastChosenPosition = -1;
        List<ResolverActivity.ResolvedComponentInfo> currentResolveList = this.getInitialRebuiltResolveList();
        this.mUnfilteredResolveList = this.performPrimaryResolveListFiltering(currentResolveList);
        ResolverActivity.ResolvedComponentInfo otherProfileInfo = ResolverListAdapter.getFirstNonCurrentUserResolvedComponentInfo(currentResolveList);
        this.updateOtherProfileTreatment(otherProfileInfo);
        if (otherProfileInfo != null) {
            currentResolveList.remove(otherProfileInfo);
        }
        if ((originalList = this.performSecondaryResolveListFiltering(currentResolveList, needsCopyOfUnfiltered = this.mUnfilteredResolveList == currentResolveList)) != null) {
            this.mUnfilteredResolveList = originalList;
        }
        boolean result = this.finishRebuildingListWithFilteredResults(currentResolveList, doPostProcessing);
        Trace.endSection();
        return result;
    }

    List<ResolverActivity.ResolvedComponentInfo> getInitialRebuiltResolveList() {
        if (this.mBaseResolveList != null) {
            ArrayList<ResolverActivity.ResolvedComponentInfo> currentResolveList = new ArrayList<ResolverActivity.ResolvedComponentInfo>();
            this.mResolverListController.addResolveListDedupe(currentResolveList, this.mResolverListCommunicator.getTargetIntent(), this.mBaseResolveList);
            return currentResolveList;
        }
        return this.mResolverListController.getResolversForIntent(true, this.mResolverListCommunicator.shouldGetActivityMetadata(), this.mResolverListCommunicator.shouldGetOnlyDefaultActivities(), this.mIntents);
    }

    @Nullable
    List<ResolverActivity.ResolvedComponentInfo> performPrimaryResolveListFiltering(@Nullable List<ResolverActivity.ResolvedComponentInfo> currentResolveList) {
        if (this.mBaseResolveList != null || currentResolveList == null) {
            return currentResolveList;
        }
        ArrayList<ResolverActivity.ResolvedComponentInfo> originalList = this.mResolverListController.filterIneligibleActivities(currentResolveList, true);
        return originalList == null ? currentResolveList : originalList;
    }

    @Nullable
    List<ResolverActivity.ResolvedComponentInfo> performSecondaryResolveListFiltering(@Nullable List<ResolverActivity.ResolvedComponentInfo> currentResolveList, boolean returnCopyOfOriginalListIfModified) {
        if (currentResolveList == null || currentResolveList.isEmpty()) {
            return currentResolveList;
        }
        return this.mResolverListController.filterLowPriority(currentResolveList, returnCopyOfOriginalListIfModified);
    }

    void updateOtherProfileTreatment(@Nullable ResolverActivity.ResolvedComponentInfo otherProfileInfo) {
        this.mLastChosen = null;
        if (otherProfileInfo != null) {
            this.mOtherProfile = ResolverListAdapter.makeOtherProfileDisplayResolveInfo(this.mContext, otherProfileInfo, this.mPm, this.mResolverListCommunicator, this.mIconDpi);
        } else {
            this.mOtherProfile = null;
            try {
                this.mLastChosen = this.mResolverListController.getLastChosen();
            }
            catch (RemoteException re) {
                Log.d(TAG, "Error calling getLastChosenActivity\n" + re);
            }
        }
    }

    boolean finishRebuildingListWithFilteredResults(@Nullable List<ResolverActivity.ResolvedComponentInfo> filteredResolveList, boolean doPostProcessing) {
        if (filteredResolveList == null || filteredResolveList.size() < 2) {
            this.setPlaceholderCount(0);
            this.processSortedList(filteredResolveList, doPostProcessing);
            return true;
        }
        int placeholderCount = filteredResolveList.size();
        if (this.mResolverListCommunicator.useLayoutWithDefault()) {
            --placeholderCount;
        }
        this.setPlaceholderCount(placeholderCount);
        this.postListReadyRunnable(doPostProcessing, false);
        this.createSortingTask(doPostProcessing).execute(filteredResolveList);
        return false;
    }

    AsyncTask<List<ResolverActivity.ResolvedComponentInfo>, Void, List<ResolverActivity.ResolvedComponentInfo>> createSortingTask(final boolean doPostProcessing) {
        return new AsyncTask<List<ResolverActivity.ResolvedComponentInfo>, Void, List<ResolverActivity.ResolvedComponentInfo>>(){

            protected List<ResolverActivity.ResolvedComponentInfo> doInBackground(List<ResolverActivity.ResolvedComponentInfo> ... params) {
                ResolverListAdapter.this.mResolverListController.sort(params[0]);
                return params[0];
            }

            @Override
            protected void onPostExecute(List<ResolverActivity.ResolvedComponentInfo> sortedComponents) {
                ResolverListAdapter.this.processSortedList(sortedComponents, doPostProcessing);
                ResolverListAdapter.this.notifyDataSetChanged();
                if (doPostProcessing) {
                    ResolverListAdapter.this.mResolverListCommunicator.updateProfileViewButton();
                }
            }
        };
    }

    protected void processSortedList(List<ResolverActivity.ResolvedComponentInfo> sortedComponents, boolean doPostProcessing) {
        int n = sortedComponents != null ? sortedComponents.size() : 0;
        Trace.beginSection("ResolverListAdapter#processSortedList:" + n);
        if (n != 0) {
            if (this.mInitialIntents != null) {
                for (int i = 0; i < this.mInitialIntents.length; ++i) {
                    Intent ii = this.mInitialIntents[i];
                    if (ii == null) continue;
                    Intent rii = ii.getClass() == Intent.class ? ii : new Intent(ii);
                    ActivityInfo ai = rii.resolveActivityInfo(this.mPm, 0);
                    if (ai == null) {
                        Log.w(TAG, "No activity found for " + ii);
                        continue;
                    }
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    UserManager userManager = (UserManager)this.mContext.getSystemService("user");
                    if (ii instanceof LabeledIntent) {
                        LabeledIntent li = (LabeledIntent)ii;
                        ri.resolvePackageName = li.getSourcePackage();
                        ri.labelRes = li.getLabelResource();
                        ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                        ri.iconResourceId = ri.icon = li.getIconResource();
                    }
                    if (userManager.isManagedProfile()) {
                        ri.noResourceId = true;
                        ri.icon = 0;
                    }
                    ri.userHandle = this.mInitialIntentsUserSpace;
                    this.addResolveInfo(new DisplayResolveInfo(ii, ri, ri.loadLabel(this.mPm), null, ii, this.makePresentationGetter(ri)));
                }
            }
            for (ResolverActivity.ResolvedComponentInfo rci : sortedComponents) {
                ResolveInfo ri = rci.getResolveInfoAt(0);
                if (ri == null) continue;
                this.addResolveInfoWithAlternates(rci);
            }
        }
        this.mResolverListCommunicator.sendVoiceChoicesIfNeeded();
        this.postListReadyRunnable(doPostProcessing, true);
        this.mIsTabLoaded = true;
        Trace.endSection();
    }

    void postListReadyRunnable(final boolean doPostProcessing, final boolean rebuildCompleted) {
        if (this.mPostListReadyRunnable == null) {
            this.mPostListReadyRunnable = new Runnable(){

                @Override
                public void run() {
                    ResolverListAdapter.this.mResolverListCommunicator.onPostListReady(ResolverListAdapter.this, doPostProcessing, rebuildCompleted);
                    ResolverListAdapter.this.mPostListReadyRunnable = null;
                }
            };
            this.mContext.getMainThreadHandler().post(this.mPostListReadyRunnable);
        }
    }

    private void addResolveInfoWithAlternates(ResolverActivity.ResolvedComponentInfo rci) {
        int count = rci.getCount();
        Intent intent = rci.getIntentAt(0);
        ResolveInfo add = rci.getResolveInfoAt(0);
        Intent replaceIntent = this.mResolverListCommunicator.getReplacementIntent(add.activityInfo, intent);
        Intent defaultIntent = this.mResolverListCommunicator.getReplacementIntent(add.activityInfo, this.mResolverListCommunicator.getTargetIntent());
        DisplayResolveInfo dri = new DisplayResolveInfo(intent, add, replaceIntent != null ? replaceIntent : defaultIntent, this.makePresentationGetter(add));
        dri.setPinned(rci.isPinned());
        if (rci.isPinned()) {
            Log.i(TAG, "Pinned item: " + rci.name);
        }
        this.addResolveInfo(dri);
        if (replaceIntent == intent) {
            int n = count;
            for (int i = 1; i < n; ++i) {
                Intent altIntent = rci.getIntentAt(i);
                dri.addAlternateSourceIntent(altIntent);
            }
        }
        this.updateLastChosenPosition(add);
    }

    private void updateLastChosenPosition(ResolveInfo info) {
        if (this.mOtherProfile != null) {
            this.mLastChosenPosition = -1;
            return;
        }
        if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(info.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(info.activityInfo.name)) {
            this.mLastChosenPosition = this.mDisplayList.size() - 1;
        }
    }

    private void addResolveInfo(DisplayResolveInfo dri) {
        if (dri != null && dri.getResolveInfo() != null && dri.getResolveInfo().targetUserId == -2 && this.shouldAddResolveInfo(dri)) {
            this.mDisplayList.add(dri);
            Log.i(TAG, "Add DisplayResolveInfo component: " + dri.getResolvedComponentName() + ", intent component: " + dri.getResolvedIntent().getComponent());
        }
    }

    protected boolean shouldAddResolveInfo(DisplayResolveInfo dri) {
        for (DisplayResolveInfo existingInfo : this.mDisplayList) {
            if (!this.mResolverListCommunicator.resolveInfoMatch(dri.getResolveInfo(), existingInfo.getResolveInfo())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ResolveInfo resolveInfoForPosition(int position, boolean filtered) {
        TargetInfo target = this.targetInfoForPosition(position, filtered);
        if (target != null) {
            return target.getResolveInfo();
        }
        return null;
    }

    @Nullable
    public TargetInfo targetInfoForPosition(int position, boolean filtered) {
        if (filtered) {
            return this.getItem(position);
        }
        if (this.mDisplayList.size() > position) {
            return this.mDisplayList.get(position);
        }
        return null;
    }

    @Override
    public int getCount() {
        int totalSize;
        int n = totalSize = this.mDisplayList == null || this.mDisplayList.isEmpty() ? this.mPlaceholderCount : this.mDisplayList.size();
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
            --totalSize;
        }
        return totalSize;
    }

    public int getUnfilteredCount() {
        return this.mDisplayList.size();
    }

    @Override
    @Nullable
    public TargetInfo getItem(int position) {
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && position >= this.mLastChosenPosition) {
            ++position;
        }
        if (this.mDisplayList.size() > position) {
            return this.mDisplayList.get(position);
        }
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public int getDisplayResolveInfoCount() {
        return this.mDisplayList.size();
    }

    public DisplayResolveInfo getDisplayResolveInfo(int index) {
        return this.mDisplayList.get(index);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null) {
            view = this.createView(parent);
        }
        this.onBindView(view, this.getItem(position), position);
        return view;
    }

    public View createView(ViewGroup parent) {
        View view = this.onCreateView(parent);
        ViewHolder holder = new ViewHolder(view);
        view.setTag(holder);
        return view;
    }

    View onCreateView(ViewGroup parent) {
        return this.mInflater.inflate(17367337, parent, false);
    }

    public void bindView(int position, View view) {
        this.onBindView(view, this.getItem(position), position);
    }

    protected void onBindView(View view, TargetInfo info, int position) {
        ViewHolder holder = (ViewHolder)view.getTag();
        if (info == null) {
            holder.icon.setImageDrawable(this.mContext.getDrawable(17303854));
            holder.bindLabel("", "", false);
            return;
        }
        if (info instanceof DisplayResolveInfo) {
            DisplayResolveInfo dri = (DisplayResolveInfo)info;
            if (dri.hasDisplayLabel()) {
                holder.bindLabel(dri.getDisplayLabel(), dri.getExtendedInfo(), this.alwaysShowSubLabel());
            } else {
                holder.bindLabel("", "", false);
                this.loadLabel(dri);
            }
            holder.bindIcon(info);
            if (!dri.hasDisplayIcon()) {
                this.loadIcon(dri);
            }
        }
    }

    protected void loadIcon(DisplayResolveInfo info) {
        LoadIconTask task = this.mIconLoaders.get(info);
        if (task == null) {
            task = new LoadIconTask(info);
            this.mIconLoaders.put(info, task);
            task.execute(new Void[0]);
        }
    }

    protected void onIconLoaded(DisplayResolveInfo info) {
        this.notifyDataSetChanged();
    }

    private void loadLabel(DisplayResolveInfo info) {
        LoadLabelTask task = this.mLabelLoaders.get(info);
        if (task == null) {
            task = this.createLoadLabelTask(info);
            this.mLabelLoaders.put(info, task);
            task.execute(new Void[0]);
        }
    }

    protected LoadLabelTask createLoadLabelTask(DisplayResolveInfo info) {
        return new LoadLabelTask(info);
    }

    public void onDestroy() {
        if (this.mPostListReadyRunnable != null) {
            this.mContext.getMainThreadHandler().removeCallbacks(this.mPostListReadyRunnable);
            this.mPostListReadyRunnable = null;
        }
        if (this.mResolverListController != null) {
            this.mResolverListController.destroy();
        }
        this.cancelTasks(this.mIconLoaders.values());
        this.cancelTasks(this.mLabelLoaders.values());
        this.mIconLoaders.clear();
        this.mLabelLoaders.clear();
    }

    private <T extends AsyncTask> void cancelTasks(Collection<T> tasks) {
        for (AsyncTask task : tasks) {
            task.cancel(false);
        }
    }

    private static ColorMatrixColorFilter getSuspendedColorMatrix() {
        if (sSuspendedMatrixColorFilter == null) {
            int grayValue = 127;
            float scale = 0.5f;
            ColorMatrix tempBrightnessMatrix = new ColorMatrix();
            float[] mat = tempBrightnessMatrix.getArray();
            mat[0] = scale;
            mat[6] = scale;
            mat[12] = scale;
            mat[4] = grayValue;
            mat[9] = grayValue;
            mat[14] = grayValue;
            ColorMatrix matrix = new ColorMatrix();
            matrix.setSaturation(0.0f);
            matrix.preConcat(tempBrightnessMatrix);
            sSuspendedMatrixColorFilter = new ColorMatrixColorFilter(matrix);
        }
        return sSuspendedMatrixColorFilter;
    }

    ActivityInfoPresentationGetter makePresentationGetter(ActivityInfo ai) {
        return new ActivityInfoPresentationGetter(this.mContext, this.mIconDpi, ai);
    }

    ResolveInfoPresentationGetter makePresentationGetter(ResolveInfo ri) {
        return new ResolveInfoPresentationGetter(this.mContext, this.mIconDpi, ri);
    }

    Drawable loadIconForResolveInfo(ResolveInfo ri) {
        return this.makePresentationGetter(ri).getIcon(ri.userHandle);
    }

    void loadFilteredItemIconTaskAsync(final @NonNull ImageView iconView) {
        final DisplayResolveInfo iconInfo = this.getFilteredItem();
        if (iconView != null && iconInfo != null) {
            new AsyncTask<Void, Void, Drawable>(){

                protected Drawable doInBackground(Void ... params) {
                    return ResolverListAdapter.this.loadIconForResolveInfo(iconInfo.getResolveInfo());
                }

                @Override
                protected void onPostExecute(Drawable d) {
                    iconView.setImageDrawable(d);
                }
            }.execute(new Void[0]);
        }
    }

    @VisibleForTesting
    public UserHandle getUserHandle() {
        return this.mResolverListController.getUserHandle();
    }

    protected List<ResolverActivity.ResolvedComponentInfo> getResolversForUser(UserHandle userHandle) {
        return this.mResolverListController.getResolversForIntentAsUser(true, this.mResolverListCommunicator.shouldGetActivityMetadata(), this.mResolverListCommunicator.shouldGetOnlyDefaultActivities(), this.mIntents, userHandle);
    }

    protected List<Intent> getIntents() {
        return this.mIntents;
    }

    protected boolean isTabLoaded() {
        return this.mIsTabLoaded;
    }

    protected void markTabLoaded() {
        this.mIsTabLoaded = true;
    }

    protected boolean alwaysShowSubLabel() {
        return false;
    }

    private static ResolverActivity.ResolvedComponentInfo getFirstNonCurrentUserResolvedComponentInfo(@Nullable List<ResolverActivity.ResolvedComponentInfo> resolveList) {
        if (resolveList == null) {
            return null;
        }
        for (ResolverActivity.ResolvedComponentInfo info : resolveList) {
            ResolveInfo resolveInfo = info.getResolveInfoAt(0);
            if (resolveInfo.targetUserId == -2) continue;
            return info;
        }
        return null;
    }

    private static DisplayResolveInfo makeOtherProfileDisplayResolveInfo(Context context, ResolverActivity.ResolvedComponentInfo resolvedComponentInfo, PackageManager pm, ResolverListCommunicator resolverListCommunicator, int iconDpi) {
        ResolveInfo resolveInfo = resolvedComponentInfo.getResolveInfoAt(0);
        Intent pOrigIntent = resolverListCommunicator.getReplacementIntent(resolveInfo.activityInfo, resolvedComponentInfo.getIntentAt(0));
        Intent replacementIntent = resolverListCommunicator.getReplacementIntent(resolveInfo.activityInfo, resolverListCommunicator.getTargetIntent());
        ResolveInfoPresentationGetter presentationGetter = new ResolveInfoPresentationGetter(context, iconDpi, resolveInfo);
        return new DisplayResolveInfo(resolvedComponentInfo.getIntentAt(0), resolveInfo, resolveInfo.loadLabel(pm), resolveInfo.loadLabel(pm), pOrigIntent != null ? pOrigIntent : replacementIntent, presentationGetter);
    }

    static interface ResolverListCommunicator {
        public boolean resolveInfoMatch(ResolveInfo var1, ResolveInfo var2);

        public Intent getReplacementIntent(ActivityInfo var1, Intent var2);

        public void onPostListReady(ResolverListAdapter var1, boolean var2, boolean var3);

        public void sendVoiceChoicesIfNeeded();

        public void updateProfileViewButton();

        public boolean useLayoutWithDefault();

        public boolean shouldGetActivityMetadata();

        default public boolean shouldGetOnlyDefaultActivities() {
            return true;
        }

        public Intent getTargetIntent();

        public void onHandlePackagesChanged(ResolverListAdapter var1);
    }

    @VisibleForTesting
    public static class ResolveInfoPresentationGetter
    extends ActivityInfoPresentationGetter {
        private final ResolveInfo mRi;

        public ResolveInfoPresentationGetter(Context ctx, int iconDpi, ResolveInfo ri) {
            super(ctx, iconDpi, ri.activityInfo);
            this.mRi = ri;
        }

        @Override
        Drawable getIconSubstituteInternal() {
            Drawable dr = null;
            try {
                if (this.mRi.resolvePackageName != null && this.mRi.icon != 0) {
                    dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mRi.resolvePackageName), this.mRi.icon);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(ResolverListAdapter.TAG, "SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON permission granted but couldn't find resources for package", e);
            }
            if (dr == null) {
                dr = super.getIconSubstituteInternal();
            }
            return dr;
        }

        @Override
        String getAppSubLabelInternal() {
            return this.mRi.loadLabel(this.mPm).toString();
        }

        @Override
        String getAppLabelForSubstitutePermission() {
            return this.mRi.getComponentInfo().loadLabel(this.mPm).toString();
        }
    }

    @VisibleForTesting
    public static class ViewHolder {
        public View itemView;
        public Drawable defaultItemViewBackground;
        public TextView text;
        public TextView text2;
        public ImageView icon;

        @VisibleForTesting
        public ViewHolder(View view) {
            this.itemView = view;
            this.defaultItemViewBackground = view.getBackground();
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }

        public void bindLabel(CharSequence label, CharSequence subLabel, boolean showSubLabel) {
            this.text.setText(label);
            if (TextUtils.equals(label, subLabel)) {
                subLabel = null;
            }
            this.text2.setText(subLabel);
            if (showSubLabel || subLabel != null) {
                this.text2.setVisibility(0);
            } else {
                this.text2.setVisibility(8);
            }
            this.itemView.setContentDescription(null);
        }

        public void updateContentDescription(String description) {
            this.itemView.setContentDescription(description);
        }

        public void bindIcon(TargetInfo info) {
            this.icon.setImageDrawable(info.getDisplayIcon(this.itemView.getContext()));
            if (info.isSuspended()) {
                this.icon.setColorFilter(ResolverListAdapter.getSuspendedColorMatrix());
            } else {
                this.icon.setColorFilter(null);
            }
        }
    }

    class LoadIconTask
    extends AsyncTask<Void, Void, Drawable> {
        protected final DisplayResolveInfo mDisplayResolveInfo;
        private final ResolveInfo mResolveInfo;

        LoadIconTask(DisplayResolveInfo dri) {
            this.mDisplayResolveInfo = dri;
            this.mResolveInfo = dri.getResolveInfo();
        }

        protected Drawable doInBackground(Void ... params) {
            return ResolverListAdapter.this.loadIconForResolveInfo(this.mResolveInfo);
        }

        @Override
        protected void onPostExecute(Drawable d) {
            if (ResolverListAdapter.this.getOtherProfile() == this.mDisplayResolveInfo) {
                ResolverListAdapter.this.mResolverListCommunicator.updateProfileViewButton();
            } else if (!this.mDisplayResolveInfo.hasDisplayIcon()) {
                this.mDisplayResolveInfo.setDisplayIcon(d);
                ResolverListAdapter.this.onIconLoaded(this.mDisplayResolveInfo);
            }
        }
    }

    protected class LoadLabelTask
    extends AsyncTask<Void, Void, CharSequence[]> {
        private final DisplayResolveInfo mDisplayResolveInfo;

        protected LoadLabelTask(DisplayResolveInfo dri) {
            this.mDisplayResolveInfo = dri;
        }

        protected CharSequence[] doInBackground(Void ... voids) {
            ResolveInfoPresentationGetter pg = ResolverListAdapter.this.makePresentationGetter(this.mDisplayResolveInfo.getResolveInfo());
            if (ResolverListAdapter.this.mIsAudioCaptureDevice) {
                boolean hasRecordPermission;
                ActivityInfo activityInfo = this.mDisplayResolveInfo.getResolveInfo().activityInfo;
                int uid = activityInfo.applicationInfo.uid;
                String packageName = activityInfo.packageName;
                boolean bl = hasRecordPermission = PermissionChecker.checkPermissionForPreflight(ResolverListAdapter.this.mContext, "android.permission.RECORD_AUDIO", -1, uid, packageName) == 0;
                if (!hasRecordPermission) {
                    return new CharSequence[]{pg.getLabel(), ResolverListAdapter.this.mContext.getString(17042043)};
                }
            }
            return new CharSequence[]{pg.getLabel(), pg.getSubLabel()};
        }

        @Override
        protected void onPostExecute(CharSequence[] result) {
            if (this.mDisplayResolveInfo.hasDisplayLabel()) {
                return;
            }
            this.mDisplayResolveInfo.setDisplayLabel(result[0]);
            this.mDisplayResolveInfo.setExtendedInfo(result[1]);
            ResolverListAdapter.this.notifyDataSetChanged();
        }
    }

    @VisibleForTesting
    public static class ActivityInfoPresentationGetter
    extends TargetPresentationGetter {
        private final ActivityInfo mActivityInfo;

        public ActivityInfoPresentationGetter(Context ctx, int iconDpi, ActivityInfo activityInfo) {
            super(ctx, iconDpi, activityInfo.applicationInfo);
            this.mActivityInfo = activityInfo;
        }

        @Override
        Drawable getIconSubstituteInternal() {
            Drawable dr = null;
            try {
                if (this.mActivityInfo.icon != 0) {
                    dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mActivityInfo.applicationInfo), this.mActivityInfo.icon);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(ResolverListAdapter.TAG, "SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON permission granted but couldn't find resources for package", e);
            }
            return dr;
        }

        @Override
        String getAppSubLabelInternal() {
            return (String)this.mActivityInfo.loadLabel(this.mPm);
        }

        @Override
        String getAppLabelForSubstitutePermission() {
            return this.getAppSubLabelInternal();
        }
    }

    private static abstract class TargetPresentationGetter {
        private Context mCtx;
        private final int mIconDpi;
        private final boolean mHasSubstitutePermission;
        private final ApplicationInfo mAi;
        protected PackageManager mPm;

        @Nullable
        abstract Drawable getIconSubstituteInternal();

        @Nullable
        abstract String getAppSubLabelInternal();

        @Nullable
        abstract String getAppLabelForSubstitutePermission();

        TargetPresentationGetter(Context ctx, int iconDpi, ApplicationInfo ai) {
            this.mCtx = ctx;
            this.mPm = ctx.getPackageManager();
            this.mAi = ai;
            this.mIconDpi = iconDpi;
            this.mHasSubstitutePermission = 0 == this.mPm.checkPermission("android.permission.SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON", this.mAi.packageName);
        }

        public Drawable getIcon(UserHandle userHandle) {
            return new BitmapDrawable(this.mCtx.getResources(), this.getIconBitmap(userHandle));
        }

        public Bitmap getIconBitmap(@Nullable UserHandle userHandle) {
            Drawable dr = null;
            if (this.mHasSubstitutePermission) {
                dr = this.getIconSubstituteInternal();
            }
            if (dr == null) {
                try {
                    if (this.mAi.icon != 0) {
                        dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mAi), this.mAi.icon);
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (dr == null) {
                dr = this.mAi.loadIcon(this.mPm);
            }
            SimpleIconFactory sif = SimpleIconFactory.obtain(this.mCtx);
            Bitmap icon = sif.createUserBadgedIconBitmap(dr, userHandle);
            sif.recycle();
            return icon;
        }

        public String getLabel() {
            String label = null;
            if (this.mHasSubstitutePermission) {
                label = this.getAppLabelForSubstitutePermission();
            }
            if (label == null) {
                label = (String)this.mAi.loadLabel(this.mPm);
            }
            return label;
        }

        public String getSubLabel() {
            if (this.mHasSubstitutePermission) {
                String appSubLabel = this.getAppSubLabelInternal();
                if (!TextUtils.isEmpty(appSubLabel) && !TextUtils.equals(appSubLabel, this.getLabel())) {
                    return appSubLabel;
                }
                return null;
            }
            return this.getAppSubLabelInternal();
        }

        protected String loadLabelFromResource(Resources res, int resId) {
            return res.getString(resId);
        }

        @Nullable
        protected Drawable loadIconFromResource(Resources res, int resId) {
            try {
                return res.getDrawableForDensity(resId, this.mIconDpi);
            }
            catch (Resources.NotFoundException e) {
                Log.e(ResolverListAdapter.TAG, "Resource not found", e);
                return null;
            }
        }
    }
}

