/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.dynamicanimation.animation;

import android.util.AndroidRuntimeException;
import android.util.FloatProperty;
import com.android.internal.dynamicanimation.animation.DynamicAnimation;
import com.android.internal.dynamicanimation.animation.FloatValueHolder;
import com.android.internal.dynamicanimation.animation.SpringForce;

public class SpringAnimation
extends DynamicAnimation<SpringAnimation> {
    private SpringForce mSpring = null;
    private float mPendingPosition = Float.MAX_VALUE;
    private static final float UNSET = Float.MAX_VALUE;
    private boolean mEndRequested = false;

    public SpringAnimation(FloatValueHolder floatValueHolder) {
        super(floatValueHolder);
    }

    public SpringAnimation(FloatValueHolder floatValueHolder, float finalPosition) {
        super(floatValueHolder);
        this.mSpring = new SpringForce(finalPosition);
    }

    public <K> SpringAnimation(K object, FloatProperty<K> property) {
        super(object, property);
    }

    public <K> SpringAnimation(K object, FloatProperty<K> property, float finalPosition) {
        super(object, property);
        this.mSpring = new SpringForce(finalPosition);
    }

    public SpringForce getSpring() {
        return this.mSpring;
    }

    public SpringAnimation setSpring(SpringForce force) {
        this.mSpring = force;
        return this;
    }

    @Override
    public void start() {
        this.sanityCheck();
        this.mSpring.setValueThreshold(this.getValueThreshold());
        super.start();
    }

    public void animateToFinalPosition(float finalPosition) {
        if (this.isRunning()) {
            this.mPendingPosition = finalPosition;
        } else {
            if (this.mSpring == null) {
                this.mSpring = new SpringForce(finalPosition);
            }
            this.mSpring.setFinalPosition(finalPosition);
            this.start();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.mPendingPosition != Float.MAX_VALUE) {
            if (this.mSpring == null) {
                this.mSpring = new SpringForce(this.mPendingPosition);
            } else {
                this.mSpring.setFinalPosition(this.mPendingPosition);
            }
            this.mPendingPosition = Float.MAX_VALUE;
        }
    }

    public void skipToEnd() {
        if (!this.canSkipToEnd()) {
            throw new UnsupportedOperationException("Spring animations can only come to an end when there is damping");
        }
        if (!this.isCurrentThread()) {
            throw new AndroidRuntimeException("Animations may only be started on the same thread as the animation handler");
        }
        if (this.mRunning) {
            this.mEndRequested = true;
        }
    }

    public boolean canSkipToEnd() {
        return this.mSpring.mDampingRatio > 0.0;
    }

    private void sanityCheck() {
        if (this.mSpring == null) {
            throw new UnsupportedOperationException("Incomplete SpringAnimation: Either final position or a spring force needs to be set.");
        }
        double finalPosition = this.mSpring.getFinalPosition();
        if (finalPosition > (double)this.mMaxValue) {
            throw new UnsupportedOperationException("Final position of the spring cannot be greater than the max value.");
        }
        if (finalPosition < (double)this.mMinValue) {
            throw new UnsupportedOperationException("Final position of the spring cannot be less than the min value.");
        }
    }

    @Override
    boolean updateValueAndVelocity(long deltaT) {
        if (this.mEndRequested) {
            if (this.mPendingPosition != Float.MAX_VALUE) {
                this.mSpring.setFinalPosition(this.mPendingPosition);
                this.mPendingPosition = Float.MAX_VALUE;
            }
            this.mValue = this.mSpring.getFinalPosition();
            this.mVelocity = 0.0f;
            this.mEndRequested = false;
            return true;
        }
        if (this.mPendingPosition != Float.MAX_VALUE) {
            DynamicAnimation.MassState massState = this.mSpring.updateValues(this.mValue, this.mVelocity, deltaT / 2L);
            this.mSpring.setFinalPosition(this.mPendingPosition);
            this.mPendingPosition = Float.MAX_VALUE;
            massState = this.mSpring.updateValues(massState.mValue, massState.mVelocity, deltaT / 2L);
            this.mValue = massState.mValue;
            this.mVelocity = massState.mVelocity;
        } else {
            DynamicAnimation.MassState massState = this.mSpring.updateValues(this.mValue, this.mVelocity, deltaT);
            this.mValue = massState.mValue;
            this.mVelocity = massState.mVelocity;
        }
        this.mValue = Math.max(this.mValue, this.mMinValue);
        this.mValue = Math.min(this.mValue, this.mMaxValue);
        if (this.isAtEquilibrium(this.mValue, this.mVelocity)) {
            this.mValue = this.mSpring.getFinalPosition();
            this.mVelocity = 0.0f;
            return true;
        }
        return false;
    }

    @Override
    float getAcceleration(float value, float velocity) {
        return this.mSpring.getAcceleration(value, velocity);
    }

    @Override
    boolean isAtEquilibrium(float value, float velocity) {
        return this.mSpring.isAtEquilibrium(value, velocity);
    }

    @Override
    void setValueThreshold(float threshold) {
    }
}

