/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.InputMethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InputMethodInfoSafeList
implements Parcelable {
    @Nullable
    private byte[] mBuffer;
    public static final Parcelable.Creator<InputMethodInfoSafeList> CREATOR = new Parcelable.Creator<InputMethodInfoSafeList>(){

        @Override
        public InputMethodInfoSafeList createFromParcel(Parcel in) {
            return new InputMethodInfoSafeList(in.readBlob());
        }

        public InputMethodInfoSafeList[] newArray(int size) {
            return new InputMethodInfoSafeList[size];
        }
    };

    @NonNull
    public static List<InputMethodInfo> extractFrom(@Nullable InputMethodInfoSafeList from) {
        InputMethodInfo[] array2;
        byte[] buf = from.mBuffer;
        from.mBuffer = null;
        if (buf != null && (array2 = InputMethodInfoSafeList.unmarshall(buf)) != null) {
            return new ArrayList<InputMethodInfo>(Arrays.asList(array2));
        }
        return new ArrayList<InputMethodInfo>();
    }

    @NonNull
    private static InputMethodInfo[] toArray(@Nullable List<InputMethodInfo> original) {
        if (original == null) {
            return new InputMethodInfo[0];
        }
        return original.toArray(new InputMethodInfo[0]);
    }

    @Nullable
    private static byte[] marshall(@NonNull InputMethodInfo[] array2) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.writeTypedArray(array2, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
    }

    @Nullable
    private static InputMethodInfo[] unmarshall(byte[] data) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            InputMethodInfo[] inputMethodInfoArray = parcel.createTypedArray(InputMethodInfo.CREATOR);
            return inputMethodInfoArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
    }

    private InputMethodInfoSafeList(@Nullable byte[] blob) {
        this.mBuffer = blob;
    }

    @NonNull
    public static InputMethodInfoSafeList create(@Nullable List<InputMethodInfo> list) {
        if (list == null || list.isEmpty()) {
            return InputMethodInfoSafeList.empty();
        }
        return new InputMethodInfoSafeList(InputMethodInfoSafeList.marshall(InputMethodInfoSafeList.toArray(list)));
    }

    @NonNull
    public static InputMethodInfoSafeList empty() {
        return new InputMethodInfoSafeList(null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBlob(this.mBuffer);
    }
}

