/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Formatter;
import java.util.Locale;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
@RavenwoodKeepWholeClass
public abstract class LoggingPrintStream
extends PrintStream {
    private final StringBuilder builder = new StringBuilder();
    private ByteBuffer encodedBytes;
    private CharBuffer decodedChars;
    private CharsetDecoder decoder;
    private final Formatter formatter = new Formatter(this.builder, null);

    protected LoggingPrintStream() {
        super(new OutputStream(){

            @Override
            public void write(int oneByte) throws IOException {
                throw new AssertionError();
            }
        });
    }

    protected abstract void log(String var1);

    @Override
    public synchronized void flush() {
        this.flush(true);
    }

    private void flush(boolean completely) {
        int nextBreak;
        int length = this.builder.length();
        int start = 0;
        while (start < length && (nextBreak = this.builder.indexOf("\n", start)) != -1) {
            this.log(this.builder.substring(start, nextBreak));
            start = nextBreak + 1;
        }
        if (completely) {
            if (start < length) {
                this.log(this.builder.substring(start));
            }
            this.builder.setLength(0);
        } else {
            this.builder.delete(0, start);
        }
    }

    @Override
    public void write(int oneByte) {
        this.write(new byte[]{(byte)oneByte}, 0, 1);
    }

    @Override
    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public synchronized void write(byte[] bytes, int start, int count) {
        if (this.decoder == null) {
            this.encodedBytes = ByteBuffer.allocate(80);
            this.decodedChars = CharBuffer.allocate(80);
            this.decoder = Charset.defaultCharset().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        int end = start + count;
        while (start < end) {
            CoderResult coderResult;
            int numBytes = Math.min(this.encodedBytes.remaining(), end - start);
            this.encodedBytes.put(bytes, start, numBytes);
            start += numBytes;
            this.encodedBytes.flip();
            do {
                coderResult = this.decoder.decode(this.encodedBytes, this.decodedChars, false);
                this.decodedChars.flip();
                this.builder.append(this.decodedChars);
                this.decodedChars.clear();
            } while (coderResult.isOverflow());
            this.encodedBytes.compact();
        }
        this.flush(false);
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    protected void setError() {
    }

    @Override
    public void close() {
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        return this.format(AndroidLocale.getDefault(), format, args);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public synchronized PrintStream format(Locale l, String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.formatter.format(l, format, args);
        this.flush(false);
        return this;
    }

    @Override
    public synchronized void print(char[] charArray) {
        this.builder.append(charArray);
        this.flush(false);
    }

    @Override
    public synchronized void print(char ch) {
        this.builder.append(ch);
        if (ch == '\n') {
            this.flush(false);
        }
    }

    @Override
    public synchronized void print(double dnum) {
        this.builder.append(dnum);
    }

    @Override
    public synchronized void print(float fnum) {
        this.builder.append(fnum);
    }

    @Override
    public synchronized void print(int inum) {
        this.builder.append(inum);
    }

    @Override
    public synchronized void print(long lnum) {
        this.builder.append(lnum);
    }

    @Override
    public synchronized void print(Object obj) {
        this.builder.append(obj);
        this.flush(false);
    }

    @Override
    public synchronized void print(String str) {
        this.builder.append(str);
        this.flush(false);
    }

    @Override
    public synchronized void print(boolean bool2) {
        this.builder.append(bool2);
    }

    @Override
    public synchronized void println() {
        this.flush(true);
    }

    @Override
    public synchronized void println(char[] charArray) {
        this.builder.append(charArray);
        this.flush(true);
    }

    @Override
    public synchronized void println(char ch) {
        this.builder.append(ch);
        this.flush(true);
    }

    @Override
    public synchronized void println(double dnum) {
        this.builder.append(dnum);
        this.flush(true);
    }

    @Override
    public synchronized void println(float fnum) {
        this.builder.append(fnum);
        this.flush(true);
    }

    @Override
    public synchronized void println(int inum) {
        this.builder.append(inum);
        this.flush(true);
    }

    @Override
    public synchronized void println(long lnum) {
        this.builder.append(lnum);
        this.flush(true);
    }

    @Override
    public synchronized void println(Object obj) {
        this.builder.append(obj);
        this.flush(true);
    }

    @Override
    public synchronized void println(String s) {
        if (this.builder.length() == 0 && s != null) {
            int nextBreak;
            int length = s.length();
            int start = 0;
            while (start < length && (nextBreak = s.indexOf(10, start)) != -1) {
                this.log(s.substring(start, nextBreak));
                start = nextBreak + 1;
            }
            if (start < length) {
                this.log(s.substring(start));
            }
        } else {
            this.builder.append(s);
            this.flush(true);
        }
    }

    @Override
    public synchronized void println(boolean bool2) {
        this.builder.append(bool2);
        this.flush(true);
    }

    @Override
    public synchronized PrintStream append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public synchronized PrintStream append(CharSequence csq) {
        this.builder.append(csq);
        this.flush(false);
        return this;
    }

    @Override
    public synchronized PrintStream append(CharSequence csq, int start, int end) {
        this.builder.append(csq, start, end);
        this.flush(false);
        return this;
    }
}

