/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.Nullable;
import android.os.Process;
import android.util.SparseArray;

public class ProcfsMemoryUtil {
    private static final int[] CMDLINE_OUT = new int[]{4096};
    private static final int[] OOM_SCORE_ADJ_OUT = new int[]{8202};
    private static final String[] STATUS_KEYS = new String[]{"Uid:", "VmHWM:", "VmRSS:", "RssAnon:", "RssShmem:", "VmSwap:"};
    private static final String[] VMSTAT_KEYS = new String[]{"oom_kill"};

    private ProcfsMemoryUtil() {
    }

    @Nullable
    public static MemorySnapshot readMemorySnapshotFromProcfs(int pid) {
        return ProcfsMemoryUtil.readMemorySnapshotFromProcfs("/proc/" + pid + "/status");
    }

    @Nullable
    public static MemorySnapshot readMemorySnapshotFromProcfs() {
        return ProcfsMemoryUtil.readMemorySnapshotFromProcfs("/proc/self/status");
    }

    private static MemorySnapshot readMemorySnapshotFromProcfs(String path) {
        long[] output = new long[STATUS_KEYS.length];
        output[0] = -1L;
        output[3] = -1L;
        output[4] = -1L;
        output[5] = -1L;
        Process.readProcLines(path, STATUS_KEYS, output);
        if (output[0] == -1L || output[3] == -1L || output[4] == -1L || output[5] == -1L) {
            return null;
        }
        MemorySnapshot snapshot = new MemorySnapshot();
        snapshot.uid = (int)output[0];
        snapshot.rssHighWaterMarkInKilobytes = (int)output[1];
        snapshot.rssInKilobytes = (int)output[2];
        snapshot.anonRssInKilobytes = (int)output[3];
        snapshot.rssShmemKilobytes = (int)output[4];
        snapshot.swapInKilobytes = (int)output[5];
        return snapshot;
    }

    public static String readCmdlineFromProcfs(int pid) {
        return ProcfsMemoryUtil.readCmdlineFromProcfs("/proc/" + pid + "/cmdline");
    }

    public static String readCmdlineFromProcfs() {
        return ProcfsMemoryUtil.readCmdlineFromProcfs("/proc/self/cmdline");
    }

    private static String readCmdlineFromProcfs(String path) {
        String[] cmdline = new String[1];
        if (!Process.readProcFile(path, CMDLINE_OUT, cmdline, null, null)) {
            return "";
        }
        return cmdline[0];
    }

    public static int readOomScoreAdjFromProcfs(int pid) {
        return ProcfsMemoryUtil.readOomScoreAdjFromProcfs("/proc/" + pid + "/oom_score_adj");
    }

    public static int readOomScoreAdjFromProcfs() {
        return ProcfsMemoryUtil.readOomScoreAdjFromProcfs("/proc/self/oom_score_adj");
    }

    private static int readOomScoreAdjFromProcfs(String path) {
        long[] oom_score_adj = new long[1];
        if (Process.readProcFile(path, OOM_SCORE_ADJ_OUT, null, oom_score_adj, null)) {
            return (int)oom_score_adj[0];
        }
        return 0;
    }

    public static SparseArray<String> getProcessCmdlines() {
        int[] pids = new int[1024];
        pids = Process.getPids("/proc", pids);
        SparseArray<String> cmdlines = new SparseArray<String>(pids.length);
        for (int pid : pids) {
            if (pid < 0) break;
            String cmdline = ProcfsMemoryUtil.readCmdlineFromProcfs(pid);
            if (cmdline.isEmpty()) continue;
            cmdlines.append(pid, cmdline);
        }
        return cmdlines;
    }

    @Nullable
    public static VmStat readVmStat() {
        long[] vmstat = new long[VMSTAT_KEYS.length];
        vmstat[0] = -1L;
        Process.readProcLines("/proc/vmstat", VMSTAT_KEYS, vmstat);
        if (vmstat[0] == -1L) {
            return null;
        }
        VmStat result = new VmStat();
        result.oomKillCount = (int)vmstat[0];
        return result;
    }

    public static class MemorySnapshot {
        public int uid;
        public int rssHighWaterMarkInKilobytes;
        public int rssInKilobytes;
        public int anonRssInKilobytes;
        public int swapInKilobytes;
        public int rssShmemKilobytes;
    }

    public static class VmStat {
        public int oomKillCount;
    }
}

