/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.IntentFilter;
import android.content.pm.parsing.FrameworkParsingPackageUtils;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import android.util.ArraySet;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags;
import com.android.internal.pm.pkg.component.ParsedComponent;
import com.android.internal.pm.pkg.component.ParsedComponentImpl;
import com.android.internal.pm.pkg.component.ParsedComponentUtils;
import com.android.internal.pm.pkg.component.ParsedIntentInfo;
import com.android.internal.pm.pkg.component.ParsedPermissionImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class ComponentParseUtils {
    public static boolean isImplicitlyExposedIntent(ParsedIntentInfo intentInfo) {
        IntentFilter intentFilter = intentInfo.getIntentFilter();
        return intentFilter.hasCategory("android.intent.category.BROWSABLE") || intentFilter.hasAction("android.intent.action.SEND") || intentFilter.hasAction("android.intent.action.SENDTO") || intentFilter.hasAction("android.intent.action.SEND_MULTIPLE");
    }

    static <Component extends ParsedComponentImpl> ParseResult<Component> parseAllMetaData(ParsingPackage pkg, Resources res, XmlResourceParser parser, String tag, Component component, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        boolean shouldParseValidPurposes = Flags.purposeDeclarationEnabled() && component instanceof ParsedPermissionImpl && "android".equals(pkg.getPackageName());
        ArraySet<String> validPurposes = new ArraySet<String>();
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<String> result;
            if (type != 2) continue;
            if (ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if ("meta-data".equals(parser.getName())) {
                result = ParsedComponentUtils.addMetaData(component, pkg, res, parser, input);
            } else if (shouldParseValidPurposes && "valid-purpose".equals(parser.getName())) {
                ParseResult<String> validPurposeResult;
                result = validPurposeResult = ComponentParseUtils.parseValidPurpose(res, parser, input);
                if (validPurposeResult.isSuccess() && validPurposeResult.getResult() != null) {
                    validPurposes.add(validPurposeResult.getResult());
                }
            } else {
                result = ParsingUtils.unknownTag(tag, pkg, parser, input);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (!validPurposes.isEmpty()) {
            ParsedPermissionImpl permission2 = (ParsedPermissionImpl)component;
            permission2.setValidPurposes(validPurposes);
        }
        return input.success(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<String> parseValidPurpose(Resources res, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestValidPurpose);
        try {
            String validPurpose = sa.getString(0);
            ParseResult<String> parseResult = input.success(TextUtils.isEmpty(validPurpose) ? null : validPurpose);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    @NonNull
    public static ParseResult<String> buildProcessName(@NonNull String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, ParseInput input) {
        if ((flags & 2) != 0 && !"system".contentEquals(procSeq)) {
            return input.success(defProc != null ? defProc : pkg);
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.contentEquals(procSeq)) continue;
                return input.success(pkg);
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return input.success(defProc);
        }
        ParseResult<String> nameResult = ComponentParseUtils.buildCompoundName(pkg, procSeq, "process", input);
        return input.success(TextUtils.safeIntern(nameResult.getResult()));
    }

    @NonNull
    public static ParseResult<String> buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, ParseInput input) {
        if (procSeq == null) {
            return input.success(defProc);
        }
        if (procSeq.length() <= 0) {
            return input.success(null);
        }
        return ComponentParseUtils.buildCompoundName(pkg, procSeq, "taskAffinity", input);
    }

    public static ParseResult<String> buildCompoundName(String pkg, CharSequence procSeq, String type, ParseInput input) {
        ParseResult nameResult;
        String proc = procSeq.toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                return input.error("Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters");
            }
            String subName = proc.substring(1);
            ParseResult nameResult2 = FrameworkParsingPackageUtils.validateName(input, subName, false, false);
            if (nameResult2.isError()) {
                return input.error("Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameResult2.getErrorMessage());
            }
            return input.success(pkg + proc);
        }
        if (!"system".equals(proc) && (nameResult = FrameworkParsingPackageUtils.validateName(input, proc, true, false)).isError()) {
            return input.error("Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameResult.getErrorMessage());
        }
        return input.success(proc);
    }

    public static int flag(int flag, int attribute, TypedArray typedArray) {
        return typedArray.getBoolean(attribute, false) ? flag : 0;
    }

    public static int flag(int flag, int attribute, boolean defaultValue, TypedArray typedArray) {
        return typedArray.getBoolean(attribute, defaultValue) ? flag : 0;
    }

    @Nullable
    public static CharSequence getNonLocalizedLabel(ParsedComponent component) {
        return component.getNonLocalizedLabel();
    }

    public static int getIcon(ParsedComponent component) {
        return component.getIcon();
    }
}

